/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.simantics.browsing.ui.swt.widgets.TrackedCombo;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.SysdynResource;

public class ArrayExpressionCombo
extends TrackedCombo {
    int lastSelectedIndex = -2;

    public ArrayExpressionCombo(Composite parent, WidgetSupport support, int style) {
        super(parent, support, style);
        this.setItemFactory((ReadFactory)new ReadFactoryImpl<Resource, Map<String, Object>>(){

            public Map<String, Object> perform(ReadGraph graph, Resource input) throws DatabaseException {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                if (input == null) {
                    return map;
                }
                Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                String name = (String)graph.getPossibleRelatedValue(input, l0.HasName);
                if (name == null) {
                    return map;
                }
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                String defaultRange = ArrayExpressionCombo.getDefaultRange(graph, input);
                for (Resource expression : ArrayExpressionCombo.this.getExpressions(graph, input)) {
                    String arrayRange = (String)graph.getPossibleRelatedValue(expression, sr.Expression_arrayRange);
                    if (arrayRange != null) {
                        map.put(String.valueOf(name) + arrayRange, expression);
                        continue;
                    }
                    if (defaultRange != null) {
                        map.put(String.valueOf(name) + defaultRange, expression);
                        continue;
                    }
                    map.put(name, expression);
                }
                if (map.isEmpty()) {
                    map.put(name, input);
                }
                return map;
            }
        });
        this.setSelectionFactory((ReadFactory)new ReadFactoryImpl<Resource, String>(){

            public String perform(ReadGraph graph, Resource input) throws DatabaseException {
                Resource expression;
                String name = (String)graph.getPossibleRelatedValue(input, Layer0.getInstance((ReadGraph)graph).HasName);
                if (name == null) {
                    return "";
                }
                String defaultRange = ArrayExpressionCombo.getDefaultRange(graph, input);
                if (defaultRange == null) {
                    return name;
                }
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                Resource activeExpression = graph.getPossibleObject(input, sr.IndependentVariable_activeExpression);
                if (activeExpression == null) {
                    ArrayList expressions = ArrayExpressionCombo.this.getExpressions(graph, input);
                    if (expressions == null || expressions.isEmpty()) {
                        return name;
                    }
                    expression = (Resource)expressions.get(0);
                } else {
                    expression = activeExpression;
                }
                String range = (String)graph.getPossibleRelatedValue(expression, sr.Expression_arrayRange);
                if (range != null) {
                    return String.valueOf(name) + range;
                }
                return String.valueOf(name) + defaultRange;
            }
        });
    }

    public void setInput(ISessionContext context, Object input) {
        super.setInput(context, input);
        if (this.selectionFactory != null) {
            this.selectionFactory.listen(context, input, (Listener)new Listener<String>(){

                public void execute(final String result) {
                    if (ArrayExpressionCombo.this.getWidget().isDisposed()) {
                        return;
                    }
                    ArrayExpressionCombo.this.getWidget().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Object o;
                            Combo combo = ArrayExpressionCombo.this.getWidget();
                            if (combo != null && !combo.isDisposed() && result != null && (o = ArrayExpressionCombo.this.getWidget().getData(result)) != null) {
                                (this).ArrayExpressionCombo.this.lastSelectedIndex = (Integer)o;
                            }
                        }
                    });
                }

                public void exception(Throwable t) {
                    t.printStackTrace();
                }

                public boolean isDisposed() {
                    return ArrayExpressionCombo.this.getWidget().isDisposed();
                }
            });
        }
    }

    private ArrayList<Resource> getExpressions(ReadGraph graph, Resource variable) throws DatabaseException {
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        Resource hasExpressions = graph.getPossibleObject(variable, sr.Variable_expressionList);
        if (hasExpressions == null) {
            return new ArrayList<Resource>();
        }
        return new ArrayList<Resource>(ListUtils.toList((ReadGraph)graph, (Resource)hasExpressions));
    }

    public static String getDefaultRange(ReadGraph graph, Resource variable) throws DatabaseException {
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        Resource hasArrayIndexes = graph.getPossibleObject(variable, sr.Variable_arrayIndexesList);
        if (hasArrayIndexes == null) {
            return null;
        }
        Iterator iterator = ListUtils.toList((ReadGraph)graph, (Resource)hasArrayIndexes).iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        while (iterator.hasNext()) {
            sb.append(NameUtils.getSafeName((ReadGraph)graph, (Resource)((Resource)iterator.next())));
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public int getLastSelectedIndex() {
        return this.lastSelectedIndex;
    }

    public void setLastSelectedIndex(int lastSelectedIndex) {
        this.lastSelectedIndex = lastSelectedIndex;
    }
}

