/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.handlers.imports;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.datastructures.Pair;

public class ImportExternalFunctionFilesHandler
extends AbstractHandler {
    public static final String[] C_EXTENSIONS = new String[]{"*.c", "*.h", "*.a", "*.o"};

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
        Pair<String, String[]> selected = ImportExternalFunctionFilesHandler.importFiles(shell, "Import...", C_EXTENSIONS);
        if (selected.second == null || ((String[])selected.second).length < 1) {
            return null;
        }
        SimanticsUI.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
            }
        });
        return null;
    }

    public static Pair<String, String[]> importFiles(Shell shell, String text, String[] filter) {
        FileDialog fd = new FileDialog(shell, 4096);
        fd.setText(text);
        fd.setFilterPath(Platform.getLocation().toOSString());
        fd.setFilterExtensions(filter);
        fd.open();
        return new Pair((Object)fd.getFilterPath(), (Object)fd.getFileNames());
    }

    public static void addFilesToFunction(WriteGraph graph, Resource function, Pair<String, String[]> files) throws DatabaseException {
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        if (!graph.isInstanceOf(function, sr.SysdynModelicaFunction)) {
            return;
        }
        String[] stringArray = (String[])files.second;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            File file = new File((String)files.first, filename);
            String name = file.getName();
            Resource externalFile = GraphUtils.create2((WriteGraph)graph, (Resource)sr.ExternalFunctionFile, (Object[])new Object[]{l0.PartOf, function, l0.HasName, name});
            try {
                byte[] fileBArray = new byte[(int)file.length()];
                FileInputStream fis = new FileInputStream(file);
                fis.read(fileBArray);
                graph.claimLiteral(externalFile, sr.ExternalFunctionFile_externalFile, (Object)fileBArray, (Binding)Bindings.BYTE_ARRAY);
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }
}

