/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.trend.configuration;

import java.util.ArrayList;
import java.util.List;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.RecordType;
import org.simantics.history.util.subscription.SamplingFormat;

public class TrendSamplingFormats {
    public static final SamplingFormat analog_all;
    public static final SamplingFormat analog_100ms;
    public static final SamplingFormat analog_1s;
    public static final SamplingFormat analog_10s;
    public static final SamplingFormat analog_60s;
    public static final SamplingFormat analog_minmax;
    public static final SamplingFormat binary_all;
    public static final SamplingFormat binary_100ms;
    public static final SamplingFormat binary_1s;
    public static final SamplingFormat binary_10s;
    public static final SamplingFormat binary_60s;
    public static final SamplingFormat time;
    public static final String all = "all";
    public static final String _100ms = "100ms";
    public static final String _1s = "1s";
    public static final String _10s = "10s";
    public static final String _60s = "60s";
    public static final String minmax = "minmax";

    static {
        time = new SamplingFormat();
        TrendSamplingFormats.time.format = new RecordType();
        RecordType format = TrendSamplingFormats.time.format;
        format.addComponent("time", (Datatype)Datatypes.DOUBLE);
        format.addComponent("value", (Datatype)Datatypes.DOUBLE);
        format.addComponent("quality", (Datatype)Datatypes.BYTE);
        TrendSamplingFormats.time.interval = Double.NaN;
        TrendSamplingFormats.time.deadband = Double.NaN;
        analog_all = new SamplingFormat();
        TrendSamplingFormats.analog_all.formatId = all;
        TrendSamplingFormats.analog_all.format = new RecordType();
        format = TrendSamplingFormats.analog_all.format;
        format.addComponent("time", (Datatype)Datatypes.DOUBLE);
        format.addComponent("endTime", (Datatype)Datatypes.DOUBLE);
        format.addComponent("value", (Datatype)Datatypes.DOUBLE);
        format.addComponent("quality", (Datatype)Datatypes.BYTE);
        TrendSamplingFormats.analog_all.interval = Double.NaN;
        TrendSamplingFormats.analog_all.deadband = Double.NaN;
        analog_1s = new SamplingFormat();
        TrendSamplingFormats.analog_1s.formatId = _1s;
        TrendSamplingFormats.analog_1s.format = new RecordType();
        TrendSamplingFormats.analog_1s.format = new RecordType();
        format = TrendSamplingFormats.analog_1s.format;
        format.addComponent("time", (Datatype)Datatypes.DOUBLE);
        format.addComponent("endTime", (Datatype)Datatypes.DOUBLE);
        format.addComponent("value", (Datatype)Datatypes.DOUBLE);
        format.addComponent("min", (Datatype)Datatypes.DOUBLE);
        format.addComponent("max", (Datatype)Datatypes.DOUBLE);
        format.addComponent("avg", (Datatype)Datatypes.DOUBLE);
        format.addComponent("quality", (Datatype)Datatypes.BYTE);
        TrendSamplingFormats.analog_1s.interval = 1.0;
        TrendSamplingFormats.analog_1s.deadband = Double.NaN;
        analog_100ms = analog_1s.cloneTo(_100ms, 0.1, Double.NaN);
        analog_10s = analog_1s.cloneTo(_10s, 10.0, Double.NaN);
        analog_60s = analog_10s.cloneTo(_60s, 60.0, Double.NaN);
        analog_minmax = new SamplingFormat();
        TrendSamplingFormats.analog_minmax.formatId = minmax;
        TrendSamplingFormats.analog_minmax.format = new RecordType();
        format = TrendSamplingFormats.analog_minmax.format;
        format.addComponent("time", (Datatype)Datatypes.DOUBLE);
        format.addComponent("endTime", (Datatype)Datatypes.DOUBLE);
        format.addComponent("value", (Datatype)Datatypes.DOUBLE);
        format.addComponent("min", (Datatype)Datatypes.DOUBLE);
        format.addComponent("max", (Datatype)Datatypes.DOUBLE);
        TrendSamplingFormats.analog_minmax.interval = Double.MAX_VALUE;
        TrendSamplingFormats.analog_minmax.deadband = Double.MAX_VALUE;
        binary_all = new SamplingFormat();
        TrendSamplingFormats.binary_all.formatId = all;
        TrendSamplingFormats.binary_all.format = new RecordType();
        format = TrendSamplingFormats.binary_all.format;
        format.addComponent("time", (Datatype)Datatypes.DOUBLE);
        format.addComponent("endTime", (Datatype)Datatypes.DOUBLE);
        format.addComponent("value", (Datatype)Datatypes.BYTE);
        format.addComponent("max", (Datatype)Datatypes.BYTE);
        format.addComponent("quality", (Datatype)Datatypes.BYTE);
        TrendSamplingFormats.binary_all.interval = Double.NaN;
        TrendSamplingFormats.binary_all.deadband = Double.NaN;
        binary_1s = new SamplingFormat();
        TrendSamplingFormats.binary_1s.formatId = _1s;
        TrendSamplingFormats.binary_1s.format = new RecordType();
        format = TrendSamplingFormats.binary_1s.format;
        format.addComponent("time", (Datatype)Datatypes.DOUBLE);
        format.addComponent("endTime", (Datatype)Datatypes.DOUBLE);
        format.addComponent("value", (Datatype)Datatypes.BYTE);
        format.addComponent("max", (Datatype)Datatypes.BYTE);
        format.addComponent("quality", (Datatype)Datatypes.BYTE);
        TrendSamplingFormats.binary_1s.interval = 1.0;
        TrendSamplingFormats.binary_1s.deadband = Double.NaN;
        binary_100ms = binary_1s.cloneTo(_100ms, 0.1, Double.NaN);
        binary_10s = binary_1s.cloneTo(_10s, 10.0, Double.NaN);
        binary_60s = binary_1s.cloneTo(_60s, 60.0, Double.NaN);
    }

    public static List<SamplingFormat> createAnalogSamplingFormats(double interval, double deadband, String unit) {
        ArrayList<SamplingFormat> result = new ArrayList<SamplingFormat>(6);
        result.add(analog_minmax);
        if (interval == 0.0 && deadband == 0.0) {
            result.add(analog_all.clone().setUnit(unit));
            result.add(analog_100ms.clone().setUnit(unit));
            result.add(analog_1s.clone().setUnit(unit));
            result.add(analog_10s.clone().setUnit(unit));
            result.add(analog_60s.clone().setUnit(unit));
            return result;
        }
        if (interval < 0.1) {
            result.add(analog_all.clone(interval, deadband).setUnit(unit));
            result.add(analog_100ms.clone(0.1, deadband).setUnit(unit));
            result.add(analog_1s.clone(1.0, deadband).setUnit(unit));
            result.add(analog_10s.clone(10.0, deadband).setUnit(unit));
            result.add(analog_60s.clone(60.0, deadband).setUnit(unit));
            return result;
        }
        if (interval < 1.0) {
            result.add(analog_100ms.clone(interval, deadband).setUnit(unit));
            result.add(analog_1s.clone(1.0, deadband).setUnit(unit));
            result.add(analog_10s.clone(10.0, deadband).setUnit(unit));
            result.add(analog_60s.clone(60.0, deadband).setUnit(unit));
            return result;
        }
        if (interval < 10.0) {
            result.add(analog_1s.clone(interval, deadband).setUnit(unit));
            result.add(analog_10s.clone(10.0, deadband).setUnit(unit));
            result.add(analog_60s.clone(60.0, deadband).setUnit(unit));
            return result;
        }
        if (interval < 60.0) {
            result.add(analog_10s.clone(interval, deadband).setUnit(unit));
            result.add(analog_60s.clone(60.0, deadband).setUnit(unit));
            return result;
        }
        result.add(analog_60s.clone(interval, deadband).setUnit(unit));
        return result;
    }

    public static List<SamplingFormat> createBinarySamplingFormats(double interval) {
        ArrayList<SamplingFormat> result = new ArrayList<SamplingFormat>(5);
        if (interval == 0.0) {
            result.add(binary_all);
            result.add(binary_100ms);
            result.add(binary_1s);
            result.add(binary_10s);
            result.add(binary_60s);
            return result;
        }
        if (interval < 1.0) {
            result.add(binary_all.clone(interval, Double.NaN));
            result.add(binary_100ms);
            result.add(binary_1s);
            result.add(binary_10s);
            result.add(binary_60s);
            return result;
        }
        if (interval < 1.0) {
            result.add(binary_100ms.clone(interval, Double.NaN));
            result.add(binary_1s);
            result.add(binary_10s);
            result.add(binary_60s);
            return result;
        }
        if (interval < 10.0) {
            result.add(binary_1s.clone(interval, Double.NaN));
            result.add(binary_10s);
            result.add(binary_60s);
            return result;
        }
        if (interval < 60.0) {
            result.add(binary_10s.clone(interval, Double.NaN));
            result.add(binary_60s);
            return result;
        }
        result.add(binary_60s.clone(interval, Double.NaN));
        return result;
    }
}

