/*
 * Decompiled with CFR 0.152.
 */
package fi.semantum.sysdyn.solver;

import fi.semantum.sysdyn.solver.Argument;
import fi.semantum.sysdyn.solver.ArgumentList;
import fi.semantum.sysdyn.solver.Array;
import fi.semantum.sysdyn.solver.Assignment;
import fi.semantum.sysdyn.solver.Declaration;
import fi.semantum.sysdyn.solver.EnumElementsVariableBase;
import fi.semantum.sysdyn.solver.EnumSizeVariableBase;
import fi.semantum.sysdyn.solver.ExecutionException;
import fi.semantum.sysdyn.solver.Fn;
import fi.semantum.sysdyn.solver.Frame;
import fi.semantum.sysdyn.solver.Function;
import fi.semantum.sysdyn.solver.IEnvironment;
import fi.semantum.sysdyn.solver.IExpression;
import fi.semantum.sysdyn.solver.IFrame;
import fi.semantum.sysdyn.solver.ParameterDeclaration;
import fi.semantum.sysdyn.solver.SolverUtils;
import fi.semantum.sysdyn.solver.Variable;
import fi.semantum.sysdyn.solver.VariableBase;
import fi.semantum.sysdyn.solver.VariableDeclaration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.simantics.utils.datastructures.MapList;

class Model
implements IFrame {
    public static final boolean PRINT = false;
    public boolean initial = false;
    public ArrayList<Assignment> initials = new ArrayList();
    public ArrayList<Assignment> assignments = new ArrayList();
    public ArrayList<Assignment> derivatives = new ArrayList();
    public ArrayList<ParameterDeclaration> parameters = new ArrayList();
    public ArrayList<VariableDeclaration> variables = new ArrayList();
    public Map<String, Fn> functions = new HashMap<String, Fn>();
    public Map<String, VariableBase> copies;
    public Assignment[] assignmentArray;
    public Assignment[] derivativeArray;
    public ParameterDeclaration[] parameterArray;
    public final Globals globals;
    public int line = -1;
    public boolean isEnumClass;
    private String name;
    private int size;
    public HashMap<String, VariableBase> names = new HashMap();

    public Model(Globals globals, String name, boolean isEnumClass) {
        this.globals = globals;
        this.name = name;
        this.isEnumClass = isEnumClass;
    }

    public void addVariable(VariableDeclaration vd) {
        this.variables.add(vd);
    }

    public Fn getFunction(String name) {
        return this.functions.get(name);
    }

    @Override
    public VariableBase getBase(VariableBase original, String prefix) {
        VariableBase base = this.names.get(String.valueOf(prefix) + original.name);
        if (base != null) {
            return base;
        }
        base = original.withBase(prefix);
        this.names.put(base.name, base);
        return base;
    }

    @Override
    public VariableBase getBase(String name) {
        VariableBase base = this.names.get(name);
        if (base == null) {
            if (this.isEnumClass) {
                if ("size".equals(name)) {
                    base = new EnumSizeVariableBase(this);
                } else if ("elements".equals(name)) {
                    base = new EnumElementsVariableBase(this);
                }
            }
            if (base == null) {
                base = new VariableBase(name);
            }
            this.names.put(name, base);
        }
        return base;
    }

    private void reportException(Fn fn, ExecutionException e) throws ExecutionException {
        if (fn instanceof Function) {
            throw new ExecutionException("function " + this.name + ": " + (e.line - ((Function)fn).line) + ": " + e.getMessage());
        }
        throw new ExecutionException("function " + this.name + ": " + (e.line - ((Function)fn).line) + ": " + e.getMessage());
    }

    public Object evaluateFunction(IEnvironment environment, String name, ArgumentList args) {
        Fn fn = this.getFunction(name);
        if (fn == null && (fn = this.functions.get(name)) == null) {
            throw new RuntimeException("Undefined function '" + name + "'");
        }
        if ("delay".equals(name)) {
            Frame frame = new Frame(environment, fn.offset());
            ArrayList<Object> argh = new ArrayList<Object>();
            argh.add(args.args[0].modification.toString());
            int i = 0;
            while (i < args.args.length) {
                argh.add(args.args[i].modification.evaluate(environment));
                ++i;
            }
            Variable[] parameters = fn.parameters(argh.size());
            int i2 = 0;
            while (i2 < args.args.length + 1) {
                Variable var = parameters[i2];
                Object value = argh.get(i2);
                var.assignPlain(frame, value);
                ++i2;
            }
            fn.setLocals(frame);
            try {
                return fn.evaluate(frame, args.args.length + 1);
            }
            catch (ExecutionException e) {
                this.reportException(fn, e);
            }
        } else {
            Frame frame = new Frame(environment, fn.offset());
            ArrayList<Object> argh = new ArrayList<Object>();
            int i = 0;
            while (i < args.args.length) {
                Object arg = args.args[i].modification.evaluate(environment);
                if (arg == null) {
                    throw new IllegalStateException("No value for " + args.args[i].modification);
                }
                argh.add(arg);
                ++i;
            }
            Variable[] parameters = fn.parameters(args.args.length);
            Object[] ps = new Object[parameters.length];
            boolean[] vector = new boolean[parameters.length];
            int vectorDimension = 0;
            ArrayList<Array> arrs = new ArrayList<Array>();
            int i3 = 0;
            while (i3 < parameters.length) {
                Variable var = parameters[i3];
                ps[i3] = i3 < argh.size() ? argh.get(i3) : fn.evaluateInput(environment, i3);
                if (var.base.dimensions == null && ps[i3] instanceof Array) {
                    int dim = ((Array)ps[i3]).dimension();
                    if (vectorDimension > 0 && dim != vectorDimension) {
                        throw new IllegalStateException("Array dimensions do not agree");
                    }
                    vectorDimension = dim;
                    vector[i3] = true;
                    arrs.add((Array)ps[i3]);
                } else {
                    vector[i3] = false;
                }
                ++i3;
            }
            if (vectorDimension > 0) {
                return this.arrayEvaluate(frame, fn, parameters, ps, vector, arrs);
            }
            i3 = 0;
            while (i3 < parameters.length) {
                parameters[i3].assignPlain(frame, ps[i3]);
                ++i3;
            }
            fn.setLocals(frame);
            try {
                return fn.evaluate(frame, args.args.length);
            }
            catch (ExecutionException e) {
                this.reportException(fn, e);
            }
        }
        throw new IllegalStateException();
    }

    private Array arrayEvaluate(Frame frame, Fn fn, Variable[] parameters, Object[] ps, boolean[] vector, List<Array> arrs) {
        Array result = new Array();
        Array first = arrs.get(0);
        int d = first.elements().size();
        if (d == 0) {
            return result;
        }
        Object firstElement = first.element(0);
        boolean subArray = firstElement instanceof Array;
        int i = 0;
        while (i < d) {
            int vectorIndex = 0;
            if (subArray) {
                ArrayList<Array> subArrs = new ArrayList<Array>();
                int j = 0;
                while (j < parameters.length) {
                    if (vector[j]) {
                        Array a = arrs.get(vectorIndex++);
                        Array sub = (Array)a.element(i);
                        subArrs.add(sub);
                    }
                    ++j;
                }
                result.addElement(this.arrayEvaluate(frame, fn, parameters, ps, vector, subArrs));
            } else {
                int j = 0;
                while (j < parameters.length) {
                    if (vector[j]) {
                        Array a = arrs.get(vectorIndex++);
                        Object sub = a.element(i);
                        parameters[j].assignPlain(frame, sub);
                    } else {
                        parameters[j].assignPlain(frame, ps[j]);
                    }
                    ++j;
                }
                fn.setLocals(frame);
                Object ret = fn.evaluate(frame, parameters.length);
                result.addElement(ret);
            }
            ++i;
        }
        return result;
    }

    private VariableBase resolveCopy(Map<String, VariableBase> work, VariableBase target) {
        VariableBase deep = work.get(target.name);
        if (deep == null) {
            return target;
        }
        return this.resolveCopy(work, deep);
    }

    private void rewrite() {
        Variable var;
        ArrayList<ParameterDeclaration> parameterCopies = new ArrayList<ParameterDeclaration>();
        ArrayList<Assignment> variableCopies = new ArrayList<Assignment>();
        HashMap<String, VariableBase> work = new HashMap<String, VariableBase>();
        for (ParameterDeclaration pd : this.parameters) {
            if (!(pd.modification instanceof Variable)) continue;
            var = (Variable)pd.modification;
            if (!SolverUtils.isFullSubscript(var.subscripts) || !SolverUtils.isFullSubscript(pd.variable.subscripts)) continue;
            parameterCopies.add(pd);
            work.put(pd.variable.base.name, var.base);
        }
        for (Assignment ass : this.assignments) {
            if (!(ass.expression instanceof Variable)) continue;
            var = (Variable)ass.expression;
            if (!SolverUtils.isFullSubscript(var.subscripts) || !SolverUtils.isFullSubscript(ass.target.subscripts)) continue;
            variableCopies.add(ass);
            work.put(ass.target.base.name, var.base);
        }
        this.parameters.removeAll(parameterCopies);
        this.assignments.removeAll(variableCopies);
        this.copies = new TreeMap<String, VariableBase>();
        for (String key : work.keySet()) {
            VariableBase b = this.resolveCopy(work, (VariableBase)work.get(key));
            this.copies.put(key, b);
        }
        for (VariableDeclaration vd : this.variables) {
            vd.modification = vd.modification.rewrite(this, this.copies);
            vd.variable = (Variable)vd.variable.rewrite(this, this.copies);
        }
        for (ParameterDeclaration pd : this.parameters) {
            pd.modification = pd.modification.rewrite(this, this.copies);
        }
        for (Assignment ass : this.assignments) {
            ass.expression = ass.expression.rewrite(this, this.copies);
        }
        for (Assignment ass : this.derivatives) {
            ass.expression = ass.expression.rewrite(this, this.copies);
        }
        for (Assignment ass : this.initials) {
            ass.expression = ass.expression.rewrite(this, this.copies);
        }
    }

    public int prepare() {
        this.rewrite();
        boolean done = true;
        int i = 0;
        while (i < 50) {
            done = true;
            for (VariableDeclaration vd : this.variables) {
                done &= vd.variable.base.tellSubscripts(vd.variable.subscripts, null);
            }
            for (ParameterDeclaration pd : this.parameters) {
                done &= pd.variable.base.tellSubscripts(pd.variable.subscripts, pd.modification);
            }
            if (done) break;
            ++i;
        }
        if (!done) {
            throw new IllegalStateException();
        }
        this.size = 0;
        for (Map.Entry<String, VariableBase> entry : this.names.entrySet()) {
            VariableBase base = entry.getValue();
            base.index = this.size;
            int dim = base.dimension();
            if (dim == -1) {
                dim = 1;
            }
            this.size += dim;
        }
        return this.size;
    }

    public int getSize() {
        return this.size;
    }

    public void prettyPrint() {
        System.err.println("initials");
        for (Assignment assignment : this.initials) {
            System.err.println("-" + assignment);
        }
        System.err.println("assignments");
        for (Assignment assignment : this.assignments) {
            System.err.println("-" + assignment);
        }
        System.err.println("derivatives");
        for (Assignment assignment : this.derivatives) {
            System.err.println("-" + assignment);
        }
        System.err.println("parameters");
        for (ParameterDeclaration parameterDeclaration : this.parameters) {
            System.err.println("-" + parameterDeclaration);
        }
        System.err.println("variables");
        for (VariableDeclaration variableDeclaration : this.variables) {
            System.err.println("-" + variableDeclaration);
        }
        System.err.println("functions");
        for (Map.Entry entry : this.functions.entrySet()) {
            System.err.println("-" + (String)entry.getKey() + " " + entry.getValue());
        }
    }

    @Override
    public Model getClass(String name) {
        return this.globals.classes.get(name);
    }

    public boolean instantiateClass(String type_specifier, Declaration decl, IFrame currentFrame) {
        Model clazz = this.globals.classes.get(type_specifier);
        if (clazz == null) {
            return false;
        }
        HashMap<String, IExpression> modifications = new HashMap<String, IExpression>();
        if (decl.modification instanceof ArgumentList) {
            ArgumentList args = (ArgumentList)decl.modification;
            Argument[] argumentArray = args.args;
            int n = args.args.length;
            int n2 = 0;
            while (n2 < n) {
                Argument a = argumentArray[n2];
                modifications.put(a.name, a.modification);
                ++n2;
            }
        }
        for (VariableDeclaration vd : clazz.variables) {
            String base = String.valueOf(decl.variable.base.name) + ".";
            Variable var2 = vd.variable.withBase(currentFrame, base);
            VariableDeclaration vd2 = new VariableDeclaration(var2, vd.direction, vd.type, vd.modification.withBase(currentFrame, base));
            this.variables.add(vd2);
        }
        for (ParameterDeclaration pd : clazz.parameters) {
            ParameterDeclaration pd2;
            Variable var2;
            IExpression modi = (IExpression)modifications.get(pd.variable.base.name);
            if (modi != null) {
                String base = String.valueOf(decl.variable.base.name) + ".";
                var2 = pd.variable.withBase(currentFrame, base);
                var2.subscripts = null;
                pd2 = new ParameterDeclaration(var2, modi);
                this.parameters.add(pd2);
                modifications.remove(pd.variable.base.name);
                continue;
            }
            String base = String.valueOf(decl.variable.base.name) + ".";
            var2 = pd.variable.withBase(currentFrame, base);
            pd2 = new ParameterDeclaration(var2, pd.modification.withBase(currentFrame, base));
            this.parameters.add(pd2);
        }
        if (!modifications.isEmpty()) {
            throw new IllegalStateException();
        }
        for (Assignment ass : clazz.assignments) {
            Assignment ass2 = ass.withBase(currentFrame, String.valueOf(decl.variable.base.name) + ".");
            this.assignments.add(ass2);
        }
        for (Assignment ass : clazz.initials) {
            Assignment ass2 = ass.withBase(currentFrame, String.valueOf(decl.variable.base.name) + ".");
            this.initials.add(ass2);
        }
        for (Assignment ass : clazz.derivatives) {
            Assignment ass2 = ass.withBase(currentFrame, String.valueOf(decl.variable.base.name) + ".");
            this.derivatives.add(ass2);
        }
        return true;
    }

    public void prepareFunctions() {
        for (Fn fn : this.functions.values()) {
            if (!(fn instanceof Function)) continue;
            ((Function)fn).prepare();
        }
    }

    public void sortAssignments() {
        final MapList asses = new MapList();
        for (Assignment ass : this.assignments) {
            asses.add((Object)ass.target.base.name, (Object)ass);
        }
        final ArrayList found = new ArrayList();
        final HashSet visited = new HashSet();
        IExpression.ExpressionVisitor sortVisitor = new IExpression.ExpressionVisitor(){

            @Override
            public void visit(IExpression expression) {
                if (expression instanceof Variable) {
                    Variable var = (Variable)expression;
                    if (visited.add(var.base.name)) {
                        for (Assignment ass : asses.getValues((Object)var.base.name)) {
                            ass.expression.accept(this);
                            if (ass.subscripts == null) continue;
                            IExpression[] iExpressionArray = ass.subscripts;
                            int n = ass.subscripts.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IExpression e = iExpressionArray[n2];
                                e.accept(this);
                                ++n2;
                            }
                        }
                        found.add(var.base);
                    }
                }
            }
        };
        for (Assignment ass : this.assignments) {
            ass.target.accept(sortVisitor);
        }
        Collections.sort(this.assignments, new Comparator<Assignment>(){

            @Override
            public int compare(Assignment o1, Assignment o2) {
                int i2;
                int i1 = found.indexOf(o1.target.base);
                if (i1 < (i2 = found.indexOf(o2.target.base))) {
                    return -1;
                }
                if (i1 > i2) {
                    return 1;
                }
                return 0;
            }
        });
        this.assignmentArray = this.assignments.toArray(new Assignment[this.assignments.size()]);
        this.derivativeArray = this.derivatives.toArray(new Assignment[this.derivatives.size()]);
        this.parameterArray = this.parameters.toArray(new ParameterDeclaration[this.parameters.size()]);
    }

    static class Globals {
        public Map<String, Model> classes = new HashMap<String, Model>();

        Globals() {
        }
    }
}

