/*
 * Decompiled with CFR 0.152.
 */
package fi.semantum.sysdyn.solver;

import fi.semantum.sysdyn.solver.Model;
import fi.semantum.sysdyn.solver.NodeCache;
import fi.semantum.sysdyn.solver.Parser;
import fi.semantum.sysdyn.solver.parser.ModelParser;
import fi.semantum.sysdyn.solver.parser.Node;
import fi.semantum.sysdyn.solver.parser.SimpleNode;
import java.io.StringReader;

public class LineReader {
    public static final boolean PRINT = false;
    private State state = State.FUNCTIONS;
    StringBuilder functions = new StringBuilder();
    int startPos = 0;
    int pos = 0;
    final char[] chars;
    final NodeCache cache;
    final Model model;
    final Parser parser;

    public LineReader(String input, NodeCache cache) {
        this.chars = input.toCharArray();
        this.cache = cache;
        this.model = new Model(new Model.Globals(), "", false);
        this.parser = new Parser();
    }

    public void parseFunctions(String line) throws Exception {
        if (line.startsWith("class")) {
            String text = this.functions.toString();
            Node node = this.cache.getNode(text);
            if (node == null) {
                StringReader reader = new StringReader(this.functions.toString());
                ModelParser modelParser = new ModelParser(reader);
                node = modelParser.parse();
                this.cache.store(text, (SimpleNode)node);
            }
            this.parser.walk((SimpleNode)node, 0, this.model);
            this.state = State.PARAMETERS;
            return;
        }
        this.functions.append(line);
        this.functions.append("\n");
    }

    public void parseParameters(String line) throws Exception {
        if ("initial equation".equals(line)) {
            this.state = State.INITIALS;
            return;
        }
        if ("equation".equals(line)) {
            this.state = State.EQUATIONS;
            return;
        }
        Node node = this.cache.getNode(line);
        if (node == null) {
            StringReader reader = new StringReader(line);
            ModelParser modelParser = new ModelParser(reader);
            node = modelParser.element();
            this.cache.store(line, (SimpleNode)node);
        }
        this.parser.walk((SimpleNode)node, 0, this.model);
    }

    public void parseInitials(String line) throws Exception {
        if (line.startsWith("equation")) {
            this.state = State.EQUATIONS;
            return;
        }
        if (line.startsWith("end")) {
            this.state = State.STOP;
            return;
        }
        this.model.initial = true;
        Node node = this.cache.getNode(line);
        if (node == null) {
            StringReader reader = new StringReader(line);
            ModelParser modelParser = new ModelParser(reader);
            node = modelParser.equation();
            this.cache.store(line, (SimpleNode)node);
        }
        this.parser.walk((SimpleNode)node, 0, this.model);
    }

    public void parseEquations(String line) throws Exception {
        if (line.startsWith("end")) {
            this.state = State.STOP;
            return;
        }
        this.model.initial = false;
        Node node = this.cache.getNode(line);
        if (node == null) {
            StringReader reader = new StringReader(line);
            ModelParser modelParser = new ModelParser(reader);
            node = modelParser.equation();
            this.cache.store(line, (SimpleNode)node);
        }
        this.parser.walk((SimpleNode)node, 0, this.model);
    }

    public void parseLine(String line) throws Exception {
        switch (this.state) {
            case FUNCTIONS: {
                this.parseFunctions(line);
                break;
            }
            case PARAMETERS: {
                this.parseParameters(line);
                break;
            }
            case INITIALS: {
                this.parseInitials(line);
                break;
            }
            case EQUATIONS: {
                this.parseEquations(line);
                break;
            }
        }
    }

    public void parse() throws Exception {
        while (this.pos < this.chars.length) {
            if (this.chars[this.pos] == '\r') {
                String line = new String(this.chars, this.startPos, this.pos - this.startPos);
                this.parseLine(line);
                ++this.pos;
                this.startPos = this.pos + 1;
            }
            ++this.pos;
        }
    }

    static enum State {
        FUNCTIONS,
        PARAMETERS,
        INITIALS,
        EQUATIONS,
        STOP;

    }
}

