/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench;

import org.eclipse.core.runtime.Assert;
import org.eclipse.ui.IViewPart;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.InvalidResourceReferenceException;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.ui.workbench.ResourceInput;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public final class ResourceViewPartUtils {
    public static IViewPart activateViewForResource(String viewId, Session ls, Resource inputResource) throws Exception {
        return ResourceViewPartUtils.activateViewForResource(viewId, ls, inputResource, null);
    }

    public static IViewPart activateViewForResource(String viewId, Session ls, Resource inputResource, String suffix) throws Exception {
        Assert.isNotNull((Object)viewId);
        Assert.isNotNull((Object)ls);
        Assert.isNotNull((Object)inputResource);
        ResourceInput input = ResourceViewPartUtils.newViewInput(ls, inputResource, suffix);
        String param = String.valueOf(viewId) + ":" + input.marshall();
        return WorkbenchUtils.activateView((String)param);
    }

    public static IViewPart activateViewForResourceInPerspective(String viewId, String perspectiveId, Session ls, Resource inputResource, String suffix) throws Exception {
        Assert.isNotNull((Object)viewId);
        Assert.isNotNull((Object)ls);
        Assert.isNotNull((Object)inputResource);
        if (perspectiveId != null) {
            WorkbenchUtils.showPerspective((String)perspectiveId);
        }
        return ResourceViewPartUtils.activateViewForResource(viewId, ls, inputResource, suffix);
    }

    public static IViewPart newViewForResource(String viewId, Session ls, Resource inputResource, String suffix) throws Exception {
        ResourceInput input = ResourceViewPartUtils.newViewInput(ls, inputResource, suffix);
        String param = String.valueOf(viewId) + ":" + input.marshall();
        return WorkbenchUtils.activateView((String)param);
    }

    public static ResourceInput newViewInput(Session ls, Resource r, String suffix) throws InvalidResourceReferenceException {
        String randomAccessId = ResourceViewPartUtils.getRandomAccessId(ls, r);
        return new ResourceInput(randomAccessId, suffix);
    }

    public static String getRandomAccessId(Session s, Resource r) throws InvalidResourceReferenceException {
        SerialisationSupport support = (SerialisationSupport)s.getService(SerialisationSupport.class);
        return support.getResourceSerializer().createRandomAccessId(r);
    }
}

