/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench;

import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.simantics.db.ReadGraph;
import org.simantics.db.Session;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.event.ChangeEvent;
import org.simantics.db.event.ChangeListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.db.service.GraphChangeListenerSupport;
import org.simantics.ui.SimanticsUI;

public abstract class GraphAccessViewPart
extends ViewPart {
    private IMemento memento;
    private ChangeListener graphChangeListener;
    protected ISessionContext sessionContext;
    protected Session session;

    public <A> A getAdapter(Class<A> adapter) {
        if (adapter == Session.class) {
            return (A)this.getSession();
        }
        return (A)super.getAdapter(adapter);
    }

    public IStatusLineManager getStatusLineManager() {
        IViewSite site = this.getViewSite();
        IActionBars bars = site.getActionBars();
        IStatusLineManager mgr = bars.getStatusLineManager();
        return mgr;
    }

    public void setStatusMessage(String message) {
        this.getStatusLineManager().setMessage(message);
    }

    public void setStatusErrorMessage(String message) {
        this.getStatusLineManager().setErrorMessage(message);
    }

    public IMemento getLastMemento() {
        return this.memento;
    }

    public IMemento consumeLastMemento() {
        IMemento m = this.memento;
        this.memento = null;
        return m;
    }

    public void createPartControl(Composite parent) {
        this.initialize();
    }

    public void dispose() {
        this.cleanup();
        super.dispose();
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    protected ISessionContext getSessionContext() {
        return this.sessionContext;
    }

    protected Session getSession() {
        return this.session;
    }

    protected void initializeSession() {
        this.sessionContext = SimanticsUI.getSessionContext();
        if (this.sessionContext == null) {
            throw new IllegalStateException("no active session context");
        }
        this.session = this.sessionContext.getSession();
    }

    protected void initialize() {
        this.initializeSession();
        this.graphChangeListener = this.getGraphChangeListener();
        if (this.graphChangeListener != null) {
            GraphChangeListenerSupport support = (GraphChangeListenerSupport)this.session.getService(GraphChangeListenerSupport.class);
            support.addListener(this.graphChangeListener);
        }
    }

    protected ChangeListener getGraphChangeListener() {
        return new ChangeListenerImpl();
    }

    protected void cleanup() {
        if (this.session != null) {
            Session s = this.session;
            this.session = null;
            if (this.graphChangeListener != null) {
                GraphChangeListenerSupport support = (GraphChangeListenerSupport)s.getService(GraphChangeListenerSupport.class);
                support.removeListener(this.graphChangeListener);
                this.graphChangeListener = null;
            }
        }
    }

    protected void update(ChangeEvent event) throws DatabaseException {
        this.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph g) {
                GraphAccessViewPart.this.reload(g);
            }
        });
    }

    public void updateTitle() {
        String partName = this.getTitleText();
        if (partName != null) {
            this.setPartName(partName);
        }
        this.setTitleToolTip(this.getTitleTooltip());
    }

    protected String getTitleText() {
        return null;
    }

    protected String getTitleTooltip() {
        return null;
    }

    public abstract void reload(ReadGraph var1);

    class ChangeListenerImpl
    implements ChangeListener {
        ChangeListenerImpl() {
        }

        public void graphChanged(ChangeEvent e) throws DatabaseException {
            GraphAccessViewPart.this.update(e);
        }
    }
}

