/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.common.processors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.SelectionRequest;
import org.simantics.browsing.ui.Tester;
import org.simantics.browsing.ui.common.NodeContextUtil;
import org.simantics.browsing.ui.common.Testers;
import org.simantics.browsing.ui.common.processors.AbstractNodeQueryProcessor;
import org.simantics.browsing.ui.content.ContributionViewpoint;
import org.simantics.browsing.ui.content.Viewpoint;
import org.simantics.browsing.ui.content.ViewpointContribution;
import org.simantics.browsing.ui.content.ViewpointContributionFactory;

public class DefaultViewpointContributionsProcessor
extends AbstractNodeQueryProcessor<Collection<ViewpointContribution>> {
    public static final Collection<ViewpointContribution> EMPTY = Collections.emptyList();

    public NodeContext.QueryKey<Collection<ViewpointContribution>> getIdentifier() {
        return BuiltinKeys.VIEWPOINT_CONTRIBUTIONS;
    }

    private String extractFilterString(Collection<SelectionRequest> requests) {
        if (requests == null) {
            return null;
        }
        for (SelectionRequest request : requests) {
            if (!SelectionRequest.Request.FILTER.equals((Object)request.getRequest())) continue;
            return (String)request.getData();
        }
        return null;
    }

    private String adjustFilter(String filter) {
        if (filter == null) {
            return null;
        }
        String[] tokens = filter.split(" ");
        StringBuilder b = new StringBuilder();
        boolean first = true;
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (token.startsWith("$")) {
                if (first) {
                    first = false;
                } else {
                    b.append(" ");
                }
                b.append(token.substring(1));
            }
            ++n2;
        }
        return b.toString();
    }

    public Collection<ViewpointContribution> query(NodeQueryManager manager, NodeContext context_) {
        final Viewpoint viewpoint = (Viewpoint)manager.query(context_, BuiltinKeys.SELECTED_VIEWPOINT);
        if (viewpoint == null) {
            return EMPTY;
        }
        if (viewpoint instanceof ContributionViewpoint) {
            String filterString = null;
            Collection selectionRequests = (Collection)manager.query(context_, BuiltinKeys.SELECTION_REQUESTS);
            filterString = this.extractFilterString(selectionRequests);
            String adjustedFilter = this.adjustFilter(filterString);
            NodeContext context = NodeContextUtil.withConstant(context_, BuiltinKeys.FILTER, adjustedFilter);
            ArrayList<ViewpointContribution> result = new ArrayList<ViewpointContribution>();
            ContributionViewpoint contributionViewpoint = (ContributionViewpoint)viewpoint;
            for (ViewpointContributionFactory factory : contributionViewpoint.getContributions()) {
                result.add((ViewpointContribution)manager.query(context, (NodeContext.PrimitiveQueryKey)new BuiltinKeys.ViewpointContributionKey(factory)));
            }
            return result;
        }
        ViewpointContribution contribution = new ViewpointContribution(){

            public Collection<NodeContext> getContribution() {
                ArrayList<NodeContext> result = new ArrayList<NodeContext>();
                NodeContext[] nodeContextArray = viewpoint.getChildren();
                int n = nodeContextArray.length;
                int n2 = 0;
                while (n2 < n) {
                    NodeContext context = nodeContextArray[n2];
                    result.add(context);
                    ++n2;
                }
                return result;
            }

            public Tester getNodeContextTester() {
                return Testers.PASS;
            }

            public Class<?> getInputClass() {
                return Object.class;
            }
        };
        return Collections.singletonList(contribution);
    }

    @Override
    public String toString() {
        return "ViewpointContributionsProcessor";
    }
}

