/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.common.extension;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IFilter;
import org.simantics.browsing.ui.common.extension.EvaluatorFactory;
import org.simantics.browsing.ui.common.extension.internal.EvaluatorBindingExtension;
import org.simantics.browsing.ui.common.extension.internal.EvaluatorImplementationBinding;
import org.simantics.browsing.ui.common.extension.internal.EvaluatorReferenceBinding;
import org.simantics.utils.strings.StringUtils;

public class EvaluatorBindingExtensionManager
implements IExtensionChangeHandler {
    private static final String NAMESPACE = "org.simantics.browsing.ui.common";
    private static final String EP_NAME = "evaluatorBinding";
    private ExtensionTracker tracker;
    private EvaluatorBindingExtension[] extensions = new EvaluatorBindingExtension[0];
    private static EvaluatorBindingExtensionManager INSTANCE;

    public static synchronized EvaluatorBindingExtensionManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EvaluatorBindingExtensionManager();
        }
        return INSTANCE;
    }

    public static synchronized void dispose() {
        if (INSTANCE != null) {
            INSTANCE.close();
            INSTANCE = null;
        }
    }

    private EvaluatorBindingExtensionManager() {
        this.tracker = new ExtensionTracker();
        IExtensionPoint expt = Platform.getExtensionRegistry().getExtensionPoint(NAMESPACE, EP_NAME);
        this.loadExtensions(expt.getConfigurationElements());
        IFilter filter = ExtensionTracker.createExtensionPointFilter((IExtensionPoint)expt);
        this.tracker.registerHandler((IExtensionChangeHandler)this, filter);
    }

    private void close() {
        this.tracker.close();
        this.tracker = null;
        this.extensions = new EvaluatorBindingExtension[0];
    }

    public EvaluatorBindingExtension[] getExtensions() {
        return this.extensions;
    }

    private void loadExtensions(IConfigurationElement[] elements) {
        HashSet<EvaluatorBindingExtension> newExtensions = new HashSet<EvaluatorBindingExtension>(Arrays.asList(this.extensions));
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            EvaluatorBindingExtension ext;
            IConfigurationElement child;
            IConfigurationElement el = iConfigurationElementArray[n2];
            String browseContext = StringUtils.safeString((String)el.getAttribute("browseContext"));
            IConfigurationElement[] iConfigurationElementArray2 = el.getChildren("reference");
            int n3 = iConfigurationElementArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                child = iConfigurationElementArray2[n4];
                String factoryId = StringUtils.safeString((String)child.getAttribute("id"));
                ext = new EvaluatorReferenceBinding(browseContext, factoryId);
                this.tracker.registerObject(el.getDeclaringExtension(), (Object)ext, 0);
                newExtensions.add(ext);
                ++n4;
            }
            iConfigurationElementArray2 = el.getChildren("implementation");
            n3 = iConfigurationElementArray2.length;
            n4 = 0;
            while (n4 < n3) {
                child = iConfigurationElementArray2[n4];
                try {
                    EvaluatorFactory factory = (EvaluatorFactory)child.createExecutableExtension("class");
                    ext = new EvaluatorImplementationBinding(browseContext, factory);
                    this.tracker.registerObject(el.getDeclaringExtension(), (Object)ext, 0);
                    newExtensions.add(ext);
                }
                catch (CoreException e) {
                    System.out.println(" == Could not load ViewpointContributionFactory '" + child.getAttribute("class") + "' due to the following error: " + e.getMessage());
                }
                ++n4;
            }
            ++n2;
        }
        this.extensions = newExtensions.toArray(new EvaluatorBindingExtension[newExtensions.size()]);
    }

    public void addExtension(IExtensionTracker tracker, IExtension extension) {
        this.loadExtensions(extension.getConfigurationElements());
    }

    public void removeExtension(IExtension extension, Object[] objects) {
        HashSet<EvaluatorBindingExtension> newExtensions = new HashSet<EvaluatorBindingExtension>(Arrays.asList(this.extensions));
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            this.tracker.unregisterObject(extension, o);
            newExtensions.remove(o);
            ++n2;
        }
        this.extensions = newExtensions.toArray(new EvaluatorBindingExtension[newExtensions.size()]);
    }

    public Collection<EvaluatorFactory> getBoundFactories(Set<String> browseContexts) {
        HashSet<EvaluatorFactory> result = new HashSet<EvaluatorFactory>();
        EvaluatorBindingExtension[] evaluatorBindingExtensionArray = this.getExtensions();
        int n = evaluatorBindingExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            EvaluatorFactory factory;
            EvaluatorBindingExtension binding = evaluatorBindingExtensionArray[n2];
            if (browseContexts.contains(binding.getBrowseContext()) && (factory = binding.getFactory()) != null) {
                result.add(factory);
            }
            ++n2;
        }
        return result;
    }
}

