/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.selectionview;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.db.common.procedure.adapter.ListenerSupport;
import org.simantics.db.management.ISessionContext;
import org.simantics.selectionview.IPropertyTab2;

public abstract class PropertyTabAdapter
implements IPropertyTab2,
ListenerSupport {
    protected IWorkbenchSite site;
    private final AtomicBoolean disposed = new AtomicBoolean();

    public PropertyTabAdapter(IWorkbenchSite site) {
        this.site = site;
    }

    @Override
    public final void createControl(Composite parent, ISessionContext context) {
        this.createControls(parent, context);
        Control control = this.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PropertyTabAdapter.this.setDisposed();
            }
        });
    }

    public void createControls(Composite parent, ISessionContext context) {
        Control control = this.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PropertyTabAdapter.this.setDisposed();
            }
        });
    }

    @Override
    public void dispose() {
    }

    protected boolean setDisposed() {
        return this.disposed.compareAndSet(false, true);
    }

    @Override
    public boolean isDisposed() {
        return this.disposed.get();
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return null;
    }

    @Override
    public void requestFocus() {
        Control control = this.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        control.setFocus();
    }

    public void exception(Throwable t) {
        ErrorLogger.defaultLogError((String)"PropertyTabAdapter received unexpected exception.", (Throwable)t);
    }
}

