/*
 * Decompiled with CFR 0.152.
 */
package fi.semantum.sysdyn.solver;

import fi.semantum.sysdyn.solver.Array;
import fi.semantum.sysdyn.solver.Constant;
import fi.semantum.sysdyn.solver.ExecutionException;
import fi.semantum.sysdyn.solver.IEnvironment;
import fi.semantum.sysdyn.solver.IExpression;
import fi.semantum.sysdyn.solver.IFrame;
import fi.semantum.sysdyn.solver.Model;
import fi.semantum.sysdyn.solver.SolverUtils;
import fi.semantum.sysdyn.solver.Utils;
import fi.semantum.sysdyn.solver.VariableBase;
import fi.semantum.sysdyn.solver.VariableDeclaration;
import java.util.Map;

public class Variable
implements IExpression {
    public VariableBase base;
    public IExpression[] subscripts = null;
    public int line = -1;
    public VariableDeclaration decl = null;
    public int constantIndex = -2;

    public Variable(IFrame frame, String name, IExpression[] subscripts, int line) {
        this.base = frame.getBase(name);
        this.subscripts = subscripts;
        this.line = line;
    }

    public static Object make(IFrame frame, String name, IExpression[] subscripts, int line) {
        return new Variable(frame, name, subscripts, line);
    }

    public Variable(VariableBase base) {
        this.base = base;
    }

    public Variable(VariableBase base, IExpression[] subscripts) {
        this.base = base;
        this.subscripts = subscripts;
    }

    public VariableDeclaration getDeclaration(Model model) {
        if (this.decl == null) {
            for (VariableDeclaration d : model.variables) {
                if (!d.variable.base.name.equals(this.base.name)) continue;
                this.decl = d;
                break;
            }
        }
        return this.decl;
    }

    public String toString() {
        return String.valueOf(this.base.name) + this.subscriptString();
    }

    private String subscriptString() {
        if (this.subscripts == null || this.subscripts.length < 1) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        str.append('[');
        int i = 0;
        while (i < this.subscripts.length) {
            IExpression sub;
            if (i > 0) {
                str.append(", ");
            }
            if ((sub = this.subscripts[i]) instanceof Constant) {
                str.append(((Double)((Constant)sub).value).intValue());
            } else if (sub instanceof Variable) {
                str.append(((Variable)sub).base.name);
            }
            ++i;
        }
        str.append(']');
        return str.toString();
    }

    public int assignArray(IEnvironment env, int index, Array value, int asd) {
        int i = 0;
        while (i < value.elements().size()) {
            Object element = value.element(i);
            if (element instanceof Double) {
                env.put(index + asd++, (Object)((Double)element));
            } else if (element instanceof Constant) {
                Constant c = (Constant)element;
                env.put(index + asd++, (Object)((Double)c.value));
            } else if (element instanceof Array) {
                asd = this.assignArray(env, index, (Array)element, asd);
            } else {
                throw new UnsupportedOperationException();
            }
            ++i;
        }
        return asd;
    }

    public void setArrayIndex(IEnvironment environment, Array array, Object value) {
        int i = 0;
        while (i < this.subscripts.length - 1) {
            IExpression e = this.subscripts[i];
            int index = Utils.getIndex(e.evaluate(environment));
            array.ensureIndex(index, true);
            array = (Array)array.element(index);
            ++i;
        }
        IExpression e = this.subscripts[this.subscripts.length - 1];
        int index = Utils.getIndex(e.evaluate(environment));
        array.ensureIndex(index, false);
        if (value instanceof IExpression) {
            IExpression exp = (IExpression)value;
            array.setElement(index, exp.evaluate(environment));
        } else {
            array.setElement(index, value);
        }
    }

    public void assignPlain(IEnvironment env, Object value) {
        env.put(this.base.index, value);
    }

    private int subscriptLength() {
        if (this.subscripts == null) {
            return 1;
        }
        return this.subscripts.length;
    }

    private void validateSize(IEnvironment env, IExpression[] subscripts, Object value) {
        if (value == null) {
            return;
        }
        if (this.base.isStoredAsArray(env)) {
            return;
        }
        int fullDimension = this.base.dimension();
        if (fullDimension == 1) {
            Array arr;
            int arrSize;
            if (!(value instanceof Double) && (arrSize = (arr = (Array)value).dimension()) != 1) {
                throw new ExecutionException("Trying to assign an array into a scalar variable");
            }
        } else if (subscripts == null) {
            if (this.base.dimensions.length == this.subscriptLength() && value instanceof Double) {
                return;
            }
            if (!(value instanceof Array)) {
                throw new IllegalStateException();
            }
            Array arr = (Array)value;
            int arrDim = arr.dimension();
            if (arrDim != fullDimension) {
                throw new IllegalStateException();
            }
        } else if (value instanceof Array) {
            Array arr = (Array)value;
            if (!arr.validateDimensions(this.base.dimensions, 0)) {
                throw new IllegalStateException();
            }
        } else {
            if (this.base.dimensions.length == subscripts.length && value instanceof Double) {
                return;
            }
            throw new IllegalStateException();
        }
    }

    public void assign(IEnvironment env, IExpression[] subscripts, Object value) {
        this.validateSize(env, subscripts, value);
        if (value instanceof Array) {
            if (this.base.isStoredAsArray(env)) {
                if (SolverUtils.isFullSubscript(subscripts)) {
                    env.put(this.base.index(env, subscripts), value);
                } else {
                    Array[] indices = SolverUtils.parseSubscripts(env, subscripts);
                    Array current = (Array)env.getValue(this.base.index);
                    current.applyPartial(indices, (Array)value);
                    env.put(this.base.index, (Object)current);
                }
            } else {
                this.assignArray(env, this.base.index(env, subscripts), (Array)value, 0);
            }
        } else if (this.base.isStoredAsArray(env)) {
            Object _existing = env.getValue(this.base.index);
            Array existing = (Array)_existing;
            if (existing == null) {
                existing = new Array();
                env.put(this.base.index, (Object)existing);
            }
            this.setArrayIndex(env, existing, value);
        } else {
            env.put(this.base.index(env, subscripts), value);
        }
    }

    @Override
    public Object evaluate(IEnvironment environment) {
        try {
            if (this.constantIndex == -2) {
                this.constantIndex = this.base.getConstantIndex(environment, this.subscripts);
            }
            return this.base.evaluate(environment, this.subscripts, this.constantIndex);
        }
        catch (ExecutionException e) {
            throw new ExecutionException(String.valueOf(this.base.name) + ": " + e.getMessage(), this.line);
        }
    }

    @Override
    public Variable withBase(IFrame frame, String prefix) {
        if (this.subscripts != null) {
            IExpression[] subscripts2 = new IExpression[this.subscripts.length];
            int i = 0;
            while (i < this.subscripts.length) {
                subscripts2[i] = this.subscripts[i].withBase(frame, prefix);
                ++i;
            }
            return new Variable(frame.getBase(this.base, prefix), subscripts2);
        }
        return new Variable(frame.getBase(this.base, prefix), null);
    }

    @Override
    public IExpression getPossibleConstant() {
        return this.base.getPossibleConstant();
    }

    @Override
    public IExpression rewrite(IFrame frame, Map<String, VariableBase> copies) {
        VariableBase copy = copies.get(this.base.name);
        if (copy == null) {
            if (this.subscripts != null) {
                int i = 0;
                while (i < this.subscripts.length) {
                    this.subscripts[i] = this.subscripts[i].rewrite(frame, copies);
                    ++i;
                }
            }
            return this;
        }
        return new Variable(frame.getBase(copy.name), this.subscripts).rewrite(frame, copies);
    }

    @Override
    public void accept(IExpression.ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

