/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.util.concurrent.Semaphore;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.UnaryQuery;
import org.simantics.db.procedure.ListenerBase;

public final class ValueQuery
extends UnaryQuery<InternalProcedure<byte[]>> {
    private ValueQuery(int resource) {
        super(resource);
    }

    static final ValueQuery entry(QueryProcessor provider, int r) {
        return (ValueQuery)provider.valueMap.get(r);
    }

    static final byte[] runner(ReadGraphImpl graph, int r, CacheEntry parent, ListenerBase listener, InternalProcedure<byte[]> procedure) {
        QueryProcessor processor = graph.processor;
        ValueQuery entry = (ValueQuery)processor.valueMap.get(r);
        if (entry == null) {
            entry = new ValueQuery(r);
            entry.setPending();
            entry.clearResult(processor.querySupport);
            entry.putEntry(processor);
            return (byte[])processor.performForEach(graph, entry, parent, listener, procedure);
        }
        return (byte[])processor.performForEach(graph, entry, parent, listener, procedure);
    }

    public static final byte[] queryEach(ReadGraphImpl graph, int r, CacheEntry parent, ListenerBase listener, InternalProcedure<byte[]> procedure) {
        assert (r != 0);
        if (graph.parent == null && listener == null) {
            return ValueQuery.computeForEach(graph, r, null, procedure);
        }
        return ValueQuery.runner(graph, r, parent, listener, procedure);
    }

    public static final byte[] queryEach(ReadGraphImpl graph, int r, CacheEntry parent) {
        assert (r != 0);
        if (graph.parent == null) {
            return ValueQuery.computeForEach(graph, r);
        }
        return ValueQuery.runner(graph, r, parent, null, null);
    }

    @Override
    public UnaryQuery<InternalProcedure<byte[]>> getEntry(QueryProcessor provider) {
        return provider.valueMap.get(this.id);
    }

    @Override
    public void putEntry(QueryProcessor provider) {
        provider.valueMap.put(this.id, this);
    }

    @Override
    public final void removeEntry(QueryProcessor provider) {
        provider.valueMap.remove(this.id);
    }

    public static byte[] computeForEach(ReadGraphImpl graph, int r, ValueQuery entry, InternalProcedure<byte[]> procedure) {
        graph.ensureLoaded(r);
        byte[] value = graph.getValue(r);
        if (entry != null) {
            entry.setResult(value);
            entry.setReady();
        }
        if (procedure != null) {
            procedure.execute(graph, value);
        }
        return value;
    }

    public static byte[] computeForEach(ReadGraphImpl graph, int r) {
        graph.ensureLoaded(r);
        return graph.getValue(r);
    }

    @Override
    public Object computeForEach(ReadGraphImpl graph, QueryProcessor queryProvider, InternalProcedure<byte[]> procedure, boolean store) {
        return ValueQuery.computeForEach(graph, this.id, this, procedure);
    }

    public String toString() {
        return "Value[" + this.id + "]";
    }

    @Override
    public Object performFromCache(ReadGraphImpl graph, QueryProcessor queryProvider, InternalProcedure<byte[]> procedure) {
        return this.computeForEach(graph, queryProvider, procedure, false);
    }

    @Override
    public void recompute(ReadGraphImpl graph, QueryProcessor provider) {
        final Semaphore s = new Semaphore(0);
        this.computeForEach(graph, provider, new InternalProcedure<byte[]>(){

            @Override
            public void execute(ReadGraphImpl graph, byte[] result) {
                s.release();
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                throw new Error("Error in recompute.", t);
            }
        }, true);
        while (!s.tryAcquire()) {
            provider.resume(graph);
        }
    }

    @Override
    boolean isImmutable(ReadGraphImpl graph) {
        return graph.processor.isImmutable(this.id);
    }
}

