/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.util.concurrent.Semaphore;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.IntProcedureAdapter;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.CollectionUnaryQuery;
import org.simantics.db.impl.query.IntArray;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySupport;
import org.simantics.db.impl.query.UnaryQuery;
import org.simantics.db.procedure.ListenerBase;

public final class DirectPredicates
extends CollectionUnaryQuery<IntProcedure> {
    private DirectPredicates(int resource) {
        super(resource);
    }

    static final DirectPredicates entry(QueryProcessor provider, int r) {
        return (DirectPredicates)provider.directPredicatesMap.get(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void runner(ReadGraphImpl graph, int r, QueryProcessor provider, CacheEntry parent, ListenerBase listener, IntProcedure procedure) {
        DirectPredicates entry = (DirectPredicates)provider.directPredicatesMap.get(r);
        if (entry == null) {
            entry = new DirectPredicates(r);
            entry.setPending();
            entry.clearResult(provider.querySupport);
            entry.putEntry(provider);
            provider.performForEach(graph, entry, parent, listener, procedure);
        } else {
            if (!entry.isReady()) {
                DirectPredicates directPredicates = entry;
                synchronized (directPredicates) {
                    if (!entry.isReady()) {
                        provider.registerDependencies(graph, entry, parent, listener, procedure, false);
                        entry.computeForEach(graph, provider, procedure, true);
                        return;
                    }
                }
            }
            provider.performForEach(graph, entry, parent, listener, procedure);
        }
    }

    public static final void queryEach(ReadGraphImpl graph, int r, QueryProcessor provider, CacheEntry parent, ListenerBase listener, IntProcedure procedure) {
        if (parent == null && listener == null) {
            DirectPredicates entry = (DirectPredicates)provider.directPredicatesMap.get(r);
            if (entry != null && entry.isReady()) {
                entry.performFromCache(graph, provider, procedure);
                return;
            }
            DirectPredicates.computeForEach(graph, r, null, procedure, false);
            return;
        }
        DirectPredicates.runner(graph, r, provider, parent, listener, procedure);
    }

    @Override
    public void clearResult(QuerySupport support) {
        this.setResult(INVALID_RESULT);
    }

    @Override
    public UnaryQuery<IntProcedure> getEntry(QueryProcessor provider) {
        return provider.directPredicatesMap.get(this.id);
    }

    @Override
    public void putEntry(QueryProcessor provider) {
        provider.directPredicatesMap.put(this.id, this);
    }

    @Override
    public final void removeEntry(QueryProcessor provider) {
        provider.directPredicatesMap.remove(this.id);
    }

    @Override
    public Object computeForEach(ReadGraphImpl graph, QueryProcessor provider, IntProcedure procedure, boolean store) {
        return DirectPredicates.computeForEach(graph, this.id, this, procedure, store);
    }

    public static Object computeForEach(ReadGraphImpl graph, int id, DirectPredicates entry, IntProcedure procedure, boolean store) {
        graph.processor.querySupport.ensureLoaded(graph, id);
        final IntArray list = new IntArray();
        graph.processor.querySupport.getPredicates(graph, id, new IntProcedure(){

            @Override
            public void execute(ReadGraphImpl graph, int i) {
                list.add(i);
            }

            @Override
            public void finished(ReadGraphImpl graph) {
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
            }
        });
        if (entry != null) {
            entry.finish(graph, graph.processor);
        }
        if (list.data == null) {
            if (list.sizeOrData != -1) {
                procedure.execute(graph, list.sizeOrData);
            }
        } else {
            int i = 0;
            while (i < list.sizeOrData) {
                procedure.execute(graph, list.data[i]);
                ++i;
            }
        }
        procedure.finished(graph);
        return list;
    }

    public String toString() {
        return "DirectPredicates[" + this.id + "]";
    }

    @Override
    public void setReady() {
        this.statusOrException = READY;
    }

    private final void finish(ReadGraphImpl graph, QueryProcessor provider) {
        this.setReady();
    }

    @Override
    public Object performFromCache(ReadGraphImpl graph, QueryProcessor provider, IntProcedure procedure) {
        assert (this.isReady());
        return this.computeForEach(graph, provider, procedure, false);
    }

    @Override
    public void recompute(ReadGraphImpl graph, QueryProcessor provider) {
        final Semaphore s = new Semaphore(0);
        this.computeForEach(graph, provider, new IntProcedureAdapter(){

            @Override
            public void finished(ReadGraphImpl graph) {
                s.release();
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                s.release();
                new Error("Error in recompute.", t).printStackTrace();
            }
        }, true);
        while (!s.tryAcquire()) {
            provider.resume(graph);
        }
    }

    @Override
    boolean isImmutable(ReadGraphImpl graph) {
        return graph.processor.isImmutable(this.id);
    }
}

