/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.util.ArrayList;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.CacheEntryBase;
import org.simantics.db.impl.query.Query;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySupport;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.request.AsyncMultiRead;

public final class AsyncMultiReadEntry<T>
extends CacheEntryBase {
    protected AsyncMultiRead<T> request;

    public AsyncMultiReadEntry(AsyncMultiRead<T> request) {
        this.request = request;
    }

    @Override
    int makeHash() {
        return this.request.hashCode();
    }

    @Override
    public Object getOriginalRequest() {
        return this.request;
    }

    @Override
    public void discard() {
        super.discard();
        this.request = null;
        this.setResult(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void finish(AsyncReadGraph graph) {
        if (!this.isPending()) {
            System.err.println("aff");
        }
        assert (this.isPending());
        AsyncMultiReadEntry asyncMultiReadEntry = this;
        synchronized (asyncMultiReadEntry) {
            this.setReady();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void except(AsyncReadGraph graph, Throwable t) {
        assert (this.isPending());
        AsyncMultiReadEntry asyncMultiReadEntry = this;
        synchronized (asyncMultiReadEntry) {
            this.except(t);
        }
    }

    public final synchronized void addOrSet(Object item) {
        assert (this.isPending());
        ArrayList value = (ArrayList)this.getResult();
        value.add(item);
    }

    @Override
    public void clearResult(QuerySupport support) {
        this.setResult(new ArrayList());
    }

    @Override
    public final Query getQuery() {
        return new Query(){

            @Override
            public void recompute(ReadGraphImpl graph, Object provider, CacheEntry entry) {
                QueryProcessor qp = (QueryProcessor)provider;
                ReadGraphImpl parentGraph = ReadGraphImpl.forRecompute(entry, qp);
                try {
                    AsyncMultiReadEntry.this.request.perform((AsyncReadGraph)parentGraph, new AsyncMultiProcedure<T>(){

                        public void execute(AsyncReadGraph graph, T result) {
                            AsyncMultiReadEntry.this.addOrSet(result);
                        }

                        public void finished(AsyncReadGraph graph) {
                            AsyncMultiReadEntry.this.finish(graph);
                        }

                        public void exception(AsyncReadGraph graph, Throwable t) {
                            AsyncMultiReadEntry.this.except(t);
                        }
                    });
                }
                catch (Throwable t) {
                    AsyncMultiReadEntry.this.except(t);
                }
            }

            @Override
            public void removeEntry(QueryProcessor processor) {
                processor.asyncMultiReadMap.remove(AsyncMultiReadEntry.this.request);
            }

            @Override
            public int type() {
                return 0;
            }

            public String toString() {
                if (AsyncMultiReadEntry.this.request == null) {
                    return "DISCARDED";
                }
                return String.valueOf(AsyncMultiReadEntry.this.request.toString()) + AsyncMultiReadEntry.this.statusOrException;
            }
        };
    }

    @Override
    public void performFromCache(ReadGraphImpl graph, Object provider, Object procedure) {
        AsyncMultiProcedure proc = (AsyncMultiProcedure)procedure;
        if (this.isExcepted()) {
            try {
                proc.exception((AsyncReadGraph)graph, (Throwable)this.getResult());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else {
            ArrayList values = (ArrayList)this.getResult();
            for (Object value : values) {
                try {
                    proc.execute((AsyncReadGraph)graph, value);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            try {
                proc.finished((AsyncReadGraph)graph);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public String toString() {
        if (this.request == null) {
            return "DISCARDED";
        }
        return String.valueOf(this.request.toString()) + this.statusOrException;
    }
}

