/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.procedure;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.MultiProcedure;

public class ResultCallWrappedQueryProcedure45<Result>
implements AsyncMultiProcedure<Result> {
    private final ArrayList<Result> result;
    private Throwable exception = null;
    private final MultiProcedure<Result> procedure;
    private final QueryProcessor.AsyncBarrier barrier;
    private final AtomicBoolean latch;

    public ResultCallWrappedQueryProcedure45(MultiProcedure<Result> procedure, QueryProcessor.AsyncBarrier barrier) {
        this.procedure = procedure;
        this.barrier = barrier;
        this.latch = new AtomicBoolean(false);
        this.result = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(AsyncReadGraph graph, Result result) {
        try {
            ArrayList<Result> arrayList = this.result;
            synchronized (arrayList) {
                this.result.add(result);
            }
            this.procedure.execute(result);
        }
        catch (Throwable t) {
            Logger.defaultLogError((String)("AsyncMultiProcedure.execute failed for " + this.procedure), (Throwable)t);
        }
    }

    public void finished(AsyncReadGraph graph) {
        if (this.latch.compareAndSet(false, true)) {
            try {
                try {
                    this.procedure.finished();
                }
                catch (Throwable t) {
                    Logger.defaultLogError((String)("AsyncMultiProcedure.exception failed for " + this.procedure), (Throwable)t);
                    this.barrier.dec();
                }
            }
            finally {
                this.barrier.dec();
            }
        } else {
            Logger.defaultLogError((String)"Finished or exception was called many times (this time is finished)");
        }
    }

    public void exception(AsyncReadGraph graph, Throwable t) {
        if (this.latch.compareAndSet(false, true)) {
            try {
                try {
                    this.exception = t;
                    this.procedure.exception(t);
                }
                catch (Throwable throwable) {
                    Logger.defaultLogError((String)("AsyncMultiProcedure.exception failed for " + this.procedure), (Throwable)throwable);
                    this.barrier.dec();
                }
            }
            finally {
                this.barrier.dec();
            }
        } else {
            Logger.defaultLogError((String)"Finished or exception was called many times (this time is exception)");
        }
    }

    public ArrayList<Result> getResult() {
        return this.result;
    }

    public Throwable getException() {
        return this.exception;
    }
}

