/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.modelImport.mdl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.simantics.sysdyn.modelImport.mdl.MdlModel;
import org.simantics.sysdyn.modelImport.mdl.SketchComment;
import org.simantics.sysdyn.modelImport.mdl.SketchConnection;
import org.simantics.sysdyn.modelImport.mdl.SketchElement;
import org.simantics.sysdyn.modelImport.mdl.SketchObject;
import org.simantics.sysdyn.modelImport.mdl.SketchValve;
import org.simantics.sysdyn.modelImport.mdl.SketchVariable;

public class Sketch {
    private MdlModel mdl;
    private String name;
    private int xOffset = 0;
    private int yOffset = 0;
    private boolean updateEdges;
    private int topEdge = 0;
    private int bottomEdge = 0;
    private int leftEdge = 0;
    private int rightEdge = 0;
    private List<SketchComment> comments;
    private List<SketchConnection> connections;
    private List<SketchValve> valves;
    private List<SketchVariable> variables;
    private HashMap<Integer, SketchObject> objects;

    public Sketch(MdlModel mdl) {
        this.mdl = mdl;
        this.updateEdges = true;
        this.comments = new ArrayList<SketchComment>();
        this.connections = new ArrayList<SketchConnection>();
        this.valves = new ArrayList<SketchValve>();
        this.variables = new ArrayList<SketchVariable>();
        this.objects = new HashMap();
    }

    public MdlModel getMdl() {
        return this.mdl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private void updateEdges() {
        if (this.updateEdges) {
            boolean first = true;
            for (SketchElement e : this.getAllElements()) {
                this.topEdge = first ? e.getTop() : Math.min(this.topEdge, e.getTop());
                this.bottomEdge = first ? e.getBottom() : Math.max(this.bottomEdge, e.getBottom());
                this.leftEdge = first ? e.getLeft() : Math.min(this.leftEdge, e.getLeft());
                this.rightEdge = first ? e.getRight() : Math.max(this.rightEdge, e.getRight());
                first = false;
            }
            this.updateEdges = false;
        }
    }

    public int getWidth() {
        this.updateEdges();
        return this.rightEdge - this.leftEdge;
    }

    public int getHeight() {
        this.updateEdges();
        return this.bottomEdge - this.topEdge;
    }

    public void setLocation(int x, int y) {
        this.xOffset = x;
        this.yOffset = y;
    }

    public int getElementXOffset() {
        this.updateEdges();
        return -this.leftEdge + this.xOffset;
    }

    public int getElementYOffset() {
        this.updateEdges();
        return -this.topEdge + this.yOffset;
    }

    public void addComment(SketchComment comment) {
        this.comments.add(comment);
        this.objects.put(comment.getId(), comment);
        this.updateEdges = true;
    }

    public List<SketchComment> getComments() {
        return this.comments;
    }

    public void addConnection(SketchConnection connection) {
        this.connections.add(connection);
        this.objects.put(connection.getId(), connection);
    }

    public List<SketchConnection> getConnections() {
        return this.connections;
    }

    public void addValve(SketchValve valve) {
        this.valves.add(valve);
        this.objects.put(valve.getId(), valve);
        this.objects.put(valve.getAttached().getId(), valve);
        this.updateEdges = true;
    }

    public List<SketchValve> getValves() {
        return this.valves;
    }

    public void addVariable(SketchVariable variable) {
        this.variables.add(variable);
        this.objects.put(variable.getId(), variable);
        this.updateEdges = true;
    }

    public List<SketchVariable> getVariables() {
        return this.variables;
    }

    public SketchObject getObject(int id) {
        return this.objects.get(id);
    }

    public List<SketchElement> getAllElements() {
        ArrayList<SketchElement> list = new ArrayList<SketchElement>();
        list.addAll(this.getComments());
        list.addAll(this.getValves());
        list.addAll(this.getVariables());
        return list;
    }

    public List<SketchVariable> getShadowVariables() {
        ArrayList<SketchVariable> variables = new ArrayList<SketchVariable>();
        for (SketchVariable var : this.getVariables()) {
            if (var.allowsIn()) continue;
            variables.add(var);
        }
        return variables;
    }

    public List<SketchVariable> getNonShadowVariables() {
        ArrayList<SketchVariable> variables = new ArrayList<SketchVariable>();
        variables.addAll(this.getVariables());
        variables.removeAll(this.getShadowVariables());
        return variables;
    }
}

