/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph;

import gnu.trove.map.hash.THashMap;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.NodeException;

public abstract class ParentNode<T extends INode>
extends Node {
    private static final long serialVersionUID = 8519410262849626534L;
    public static final String EXISTING = "#EXISTING#";
    public static final String UNLINK = "#UNLINK#";
    public static final String NULL = "#NULL#";
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Map DISPOSED_CHILDREN = Collections.emptyMap();
    protected static final ParentNode<?> DISPOSED = new ParentNode<INode>(){
        private static final long serialVersionUID = 6155494069158034123L;

        @Override
        public void asyncRemoveNode(INode node) {
            throw new Error();
        }
    };
    protected transient Map<String, T> children = this.createChildMap();
    protected volatile transient ParentNode<?> rootNodeCache;

    protected Map<String, T> createChildMap() {
        return new THashMap(1);
    }

    public final <TC> TC addNode(Class<TC> a) {
        return this.addNode(UUID.randomUUID().toString(), a);
    }

    public <TC extends INode> TC addNode(String id, TC child) {
        child.setParent(this);
        this.children.put(id, child);
        child.init();
        this.childrenChanged();
        return child;
    }

    public <TC extends INode> TC attachNode(String id, TC child) {
        child.setParent(this);
        this.children.put(id, child);
        child.attach();
        this.childrenChanged();
        return child;
    }

    public <TC extends INode> TC detachNode(String id) {
        INode child = (INode)this.children.remove(id);
        if (child == null) {
            return null;
        }
        child.setParent(null);
        this.childrenChanged();
        return (TC)child;
    }

    public <TC> TC addNode(String id, Class<TC> a) {
        if (!Node.class.isAssignableFrom(a)) {
            throw new IllegalArgumentException(a + " is not extended from org.simantics.scenegraph.Node");
        }
        Node child = null;
        try {
            child = (Node)a.newInstance();
        }
        catch (InstantiationException e) {
            throw new NodeException("Node " + Node.getSimpleClassName(a) + " instantiation failed, see exception for details.", e);
        }
        catch (IllegalAccessException e) {
            throw new NodeException("Node " + Node.getSimpleClassName(a) + " instantiation failed, see exception for details.", e);
        }
        child.setParent(this);
        this.children.put(id, child);
        child.init();
        this.childrenChanged();
        return (TC)child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <TC extends INode> TC getOrAttachNode(String id, TC a) {
        Map<String, T> map = this.children;
        synchronized (map) {
            if (this.children.containsKey(id)) {
                return (TC)((INode)this.children.get(id));
            }
        }
        return this.attachNode(id, a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <TC> TC getOrCreateNode(String id, Class<TC> a) {
        Map<String, T> map = this.children;
        synchronized (map) {
            if (this.children.containsKey(id)) {
                return (TC)this.children.get(id);
            }
        }
        return this.addNode(id, a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeNode(String id) {
        INode child = null;
        Map<String, T> map = this.children;
        synchronized (map) {
            child = (INode)this.children.remove(id);
        }
        if (child != null) {
            if (child instanceof ParentNode) {
                ((ParentNode)child).removeNodes();
            }
            child.cleanup();
            child.setParent(null);
            this.childrenChanged();
            if (this.propertyChangeListener != null) {
                this.propertyChangeListener.propertyChange(new PropertyChangeEvent(this, "children[" + child.getId() + "]", child.getClass(), NULL));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeNode(INode child) {
        Map<String, T> map = this.children;
        synchronized (map) {
            String id = null;
            for (String tmp : this.children.keySet()) {
                if (!((INode)this.children.get(tmp)).equals(child)) continue;
                id = tmp;
                break;
            }
            if (id == null) {
                return;
            }
            this.children.remove(id);
            this.childrenChanged();
        }
        if (child instanceof ParentNode) {
            ((ParentNode)child).removeNodes();
        }
        child.cleanup();
        child.setParent(null);
        if (this.propertyChangeListener != null) {
            this.propertyChangeListener.propertyChange(new PropertyChangeEvent(this, "children[" + child.getId() + "]", child.getClass(), NULL));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeNodes() {
        Map<String, T> map = this.children;
        synchronized (map) {
            String[] keys;
            boolean changed = false;
            String[] stringArray = keys = this.children.keySet().toArray(EMPTY_STRING_ARRAY);
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                INode child = (INode)this.children.remove(key);
                if (child != null) {
                    changed = true;
                    if (child instanceof ParentNode) {
                        ((ParentNode)child).removeNodes();
                    }
                    child.cleanup();
                    child.setParent(null);
                    if (this.propertyChangeListener != null) {
                        this.propertyChangeListener.propertyChange(new PropertyChangeEvent(this, "children[" + child.getId() + "]", child.getClass(), NULL));
                    }
                }
                ++n2;
            }
            if (changed) {
                this.childrenChanged();
            }
        }
    }

    protected void childrenChanged() {
    }

    public abstract void asyncRemoveNode(INode var1);

    public T getNode(String id) {
        return (T)((INode)this.children.get(id));
    }

    public Collection<String> getNodeIds() {
        return this.children.keySet();
    }

    public Collection<T> getNodes() {
        return this.children.values();
    }

    public int getNodeCount() {
        return this.children.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeListener = propertyChangeListener;
        Map<String, T> map = this.children;
        synchronized (map) {
            for (INode t : this.children.values()) {
                INode child = t;
                if (child instanceof ParentNode) {
                    ((ParentNode)child).setPropertyChangeListener(propertyChangeListener);
                    continue;
                }
                ((Node)child).propertyChangeListener = propertyChangeListener;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        this.retractMapping();
        if (this.children != DISPOSED_CHILDREN) {
            Map<String, T> map = this.children;
            synchronized (map) {
                for (INode child : this.children.values()) {
                    child.cleanup();
                    child.setParent(null);
                }
                this.children.clear();
                this.children = DISPOSED_CHILDREN;
                this.childrenChanged();
            }
            this.rootNodeCache = DISPOSED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() {
        if (this.parent == null) {
            return;
        }
        Map<String, T> map = this.children;
        synchronized (map) {
            this.parent.appendChildren(this.children);
            this.children.clear();
        }
        this.parent.unlinkChild(this);
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void appendChildren(Map<String, ?> children) {
        Map<String, T> map = this.children;
        synchronized (map) {
            for (String id : children.keySet()) {
                INode child = (INode)children.get(id);
                this.children.put(id, child);
                child.setParent(this);
                if (this.propertyChangeListener == null || !this.location.equals((Object)INode.Location.LOCAL)) continue;
                this.propertyChangeListener.propertyChange(new PropertyChangeEvent(this, "children[" + child.getId() + "]", null, EXISTING));
            }
        }
    }

    protected void appendChild(String id, INode child) {
        this.children.put(id, child);
        child.setParent(this);
        if (this.propertyChangeListener != null && this.location.equals((Object)INode.Location.LOCAL)) {
            this.propertyChangeListener.propertyChange(new PropertyChangeEvent(this, "children[" + child.getId() + "]", null, EXISTING));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlinkChild(INode child) {
        Map<String, T> map = this.children;
        synchronized (map) {
            String id = null;
            for (String tmp : this.children.keySet()) {
                if (!((INode)this.children.get(tmp)).equals(child)) continue;
                id = tmp;
                break;
            }
            if (id == null) {
                return;
            }
            this.children.remove(id);
            this.childrenChanged();
        }
        if (this.propertyChangeListener != null && this.location.equals((Object)INode.Location.LOCAL)) {
            this.propertyChangeListener.propertyChange(new PropertyChangeEvent(this, "children[" + child.getId() + "]", child.getClass(), UNLINK));
        }
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " [#child=" + this.children.size() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParentNode<?> getRootNode() {
        ParentNode<?> result = this.rootNodeCache;
        if (result == DISPOSED) {
            return null;
        }
        if (result == null) {
            ParentNode parentNode = this;
            synchronized (parentNode) {
                result = this.rootNodeCache;
                if (result == null && this.parent != null) {
                    this.rootNodeCache = result = this.parent.getRootNode();
                }
            }
        }
        return result;
    }
}

