/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import gnu.trove.procedure.TIntProcedure;
import gnu.trove.set.hash.TIntHashSet;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.IntSet;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.UnaryQuery;
import org.simantics.db.procedure.ListenerBase;

public final class SuperRelations
extends UnaryQuery<InternalProcedure<IntSet>> {
    static int histoCounter = 0;
    static IntSet EMPTY_SET = new IntSet();
    static int counter = 0;

    private SuperRelations(int resource) {
        super(resource);
    }

    static final SuperRelations entry(QueryProcessor provider, int r) {
        return (SuperRelations)provider.superRelationsMap.get(r);
    }

    static final IntSet runner(ReadGraphImpl graph, int r, QueryProcessor provider, CacheEntry parent, ListenerBase listener, InternalProcedure<IntSet> procedure) {
        SuperRelations entry = (SuperRelations)provider.superRelationsMap.get(r);
        if (entry == null) {
            entry = new SuperRelations(r);
            entry.setPending();
            entry.clearResult(provider.querySupport);
            entry.putEntry(provider);
            return (IntSet)provider.performForEach(graph, entry, parent, listener, procedure);
        }
        if (!entry.isReady()) {
            throw new IllegalStateException();
        }
        return (IntSet)provider.performForEach(graph, entry, parent, listener, procedure);
    }

    static final IntSet runner2(ReadGraphImpl graph, int r, QueryProcessor provider, CacheEntry parent, ListenerBase listener, InternalProcedure<IntSet> procedure) throws Throwable {
        SuperRelations entry = (SuperRelations)provider.superRelationsMap.get(r);
        if (entry == null) {
            entry = new SuperRelations(r);
            entry.setPending();
            entry.clearResult(provider.querySupport);
            entry.putEntry(provider);
            return (IntSet)provider.performForEach2(graph, entry, parent, listener, procedure);
        }
        if (!entry.isReady()) {
            throw new IllegalStateException();
        }
        return (IntSet)provider.performForEach2(graph, entry, parent, listener, procedure);
    }

    public static final void queryEach(ReadGraphImpl graph, int r, QueryProcessor provider, CacheEntry parent, ListenerBase listener, InternalProcedure<IntSet> procedure) {
        SuperRelations entry;
        if (parent == null && listener == null && (entry = (SuperRelations)provider.superRelationsMap.get(r)) != null && entry.isReady()) {
            entry.performFromCache(graph, provider, procedure);
            return;
        }
        SuperRelations.runner(graph, r, provider, parent, listener, procedure);
    }

    public static final IntSet queryEach2(ReadGraphImpl graph, int r, QueryProcessor provider, CacheEntry parent, ListenerBase listener, InternalProcedure<IntSet> procedure) throws Throwable {
        SuperRelations entry;
        if (parent == null && listener == null && (entry = (SuperRelations)provider.superRelationsMap.get(r)) != null && entry.isReady()) {
            return (IntSet)entry.get(graph, provider, procedure);
        }
        return SuperRelations.runner2(graph, r, provider, parent, listener, procedure);
    }

    @Override
    public UnaryQuery<InternalProcedure<IntSet>> getEntry(QueryProcessor provider) {
        return provider.superRelationsMap.get(this.id);
    }

    @Override
    public void putEntry(QueryProcessor provider) {
        provider.superRelationsMap.put(this.id, this);
    }

    @Override
    public final void removeEntry(QueryProcessor provider) {
        provider.superRelationsMap.remove(this.id);
    }

    @Override
    public Object computeForEach(final ReadGraphImpl graph, final QueryProcessor provider, InternalProcedure<IntSet> procedure, boolean store) {
        provider.querySupport.ensureLoaded(graph, this.id);
        final InternalProcedure<IntSet> proc = procedure;
        int subrelationOf = provider.getSubrelationOf();
        final IntSet result = new IntSet(provider.querySupport);
        final class DirectProcedure
        extends Koss
        implements IntProcedure,
        TIntProcedure,
        InternalProcedure<IntSet> {
            private final /* synthetic */ IntSet val$result;
            private final /* synthetic */ QueryProcessor val$provider;
            private final /* synthetic */ InternalProcedure val$proc;

            DirectProcedure(IntSet intSet, QueryProcessor queryProcessor, InternalProcedure internalProcedure) {
                this.val$result = intSet;
                this.val$provider = queryProcessor;
                this.val$proc = internalProcedure;
            }

            public final boolean execute(int r) {
                this.val$result.add(r);
                return true;
            }

            @Override
            public final void execute(ReadGraphImpl graph, int r) {
                if (this.single == 0) {
                    this.single = r;
                    return;
                }
                this.add(r);
            }

            @Override
            public final void execute(ReadGraphImpl graph, IntSet set) {
                set.forEach(this);
                SuperRelations.this.addOrSet(graph, this.val$result, this.val$provider);
                this.val$proc.execute(graph, this.val$result);
            }

            @Override
            public void finished(ReadGraphImpl graph) {
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                throw new Error("Errors are not supported.", t);
            }
        }
        final DirectProcedure directProc = new DirectProcedure(result, provider, proc);
        provider.querySupport.getObjects(graph, this.id, subrelationOf, directProc);
        int size = directProc.size();
        if (size == 0) {
            this.addOrSet(graph, EMPTY_SET, provider);
            proc.execute(graph, EMPTY_SET);
        } else if (size == 1) {
            result.add(directProc.single);
            SuperRelations.queryEach(graph, directProc.single, provider, this, null, directProc);
        } else {
            final TIntProcedure addToResult = new TIntProcedure(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean execute(int r) {
                    IntSet intSet = result;
                    synchronized (intSet) {
                        result.add(r);
                    }
                    return true;
                }
            };
            final AtomicInteger finishes = new AtomicInteger(0);
            directProc.forEach(new TIntProcedure(){
                {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean execute(int arg0) {
                    IntSet intSet = result;
                    synchronized (intSet) {
                        result.add(arg0);
                    }
                    SuperRelations.queryEach(graph, arg0, provider, SuperRelations.this, null, new InternalProcedure<IntSet>(){
                        {
                        }

                        @Override
                        public void execute(ReadGraphImpl graph, IntSet set) {
                            set.forEach(addToResult);
                            int current = finishes.addAndGet(1);
                            if (current == directProc.size()) {
                                SuperRelations.this.addOrSet(graph, result, provider);
                                proc.execute(graph, result);
                                return;
                            }
                        }

                        @Override
                        public void exception(ReadGraphImpl graph, Throwable t) {
                            proc.exception(graph, t);
                        }
                    });
                    return true;
                }
            });
        }
        return result;
    }

    public String toString() {
        return "SuperRelations[" + this.id + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOrSet(ReadGraphImpl graph, IntSet value, QueryProcessor provider) {
        assert (!this.isReady());
        SuperRelations superRelations = this;
        synchronized (superRelations) {
            value.trim();
            this.setResult(value);
            this.setReady();
        }
    }

    @Override
    public Object performFromCache(ReadGraphImpl graph, QueryProcessor provider, InternalProcedure<IntSet> procedure) {
        assert (this.isReady());
        if (this.handleException(graph, procedure)) {
            return null;
        }
        IntSet result = (IntSet)this.getResult();
        procedure.execute(graph, result);
        return result;
    }

    @Override
    public void recompute(ReadGraphImpl graph, QueryProcessor provider) {
        final Semaphore s = new Semaphore(0);
        this.computeForEach(graph, provider, new InternalProcedure<IntSet>(){

            @Override
            public void execute(ReadGraphImpl graph, IntSet result) {
                s.release();
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                s.release();
                new Error("Error in recompute.", t).printStackTrace();
            }
        }, true);
        while (!s.tryAcquire()) {
            provider.resume(graph);
        }
    }

    @Override
    boolean isImmutable(ReadGraphImpl graph) {
        return graph.processor.isImmutable(this.id);
    }

    class Koss {
        private TIntHashSet set = null;
        public int single = 0;

        Koss() {
        }

        public boolean add(int val) {
            if (this.single == val) {
                return false;
            }
            if (this.single == 0) {
                this.single = val;
                return true;
            }
            if (this.set == null) {
                this.set = new TIntHashSet(4);
            }
            return this.set.add(val);
        }

        public int size() {
            if (this.single == 0) {
                return 0;
            }
            if (this.set == null) {
                return 1;
            }
            return this.set.size() + 1;
        }

        public void forEach(TIntProcedure proc) {
            if (this.single > 0) {
                proc.execute(this.single);
            }
            if (this.set != null) {
                this.set.forEach(proc);
            }
        }
    }
}

