/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl;

import java.io.InputStream;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.ForEachObjectContextProcedure;
import org.simantics.db.impl.ForEachObjectProcedure;
import org.simantics.db.impl.ForPossibleRelatedValueContextProcedure;
import org.simantics.db.impl.ForPossibleRelatedValueProcedure;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.service.ClusterUID;
import org.simantics.utils.datastructures.Callback;

public interface ClusterI {
    public CompleteTypeEnum getCompleteType(int var1, ClusterSupport var2) throws DatabaseException;

    public int getCompleteObjectKey(int var1, ClusterSupport var2) throws DatabaseException;

    public boolean isComplete(int var1, ClusterSupport var2) throws DatabaseException;

    public <Context> boolean forPredicates(int var1, PredicateProcedure<Context> var2, Context var3, ClusterSupport var4) throws DatabaseException;

    public <Context> boolean forObjects(int var1, int var2, int var3, ObjectProcedure<Context> var4, Context var5, ClusterSupport var6) throws DatabaseException;

    public <Context> boolean forObjects(int var1, int var2, ObjectProcedure<Context> var3, Context var4, ClusterSupport var5) throws DatabaseException;

    public int getSingleObject(int var1, int var2, ClusterSupport var3) throws DatabaseException;

    public <T> int getSingleObject(int var1, ForPossibleRelatedValueProcedure<T> var2, ClusterSupport var3) throws DatabaseException;

    public <C, T> int getSingleObject(int var1, ForPossibleRelatedValueContextProcedure<C, T> var2, ClusterSupport var3) throws DatabaseException;

    public void forObjects(ReadGraphImpl var1, int var2, int var3, AsyncMultiProcedure<Resource> var4) throws DatabaseException;

    public void forObjects(ReadGraphImpl var1, int var2, ForEachObjectProcedure var3) throws DatabaseException;

    public <C> void forObjects(ReadGraphImpl var1, int var2, C var3, ForEachObjectContextProcedure<C> var4) throws DatabaseException;

    public ClusterI addRelation(int var1, int var2, int var3, ClusterSupport var4) throws DatabaseException;

    public boolean removeRelation(int var1, int var2, int var3, ClusterSupport var4) throws DatabaseException;

    public void denyRelation(int var1, int var2, int var3, ClusterSupport var4) throws DatabaseException;

    public byte[] getValue(int var1, ClusterSupport var2) throws DatabaseException;

    public InputStream getValueStream(int var1, ClusterSupport var2) throws DatabaseException;

    public boolean hasValue(int var1, ClusterSupport var2) throws DatabaseException;

    public boolean removeValue(int var1, ClusterSupport var2) throws DatabaseException;

    public ClusterI setValue(int var1, byte[] var2, int var3, ClusterSupport var4) throws DatabaseException;

    public ClusterI modiValueEx(int var1, long var2, int var4, byte[] var5, int var6, ClusterSupport var7) throws DatabaseException;

    public byte[] readValueEx(int var1, long var2, int var4, ClusterSupport var5) throws DatabaseException;

    public long getValueSizeEx(int var1, ClusterSupport var2) throws DatabaseException;

    public void setValueEx(int var1) throws DatabaseException;

    public int createResource(ClusterSupport var1) throws DatabaseException;

    public boolean hasResource(int var1, ClusterSupport var2) throws DatabaseException;

    public int getNumberOfResources(ClusterSupport var1) throws DatabaseException;

    public long getCachedSize();

    public long getUsedSpace() throws DatabaseException;

    public boolean isEmpty();

    public void printDebugInfo(String var1, ClusterSupport var2) throws DatabaseException;

    public long getClusterId();

    public int getClusterKey();

    public boolean isWriteOnly();

    public void load() throws DatabaseException;

    public void load(Callback<DatabaseException> var1);

    public void load(ClusterSupport var1, Runnable var2);

    public boolean hasVirtual();

    public void markVirtual();

    public ClusterI getClusterByResourceKey(int var1, ClusterSupport var2);

    public boolean isLoaded();

    public void increaseReferenceCount(int var1);

    public void decreaseReferenceCount(int var1);

    public int getReferenceCount();

    public long getImportance();

    public void setImportance(long var1);

    public void releaseMemory();

    public void compact();

    public boolean contains(int var1);

    public ClusterTypeEnum getType();

    public boolean getImmutable();

    public void setImmutable(boolean var1, ClusterSupport var2);

    public boolean getDeleted();

    public void setDeleted(boolean var1, ClusterSupport var2);

    public ClusterUID getClusterUID();

    public static enum ClusterTypeEnum {
        SMALL,
        BIG,
        WRITEONLY;

    }

    public static final class CompleteTypeEnum
    extends Enum<CompleteTypeEnum> {
        public static final /* enum */ CompleteTypeEnum NotComplete = new CompleteTypeEnum(0);
        public static final /* enum */ CompleteTypeEnum InstanceOf = new CompleteTypeEnum(1);
        public static final /* enum */ CompleteTypeEnum Inherits = new CompleteTypeEnum(2);
        public static final /* enum */ CompleteTypeEnum SubrelationOf = new CompleteTypeEnum(3);
        private byte value;
        private static final /* synthetic */ CompleteTypeEnum[] ENUM$VALUES;

        static {
            ENUM$VALUES = new CompleteTypeEnum[]{NotComplete, InstanceOf, Inherits, SubrelationOf};
        }

        public static final CompleteTypeEnum make(int value) {
            switch (value) {
                default: {
                    throw new Error("Internal error. Illegal complete type=" + value + ".");
                }
                case 0: {
                    assert (NotComplete.getValue() == 0);
                    return NotComplete;
                }
                case 1: {
                    assert (1 == InstanceOf.getValue());
                    return InstanceOf;
                }
                case 2: {
                    assert (2 == Inherits.getValue());
                    return Inherits;
                }
                case 3: 
            }
            assert (3 == SubrelationOf.getValue());
            return SubrelationOf;
        }

        public final byte getValue() {
            return this.value;
        }

        private CompleteTypeEnum(int value) {
            this.value = (byte)value;
        }

        public static CompleteTypeEnum[] values() {
            CompleteTypeEnum[] completeTypeEnumArray = ENUM$VALUES;
            int n = completeTypeEnumArray.length;
            CompleteTypeEnum[] completeTypeEnumArray2 = new CompleteTypeEnum[n];
            System.arraycopy(ENUM$VALUES, 0, completeTypeEnumArray2, 0, n);
            return completeTypeEnumArray2;
        }

        public static CompleteTypeEnum valueOf(String string) {
            return Enum.valueOf(CompleteTypeEnum.class, string);
        }
    }

    public static interface ObjectProcedure<Context>
    extends Procedure {
        public boolean execute(Context var1, int var2) throws DatabaseException;
    }

    public static interface PredicateProcedure<Context>
    extends Procedure {
        public boolean execute(Context var1, int var2, int var3);
    }

    public static interface Procedure {
    }

    public static enum TypeEnum {
        Small,
        Big;

    }
}

