/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart.properties;

import java.util.Collection;
import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListenerImpl;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;

public class DoublePropertyModifier2
extends TextModifyListenerImpl<Resource> {
    private final String typeUri;
    private final String propertyURI;

    public DoublePropertyModifier2(ISessionContext context, String propertyURI) {
        this.propertyURI = propertyURI;
        this.typeUri = null;
    }

    public DoublePropertyModifier2(ISessionContext context, String typeURI, String propertyURI) {
        this.propertyURI = propertyURI;
        this.typeUri = typeURI;
    }

    public void applyText(WriteGraph graph, Resource input, String text) throws DatabaseException {
        if (this.typeUri == null) {
            this.applyValue(graph, input, text);
        } else {
            Resource type = graph.getResource(this.typeUri);
            for (Resource object : (Collection)graph.syncRequest((Read)new ObjectsWithType(input, Layer0.getInstance((ReadGraph)graph).ConsistsOf, type))) {
                this.applyValue(graph, object, text);
            }
        }
    }

    private void applyValue(WriteGraph graph, Resource input, String text) throws DatabaseException {
        if (text == null || text.trim().isEmpty()) {
            if (graph.hasStatement(input, graph.getResource(this.propertyURI))) {
                graph.denyValue(input, graph.getResource(this.propertyURI));
            }
        } else {
            graph.claimLiteral(input, graph.getResource(this.propertyURI), (Object)Double.parseDouble(text), (Binding)Bindings.DOUBLE);
        }
    }
}

