/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart;

import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.jfreechart.chart.AbstractPlot;
import org.simantics.jfreechart.chart.IAxis;
import org.simantics.jfreechart.chart.IDataset;
import org.simantics.jfreechart.chart.IRenderer;
import org.simantics.jfreechart.chart.PlotProperties;
import org.simantics.sysdyn.JFreeChartResource;

public class XYPlot
extends AbstractPlot {
    public XYPlot(ReadGraph graph, Resource plotResource) {
        super(graph, plotResource);
    }

    @Override
    protected Plot newPlot() {
        return new org.jfree.chart.plot.XYPlot(null, null, null, null);
    }

    @Override
    protected void getOtherProperties(ReadGraph graph, PlotProperties properties) throws DatabaseException {
        IDataset idataset;
        Resource renderer;
        JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
        Boolean visibleGrid = (Boolean)graph.getPossibleRelatedValue(this.resource, jfree.Plot_visibleGrid);
        properties.otherProperties.put("visibleGrid", visibleGrid);
        if (!properties.datasets.isEmpty() && (renderer = graph.getPossibleObject((idataset = properties.datasets.get(0)).getResource(), jfree.Dataset_renderer)) != null) {
            properties.otherProperties.put("renderer", graph.adapt(renderer, IRenderer.class));
        }
    }

    @Override
    protected void setPlotProperties(PlotProperties properties) {
        Boolean orientation;
        if (!(this.plot instanceof org.jfree.chart.plot.XYPlot)) {
            return;
        }
        org.jfree.chart.plot.XYPlot xyplot = (org.jfree.chart.plot.XYPlot)this.plot;
        xyplot.clearDomainAxes();
        xyplot.clearRangeAxes();
        int i = 0;
        while (i < properties.ranges.size()) {
            xyplot.setRangeAxis(i, (ValueAxis)properties.ranges.get(i).getAxis());
            ++i;
        }
        i = 0;
        while (i < properties.domains.size()) {
            xyplot.setDomainAxis(i, (ValueAxis)properties.domains.get(i).getAxis());
            ++i;
        }
        int i2 = 0;
        while (i2 < properties.datasets.size()) {
            IDataset dataset = properties.datasets.get(i2);
            xyplot.setDataset(i2, (XYDataset)dataset.getDataset());
            xyplot.setRenderer(i2, (XYItemRenderer)dataset.getRenderer());
            IAxis axis = properties.rangeMappings.get(dataset);
            if (axis != null && properties.ranges.contains(axis)) {
                xyplot.mapDatasetToRangeAxis(i2, properties.ranges.indexOf(axis));
            }
            if ((axis = properties.domainMappings.get(dataset)) != null && properties.ranges.contains(axis)) {
                xyplot.mapDatasetToDomainAxis(i2, properties.domains.indexOf(axis));
            }
            ++i2;
        }
        Boolean visibleGrid = (Boolean)properties.otherProperties.get("visibleGrid");
        if (visibleGrid == null) {
            visibleGrid = true;
        }
        if ((orientation = (Boolean)properties.otherProperties.get("orientation")) != null) {
            if (orientation.booleanValue()) {
                xyplot.setOrientation(PlotOrientation.HORIZONTAL);
            } else {
                xyplot.setOrientation(PlotOrientation.VERTICAL);
            }
        }
        xyplot.setRangeGridlinesVisible(visibleGrid.booleanValue());
        xyplot.setDomainGridlinesVisible(visibleGrid.booleanValue());
        xyplot.setInsets(new RectangleInsets(2.0, 5.0, 2.0, 10.0), false);
        xyplot.setOutlineVisible(false);
    }
}

