/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.dnd.ResourceTransferData;
import org.simantics.ui.dnd.ResourceTransferUtils;

public class ResourceReferenceTransfer
extends ByteArrayTransfer {
    private static final String TYPENAME = "ResourceReferenceTransfer";
    private static final int TYPEID = ResourceReferenceTransfer.registerType((String)"ResourceReferenceTransfer");
    private static final ResourceReferenceTransfer INSTANCE = ResourceReferenceTransfer.createInstance(null);
    private String purpose;
    private Session session;

    public static ResourceReferenceTransfer getInstance() {
        return INSTANCE;
    }

    public static ResourceReferenceTransfer createInstance(Session session) {
        ResourceReferenceTransfer result = new ResourceReferenceTransfer(null);
        result.session = session;
        return result;
    }

    public static ResourceReferenceTransfer createInstance(String purpose) {
        ResourceReferenceTransfer result = new ResourceReferenceTransfer(purpose);
        return result;
    }

    ResourceReferenceTransfer(String purpose) {
        this.purpose = purpose;
    }

    private Session getSession() {
        return this.session == null ? SimanticsUI.getSession() : this.session;
    }

    public void javaToNative(Object object, TransferData transferData) {
        String buffer;
        if (!this.checkResourceReference(object) || !this.isSupportedType(transferData)) {
            DND.error((int)2003);
        }
        ResourceArray[] resources = null;
        if (object instanceof Resource) {
            resources = new ResourceArray[]{new ResourceArray(new Resource[]{(Resource)object})};
        }
        if (object instanceof Resource[]) {
            resources = new ResourceArray[]{new ResourceArray((Resource[])object)};
        }
        if (object instanceof ResourceArray) {
            resources = new ResourceArray[]{(ResourceArray)object};
        }
        if (object instanceof ResourceArray[]) {
            resources = (ResourceArray[])object;
        }
        if (resources == null) {
            DND.error((int)2003);
        }
        Session s = this.getSession();
        SerialisationSupport support = (SerialisationSupport)s.getService(SerialisationSupport.class);
        ResourceTransferData rtd = new ResourceTransferData(s, resources);
        rtd.setPurpose(this.purpose);
        try {
            buffer = ResourceTransferUtils.createStringTransferable(support, rtd);
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
        TextTransfer.getInstance().javaToNative((Object)buffer, transferData);
    }

    public Object nativeToJava(TransferData transferData) {
        if (this.isSupportedType(transferData)) {
            ResourceTransferData rtd;
            String buffer = (String)TextTransfer.getInstance().nativeToJava(transferData);
            if (buffer == null) {
                return null;
            }
            Session s = this.getSession();
            SerialisationSupport support = (SerialisationSupport)s.getService(SerialisationSupport.class);
            try {
                rtd = ResourceTransferUtils.readStringTransferable(support, buffer);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (DatabaseException e) {
                throw new RuntimeException(e);
            }
            return rtd.toResourceArrayArray();
        }
        return null;
    }

    protected String[] getTypeNames() {
        return new String[]{TYPENAME};
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    boolean checkResourceReference(Object object) {
        System.out.println("o = " + object);
        if (object == null) {
            return false;
        }
        return object instanceof ResourceArray[] && ((ResourceArray[])object).length != 0;
    }

    protected boolean validate(Object object) {
        return this.checkResourceReference(object);
    }
}

