/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulation.ui.handlers.e4;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.project.IProject;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.simulation.experiment.IDynamicExperiment;
import org.simantics.simulation.experiment.IDynamicExperimentListener;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.experiment.IExperimentListener;
import org.simantics.simulation.experiment.SimulationTimeUtil;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.simulation.project.IExperimentManagerListener;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.threads.ThreadUtils;

public class TimerContribution {
    private static final String PREF_CHART_BUNDLE_ID = "org.simantics.charts";
    private static final String PREF_CHART_TIMEFORMAT = "chart.timeformat";
    private static final long LABEL_UPDATE_MIN_PERIOD_MS = 100L;
    boolean disposed = false;
    Text label;
    Point size;
    double time = 0.0;
    private Mode mode = Mode.HMS;
    private IExperimentManager experimentManager;
    private IExperimentManagerListener experimentManagerListener;
    private ExperimentState currentState;
    private ResourceManager resourceManager;
    @Inject
    private UISynchronize uisync;
    @Inject
    @Optional
    @Preference(nodePath="org.simantics.charts")
    private IEclipsePreferences chartPreferences;
    private IEclipsePreferences.IPreferenceChangeListener chartTimeFormatListener = event -> {
        Mode newMode;
        if (PREF_CHART_TIMEFORMAT.equals(event.getKey()) && (newMode = TimerContribution.toMode((String)event.getNewValue())) != this.mode) {
            this.mode = newMode;
            this.uisync.asyncExec(() -> {
                if (!this.label.isDisposed()) {
                    this.updateLabel();
                    this.updateTooltip();
                }
            });
        }
    };
    private static ColorDescriptor RUNNING_BG = ColorDescriptor.createFrom((RGB)new RGB(0, 128, 0));
    private static ColorDescriptor RUNNING_FG = ColorDescriptor.createFrom((RGB)new RGB(255, 255, 255));

    private static String toTimeFormatPreference(Mode mode) {
        switch (mode) {
            case SECONDS: {
                return "Decimal";
            }
        }
        return "Time";
    }

    /*
     * Exception decompiling
     */
    private static Mode toMode(String timeFormat) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[4] lbl22 : CaseStatement: default:\u000a, @NONE, blocks:[4] lbl22 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @PostConstruct
    public void createControls(Composite parent, MToolControl toolControl) {
        IProject project = SimanticsUI.peekProject();
        if (project == null) {
            return;
        }
        IExperimentManager manager = (IExperimentManager)project.getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        if (manager == null) {
            return;
        }
        this.label = new Text(parent, 0x1000808);
        this.label.setEnabled(false);
        this.label.setText(this.getTime());
        this.label.setToolTipText("Simulation Timer");
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.label);
        this.updateTooltip();
        Listener labelListener = new Listener(){
            boolean pressed = false;
            boolean inside = false;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 3: {
                        if (!this.inside || event.button != 1 && event.button != 2) break;
                        this.pressed = true;
                        break;
                    }
                    case 4: {
                        if (!this.pressed || !this.inside) break;
                        this.pressed = false;
                        TimerContribution.this.toggleMode();
                        break;
                    }
                    case 6: {
                        this.inside = true;
                        break;
                    }
                    case 7: {
                        this.inside = false;
                    }
                }
            }
        };
        this.label.addListener(3, labelListener);
        this.label.addListener(6, labelListener);
        this.label.addListener(7, labelListener);
        this.label.addListener(4, labelListener);
        this.size = this.label.computeSize(-1, -1, true);
        if (this.currentState != null) {
            this.setLabelVisualsByState(this.currentState);
        }
        this.attachToExperimentManager(manager);
        if (this.chartPreferences != null) {
            this.chartPreferences.addPreferenceChangeListener(this.chartTimeFormatListener);
            this.mode = TimerContribution.toMode(this.chartPreferences.get(PREF_CHART_TIMEFORMAT, null));
        }
    }

    @PreDestroy
    public void destroy() {
        if (this.chartPreferences != null) {
            this.chartPreferences.removePreferenceChangeListener(this.chartTimeFormatListener);
        }
    }

    private void attachToExperimentManager(final IExperimentManager manager) {
        if (this.experimentManager != null) {
            if (this.experimentManager.equals(manager)) {
                return;
            }
            this.experimentManager.removeListener(this.experimentManagerListener);
        }
        if (manager == null) {
            return;
        }
        this.experimentManagerListener = new IExperimentManagerListener(){
            IDynamicExperiment currentExperiment;
            IExperimentListener currentListener;

            public void managerDisposed() {
                manager.removeListener((IExperimentManagerListener)this);
            }

            public void activeExperimentUnloaded() {
                this.attachToExperiment(null);
            }

            public void activeExperimentLoaded(IExperiment experiment) {
                this.attachToExperiment(experiment);
            }

            synchronized void attachToExperiment(final IExperiment experiment) {
                if (this.currentExperiment != null) {
                    this.currentExperiment.removeListener(this.currentListener);
                    this.currentExperiment = null;
                    this.currentListener = null;
                }
                if (!(experiment instanceof IDynamicExperiment)) {
                    TimerContribution.this.time = 0.0;
                    TimerContribution.this.uisync.asyncExec(() -> {
                        if (!TimerContribution.this.label.isDisposed()) {
                            TimerContribution.this.updateLabel();
                            TimerContribution.this.setLabelVisualsByState(ExperimentState.DISPOSED);
                        }
                    });
                    return;
                }
                IDynamicExperiment dynExp = (IDynamicExperiment)experiment;
                IDynamicExperimentListener listener = new IDynamicExperimentListener(){
                    final IExperimentListener _this = this;
                    long lastUpdateTime = 0L;
                    ScheduledFuture<?> timedUpdate = null;
                    ExperimentState lastState = null;

                    public void timeChanged(double newTime) {
                        (this).TimerContribution.this.time = newTime;
                        ScheduledFuture<?> f = this.timedUpdate;
                        if (f != null && !f.isDone()) {
                            return;
                        }
                        long timeSinceLastUpdate = System.currentTimeMillis() - this.lastUpdateTime;
                        if (timeSinceLastUpdate > 100L) {
                            this.scheduleLabelUpdate();
                        } else {
                            this.timedUpdate = ThreadUtils.getNonBlockingWorkExecutor().schedule(() -> this.scheduleLabelUpdate(), 100L - timeSinceLastUpdate, TimeUnit.MILLISECONDS);
                        }
                    }

                    private void scheduleLabelUpdate() {
                        this.lastUpdateTime = System.currentTimeMillis();
                        this.timedUpdate = null;
                        TimerContribution.this.uisync.asyncExec(() -> {
                            if (!(this).TimerContribution.this.label.isDisposed()) {
                                TimerContribution.this.updateLabel();
                                if (this.lastState != TimerContribution.this.currentState) {
                                    TimerContribution.this.setLabelVisualsByState(TimerContribution.this.currentState);
                                    this.lastState = TimerContribution.this.currentState;
                                }
                            }
                        });
                    }

                    public void stateChanged(ExperimentState state) {
                        TimerContribution.this.currentState = state;
                        if (state == ExperimentState.DISPOSED) {
                            experiment.removeListener(this._this);
                        } else {
                            this.scheduleLabelUpdate();
                        }
                    }
                };
                experiment.addListener((IExperimentListener)listener);
                this.currentExperiment = dynExp;
                this.currentListener = listener;
            }
        };
        this.experimentManager = manager;
        manager.addListener(this.experimentManagerListener);
    }

    private void toggleMode() {
        this.mode = this.mode.next();
        if (!this.label.isDisposed()) {
            this.updateLabel();
            this.updateTooltip();
            this.setTimeFormatPreference(this.mode);
        }
    }

    private void setTimeFormatPreference(Mode mode) {
        if (this.chartPreferences != null) {
            this.chartPreferences.put(PREF_CHART_TIMEFORMAT, TimerContribution.toTimeFormatPreference(mode));
        }
    }

    private void updateTooltip() {
        if (this.label.isDisposed()) {
            return;
        }
        switch (this.mode) {
            case HMS: {
                this.label.setToolTipText("Shows simulation time in HMS");
                break;
            }
            case SECONDS: {
                this.label.setToolTipText("Shows simulation time in seconds");
            }
        }
    }

    private void updateLabel() {
        Point selection = this.label.getSelection();
        String oldText = this.label.getText();
        String newText = this.getTime();
        selection.y = selection.y == oldText.length() ? newText.length() : Math.min(selection.y, newText.length());
        this.label.setText(newText);
        this.label.setSelection(selection);
        Point newSize = this.label.computeSize(-1, -1, true);
        if (!ObjectUtils.objectEquals((Object)newSize, (Object)this.size)) {
            this.label.setSize(newSize);
            this.size = newSize;
            Composite parent = this.label.getParent();
            if (parent != null) {
                parent.layout();
            }
        }
    }

    private void setLabelVisualsByState(ExperimentState currentState) {
        if (this.label.isDisposed()) {
            return;
        }
        switch (currentState) {
            case RUNNING: {
                this.label.setBackground((Color)this.resourceManager.get((DeviceResourceDescriptor)RUNNING_BG));
                this.label.setForeground((Color)this.resourceManager.get((DeviceResourceDescriptor)RUNNING_FG));
                this.label.setEnabled(true);
                break;
            }
            case STOPPED: {
                this.label.setBackground(null);
                this.label.setForeground(null);
                this.label.setFont(null);
                this.label.setEnabled(true);
                break;
            }
            case INITIALIZING: 
            case DISPOSED: {
                this.label.setBackground(null);
                this.label.setForeground(null);
                this.label.setFont(null);
                this.label.setEnabled(false);
            }
        }
    }

    private String getTime() {
        if (this.mode == Mode.SECONDS) {
            return SimulationTimeUtil.formatSeconds((double)this.time);
        }
        return SimulationTimeUtil.formatHMSS((double)this.time);
    }

    static enum Mode {
        HMS,
        SECONDS;


        Mode next() {
            switch (this) {
                case HMS: {
                    return SECONDS;
                }
                case SECONDS: {
                    return HMS;
                }
            }
            return HMS;
        }
    }
}

