/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.image.ui;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.image.ui.CreateImage;
import org.simantics.image.ui.ImageSource;
import org.simantics.image.ui.ImportImagesActionFactory;
import org.simantics.utils.ui.ErrorLogger;

public class CreateImages
extends WriteRequest {
    private Resource container;
    private Collection<File> files;

    public CreateImages(Resource container, Collection<File> files) {
        this.container = container;
        this.files = files;
    }

    public void perform(WriteGraph graph) throws DatabaseException {
        for (File file : this.files) {
            try {
                ImageSource src = ImportImagesActionFactory.toImageSource(file);
                new CreateImage(this.container, src).perform(graph);
            }
            catch (IOException e) {
                ErrorLogger.defaultLogError((String)("Failed to import image " + file.getName() + ", see exception for details."), (Throwable)e);
            }
        }
    }
}

