/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.labeldecorators;

import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.simantics.browsing.ui.content.LabelDecorator;
import org.simantics.browsing.ui.model.labeldecorators.AbstractLabelDecorator;
import org.simantics.browsing.ui.model.labeldecorators.LabelDecorationRule;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.viewpoint.ontology.ViewpointResource;

public class ConstantLabelDecorationRule
extends AbstractLabelDecorator
implements LabelDecorationRule {
    String prefix;
    String postfix;
    ColorDescriptor foregroundColor;
    ColorDescriptor backgroundColor;
    int style;

    public ConstantLabelDecorationRule(String format, ColorDescriptor foregroundColor, ColorDescriptor backgroundColor, String style) {
        if (format != null) {
            String[] split = format.split("%s", 2);
            if (split.length == 1) {
                this.prefix = "";
                this.postfix = split[0];
            } else {
                this.prefix = split[0];
                this.postfix = split[1];
            }
        }
        this.foregroundColor = foregroundColor;
        this.backgroundColor = backgroundColor;
        this.style = 0;
        if (style != null) {
            char[] cArray = style.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                switch (c) {
                    case 'B': 
                    case 'b': {
                        this.style |= 1;
                        break;
                    }
                    case 'I': 
                    case 'i': {
                        this.style |= 2;
                        break;
                    }
                    default: {
                        System.err.println("Invalid character '" + c + "' in style string. Only B and I recognized.");
                    }
                }
                ++n2;
            }
        }
    }

    private static ColorDescriptor getPossibleRelatedColor(ReadGraph g, Resource subject, Resource predicate) throws DatabaseException {
        Resource value = g.getPossibleObject(subject, predicate);
        if (value == null) {
            return null;
        }
        RGB rgb = (RGB)g.adapt(value, RGB.class);
        return ColorDescriptor.createFrom((RGB)rgb);
    }

    public static ConstantLabelDecorationRule create(ReadGraph g, Resource r) throws DatabaseException {
        ViewpointResource vr = ViewpointResource.getInstance((ReadGraph)g);
        String format = (String)g.getPossibleRelatedValue(r, vr.ConstantLabelDecorationRule_HasFormat, (Binding)Bindings.STRING);
        ColorDescriptor foregroundColor = ConstantLabelDecorationRule.getPossibleRelatedColor(g, r, vr.ConstantLabelDecorationRule_HasForegroundColor);
        ColorDescriptor backgroundColor = ConstantLabelDecorationRule.getPossibleRelatedColor(g, r, vr.ConstantLabelDecorationRule_HasBackgroundColor);
        String style = (String)g.getPossibleRelatedValue(r, vr.ConstantLabelDecorationRule_HasStyle, (Binding)Bindings.STRING);
        return new ConstantLabelDecorationRule(format, foregroundColor, backgroundColor, style);
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return true;
    }

    @Override
    public LabelDecorator getLabelDecorator(ReadGraph graph, Object content) throws DatabaseException {
        return this;
    }

    @Override
    public String decorateLabel(String label, String column, int itemIndex) {
        if (this.postfix == null) {
            return label;
        }
        return String.valueOf(this.prefix) + label + this.postfix;
    }

    @Override
    public <Color> Color decorateForeground(Color color, String column, int itemIndex) {
        if (this.foregroundColor == null) {
            return color;
        }
        return (Color)this.foregroundColor;
    }

    @Override
    public <Color> Color decorateBackground(Color color, String column, int itemIndex) {
        if (this.backgroundColor == null) {
            return color;
        }
        return (Color)this.backgroundColor;
    }

    @Override
    public <Font> Font decorateFont(Font font, String column, int itemIndex) {
        if (this.style == 0) {
            return font;
        }
        FontDescriptor desc = (FontDescriptor)font;
        if (desc == null) {
            desc = FontDescriptor.createFrom((FontData[])JFaceResources.getDialogFont().getFontData());
        }
        return (Font)desc.withStyle(this.style);
    }
}

