/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.server.internal;

import java.util.concurrent.TimeUnit;

class DebugPolicy {
    static final boolean REPORT_DEBUG_EVENTS = false;
    static final boolean REPORT_SERVER_EVENTS = false;
    static final boolean REPORT_DEBUG_OPERATIONS = false;
    static final boolean REPORT_TIME_CONSUMING_REQUESTS = false;
    static final boolean REPORT_TIME_CONSUMING_FUNCTIONS = false;
    private static final TimeUnit LONG_EXECUTION_REPORT_PERIOD_UNIT = TimeUnit.MILLISECONDS;
    private static final long LONG_EXECUTION_REPORT_PERIOD = 10000L;
    static final long REPORT_MS = LONG_EXECUTION_REPORT_PERIOD_UNIT.toMillis(10000L);
    private static final long NON_EXPIRED_EVENT_WAIT_TIME_MS = 60000000L;
    private static final boolean REPORT_WAIT_EVENTS = true;
    private static final boolean REPORT_WAIT_EVENTS_VERBOSE = true;

    DebugPolicy() {
    }

    static final void wait(long waitMs, Object object, String string) {
        DebugPolicy.waitImpl(waitMs, object, string);
    }

    static final void wait(Object object, String string) {
        DebugPolicy.waitImpl(60000000L, object, string);
    }

    private static final void report(String string, Object object) {
        String msg = "DEBUG: " + string + " " + object.getClass().getSimpleName() + " hid=" + System.identityHashCode(object);
        new Throwable(msg).printStackTrace();
    }

    private static final void waitImpl(long waitMs, Object object, String string) {
        DebugPolicy.report("Wait for event started.", object);
        try {
            try {
                object.wait(waitMs);
            }
            catch (InterruptedException interruptedException) {
                DebugPolicy.report("Wait for event interrupted.", object);
                DebugPolicy.report("Wait for event stopped.", object);
            }
        }
        finally {
            DebugPolicy.report("Wait for event stopped.", object);
        }
    }
}

