/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.types;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import org.simantics.databoard.util.IdentityHashSet;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.internal.types.HashCodeUtils;
import org.simantics.scl.compiler.internal.types.TypeHashCodeContext;
import org.simantics.scl.compiler.internal.types.ast.TVarAst;
import org.simantics.scl.compiler.internal.types.ast.TypeAst;
import org.simantics.scl.compiler.types.Skeletons;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.KindUnificationException;
import org.simantics.scl.compiler.types.exceptions.UnificationException;
import org.simantics.scl.compiler.types.kinds.KMetaVar;
import org.simantics.scl.compiler.types.kinds.Kind;
import org.simantics.scl.compiler.types.kinds.Kinds;
import org.simantics.scl.compiler.types.util.Polarity;
import org.simantics.scl.compiler.types.util.TypeUnparsingContext;

public class TMetaVar
extends Type {
    public static final TMetaVar[] EMPTY_ARRAY = new TMetaVar[0];
    public static final boolean DEBUG = false;
    Type ref = null;
    Type skeletonRef = null;
    Polarity polarity = Polarity.NO_POLARITY;
    private Kind kind;
    private TMetaVarListener listener;

    TMetaVar(Kind kind) {
        this.kind = kind;
    }

    TMetaVar(Kind kind, Polarity polarity) {
        this.kind = kind;
        this.polarity = polarity;
    }

    public Kind getKind() {
        if (this.kind instanceof KMetaVar) {
            this.kind = Kinds.canonical(this.kind);
        }
        return this.kind;
    }

    @Override
    public Type replace(TVar var, Type replacement) {
        if (this.ref == null) {
            return this;
        }
        Type newRef = this.ref.replace(var, replacement);
        if (newRef != this.ref) {
            return newRef;
        }
        return this;
    }

    @Override
    public TypeAst toTypeAst(TypeUnparsingContext context) {
        if (this.ref == null) {
            return new TVarAst(context.getName(this));
        }
        return this.ref.toTypeAst(context);
    }

    @Override
    public void updateHashCode(TypeHashCodeContext context) {
        if (this.ref == null) {
            context.append(System.identityHashCode(this));
        } else {
            this.ref.updateHashCode(context);
        }
    }

    @Override
    public void collectFreeVars(ArrayList<TVar> vars) {
        if (this.ref != null) {
            this.ref.collectFreeVars(vars);
        }
    }

    @Override
    public void collectMetaVars(ArrayList<TMetaVar> vars) {
        if (this.ref == null) {
            vars.add(this);
        } else {
            this.ref.collectMetaVars(vars);
        }
    }

    @Override
    public void collectMetaVars(THashSet<TMetaVar> vars) {
        if (this.ref == null) {
            vars.add((Object)this);
        } else {
            this.ref.collectMetaVars(vars);
        }
    }

    @Override
    public void collectEffectMetaVars(ArrayList<TMetaVar> vars) {
        if (this.ref != null) {
            this.ref.collectEffectMetaVars(vars);
        }
    }

    public void setRef(Type type) throws UnificationException {
        if (type == this) {
            throw new InternalCompilerError("Illegal setRef");
        }
        if (this.ref != null) {
            throw new InternalCompilerError("Method setRef should be called only for unbound meta variables.");
        }
        Type thisSkeleton = Skeletons.canonicalSkeleton(this);
        if (type instanceof TMetaVar) {
            TMetaVar other = (TMetaVar)type;
            if (other.ref != null) {
                throw new InternalCompilerError("Not canonical!");
            }
            Type typeSkeleton = Skeletons.canonicalSkeleton(type);
            if (thisSkeleton == typeSkeleton) {
                if (this.skeletonRef != null) {
                    this.setRefBase(type);
                } else {
                    other.setRefBase(this);
                }
                return;
            }
            if (thisSkeleton instanceof TMetaVar && type.contains((TMetaVar)thisSkeleton)) {
                throw new UnificationException(this, type);
            }
        } else if (thisSkeleton instanceof TMetaVar && type.contains((TMetaVar)thisSkeleton)) {
            throw new UnificationException(this, type);
        }
        if (this.skeletonRef != null) {
            Skeletons.unifySkeletons(thisSkeleton, type);
        }
        this.setRefBase(type);
    }

    private void setRefBase(Type type) throws UnificationException {
        this.skeletonRef = null;
        this.ref = type;
        if (this.polarity != Polarity.NO_POLARITY) {
            type.addPolarity(this.polarity);
        }
        this.fireNotifyAboutChange();
    }

    private static String refStructure(Type t) {
        StringBuilder b = new StringBuilder();
        IdentityHashSet seenVars = new IdentityHashSet();
        TMetaVar.refType(b, t, (IdentityHashSet<TMetaVar>)seenVars);
        return b.toString();
    }

    private void refStructure(StringBuilder b, IdentityHashSet<TMetaVar> seenVars) {
        b.append(System.identityHashCode(this));
        if (!seenVars.add((Object)this)) {
            b.append(" (loop)");
        } else if (this.ref != null) {
            b.append(" => ");
            TMetaVar.refType(b, this.ref, seenVars);
        } else if (this.skeletonRef != null) {
            b.append(" -> ");
            TMetaVar.refType(b, this.skeletonRef, seenVars);
        } else {
            b.append(" (canonical)");
        }
    }

    private static void refType(StringBuilder b, Type t, IdentityHashSet<TMetaVar> seenVars) {
        if (t instanceof TMetaVar) {
            ((TMetaVar)t).refStructure(b, seenVars);
        } else {
            b.append('[');
            t.toString(new TypeUnparsingContext(), b);
            b.append(']');
        }
    }

    private void checkRefLoop(TMetaVar var) {
        block4: {
            IdentityHashSet seenVars = new IdentityHashSet();
            StringBuilder b = new StringBuilder();
            while (true) {
                b.append(var);
                if (!seenVars.add((Object)var)) {
                    throw new InternalCompilerError("Cyclic meta var references: " + b);
                }
                if (var.ref != null) {
                    b.append(" => ");
                    if (var.ref instanceof TMetaVar) {
                        var = (TMetaVar)var.ref;
                        continue;
                    }
                    return;
                }
                if (var.skeletonRef == null) break block4;
                b.append(" -> ");
                if (!(var.skeletonRef instanceof TMetaVar)) break;
                var = (TMetaVar)var.skeletonRef;
            }
            return;
        }
    }

    public Type getRef() {
        return this.ref;
    }

    @Override
    public boolean contains(TMetaVar other) {
        if (this.ref != null) {
            return this.ref.contains(other);
        }
        if (this.skeletonRef != null) {
            return this.skeletonRef.contains(other);
        }
        return this == other;
    }

    @Override
    public Type convertMetaVarsToVars() {
        if (this.ref == null) {
            this.ref = this.kind == Kinds.EFFECT && !this.polarity.isNegative() ? Types.NO_EFFECTS : Types.var(this.getKind());
            return this.ref;
        }
        return this.ref.convertMetaVarsToVars();
    }

    @Override
    public boolean isGround() {
        if (this.ref == null) {
            return false;
        }
        return this.ref.isGround();
    }

    @Override
    public Kind inferKind(Environment context) throws KindUnificationException {
        return Kinds.metaVar();
    }

    @Override
    public boolean containsMetaVars() {
        if (this.ref == null) {
            return true;
        }
        return this.ref.containsMetaVars();
    }

    @Override
    public void toName(TypeUnparsingContext context, StringBuilder b) {
        if (this.ref != null) {
            this.ref.toName(context, b);
        } else {
            b.append(context.getName(this));
        }
    }

    @Override
    public int getClassId() {
        return 5;
    }

    @Override
    public boolean isMaximal() {
        return this.ref != null && this.ref.isMaximal();
    }

    @Override
    public boolean isMinimal() {
        return this.ref != null && this.ref.isMinimal();
    }

    @Override
    public void addPolarity(Polarity polarity) {
        if (this.ref != null) {
            this.ref.addPolarity(polarity);
        } else {
            this.polarity = this.polarity.add(polarity);
        }
    }

    public Polarity getPolarity() {
        return this.polarity;
    }

    @Override
    public void collectConcreteEffects(ArrayList<TCon> concreteEffects) {
        if (this.ref != null) {
            this.ref.collectConcreteEffects(concreteEffects);
        }
    }

    @Override
    public Type head() {
        if (this.ref != null) {
            return this.ref.head();
        }
        return this;
    }

    @Override
    public Type copySkeleton(THashMap<TMetaVar, TMetaVar> metaVarMap) {
        if (this.ref != null) {
            return this.ref.copySkeleton(metaVarMap);
        }
        TMetaVar result = (TMetaVar)metaVarMap.get((Object)this);
        if (result == null) {
            result = new TMetaVar(this.kind, this.polarity);
            metaVarMap.put((Object)this, (Object)result);
        }
        return result;
    }

    public void setSkeletonRef(Type type) throws UnificationException {
        if (this.ref != null || this.skeletonRef != null) {
            throw new InternalCompilerError("Method setRef should be called only for unbound meta variables.");
        }
        if (type.contains(this)) {
            throw new UnificationException(this, type);
        }
        this.skeletonRef = type;
        this.fireNotifyAboutChange();
    }

    @Override
    public int hashCode() {
        if (this.ref == null) {
            return System.identityHashCode(this);
        }
        return this.ref.hashCode();
    }

    @Override
    public int hashCode(int hash) {
        if (this.ref == null) {
            return HashCodeUtils.update(hash, System.identityHashCode(this));
        }
        return this.ref.hashCode(hash);
    }

    @Override
    public int hashCode(int hash, TVar[] boundVars) {
        if (this.ref == null) {
            return HashCodeUtils.update(hash, System.identityHashCode(this));
        }
        return this.ref.hashCode(hash, boundVars);
    }

    @Override
    public int skeletonHashCode() {
        if (this.ref != null) {
            return this.ref.skeletonHashCode();
        }
        if (this.skeletonRef != null) {
            return this.skeletonRef.skeletonHashCode();
        }
        return System.identityHashCode(this);
    }

    @Override
    public int skeletonHashCode(int hash) {
        if (this.ref != null) {
            return this.ref.skeletonHashCode(hash);
        }
        if (this.skeletonRef != null) {
            return this.skeletonRef.skeletonHashCode(hash);
        }
        return HashCodeUtils.update(hash, System.identityHashCode(this));
    }

    @Override
    public int skeletonHashCode(int hash, TVar[] boundVars) {
        if (this.ref != null) {
            return this.ref.skeletonHashCode(hash, boundVars);
        }
        if (this.skeletonRef != null) {
            return this.skeletonRef.skeletonHashCode(hash, boundVars);
        }
        return HashCodeUtils.update(hash, System.identityHashCode(this));
    }

    @Override
    public boolean equalsCanonical(Type other) {
        return this == other;
    }

    @Override
    public Type canonical() {
        if (this.ref == null) {
            return this;
        }
        this.ref = this.ref.canonical();
        return this.ref;
    }

    public void addListener(TMetaVarListener newListener) {
        newListener.next = this.listener;
        newListener.prev = this;
        if (this.listener != null) {
            this.listener.prev = newListener;
        }
        this.listener = newListener;
    }

    private void fireNotifyAboutChange() {
        TMetaVarListener cur = this.listener;
        this.listener = null;
        while (cur != null) {
            cur.prev = null;
            cur.notifyAboutChange();
            TMetaVarListener next = cur.next;
            cur.next = null;
            cur = next;
        }
    }

    public TMetaVarListener getLatestListener() {
        return this.listener;
    }

    @Override
    public Kind getKind(Environment context) {
        return this.kind;
    }

    @Override
    public Type[] skeletonCanonicalChildren() {
        return EMPTY_ARRAY;
    }

    public static abstract class TMetaVarListener {
        private Object prev;
        private TMetaVarListener next;

        public abstract void notifyAboutChange();

        public void remove() {
            if (this.prev == null) {
                return;
            }
            if (this.prev instanceof TMetaVar) {
                ((TMetaVar)this.prev).listener = this.next;
            } else {
                ((TMetaVarListener)this.prev).next = this.next;
            }
            if (this.next != null) {
                this.next.prev = this.prev;
                this.next = null;
            }
            this.prev = null;
        }
    }
}

