/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.EError;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;
import org.simantics.scl.compiler.types.util.MultiFunction;

public class EViewPattern
extends Expression {
    public Expression expression;
    public Expression pattern;

    public EViewPattern(Expression expression, Expression pattern) {
        this.expression = expression;
        this.pattern = pattern;
    }

    @Override
    public Expression inferType(TypingContext context) {
        MultiFunction mfun;
        context.setInPattern(false);
        this.expression = this.expression.inferType(context);
        context.setInPattern(true);
        try {
            mfun = Types.matchFunction(this.expression.getType(), 1);
        }
        catch (MatchException matchException) {
            context.getErrorLog().log(this.expression.location, "Expected a function as a transformation expression.");
            return new EError(this.location);
        }
        this.setType(mfun.parameterTypes[0]);
        this.pattern.checkType(context, mfun.returnType);
        return this;
    }

    @Override
    protected void updateType() throws MatchException {
        MultiFunction mfun = Types.matchFunction(this.expression.getType(), 1);
        this.setType(mfun.parameterTypes[0]);
    }

    @Override
    public IVal toVal(CompilationContext context, CodeWriter w) {
        throw new InternalCompilerError(this.location, "EViewPattern.toVal should not be invoked.");
    }

    @Override
    public Expression resolve(TranslationContext context) {
        context.getErrorLog().log("View pattern cannot occur only in patterns. Maybe you are missing '\\' in front of a lambda experssion?");
        return new EError(this.location);
    }

    @Override
    public Expression resolveAsPattern(TranslationContext context) {
        this.expression = this.expression.resolve(context);
        this.pattern = this.pattern.resolveAsPattern(context);
        return this;
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.expression.setLocationDeep(loc);
            this.pattern.setLocationDeep(loc);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        this.expression = this.expression.simplify(context);
        this.pattern = this.pattern.simplify(context);
        return this;
    }
}

