/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.common.names.Names;
import org.simantics.scl.compiler.elaboration.contexts.EnvironmentalContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.EError;
import org.simantics.scl.compiler.elaboration.expressions.EWhen;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.Expressions;
import org.simantics.scl.compiler.elaboration.expressions.SimplifiableExpression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.printing.ExpressionToStringVisitor;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.elaboration.query.compilation.DerivateException;
import org.simantics.scl.compiler.elaboration.relations.LocalRelation;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.internal.elaboration.utils.ForcedClosure;
import org.simantics.scl.compiler.internal.elaboration.utils.StronglyConnectedComponents;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class ERuleset
extends SimplifiableExpression {
    LocalRelation[] relations;
    public DatalogRule[] rules;
    public Expression in;

    public ERuleset(LocalRelation[] relations, DatalogRule[] rules, Expression in) {
        this.relations = relations;
        this.rules = rules;
        this.in = in;
    }

    private void checkRuleTypes(TypingContext context) {
        DatalogRule[] datalogRuleArray = this.rules;
        int n = this.rules.length;
        int n2 = 0;
        while (n2 < n) {
            DatalogRule rule = datalogRuleArray[n2];
            Type[] parameterTypes = rule.headRelation.getParameterTypes();
            Expression[] parameters = rule.headParameters;
            Variable[] variableArray = rule.variables;
            int n3 = rule.variables.length;
            int n4 = 0;
            while (n4 < n3) {
                Variable variable = variableArray[n4];
                variable.setType(Types.metaVar(Kinds.STAR));
                ++n4;
            }
            int i = 0;
            while (i < parameters.length) {
                parameters[i] = parameters[i].checkType(context, parameterTypes[i]);
                ++i;
            }
            rule.body.checkType(context);
            ++n2;
        }
    }

    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        this.checkRuleTypes(context);
        this.in = this.in.checkBasicType(context, requiredType);
        return this.compile(context);
    }

    @Override
    public Expression inferType(TypingContext context) {
        this.checkRuleTypes(context);
        this.in = this.in.inferType(context);
        return this.compile(context);
    }

    @Override
    public Expression checkIgnoredType(TypingContext context) {
        this.checkRuleTypes(context);
        this.in = this.in.checkIgnoredType(context);
        return this.compile(context);
    }

    @Override
    public Expression resolve(TranslationContext context) {
        throw new InternalCompilerError();
    }

    public Expression compile(TypingContext context) {
        TObjectIntHashMap relationsToIds = new TObjectIntHashMap(this.relations.length, 0.5f, -1);
        int i = 0;
        while (i < this.relations.length) {
            relationsToIds.put((Object)this.relations[i], i);
            ++i;
        }
        TIntHashSet[] refsSets = new TIntHashSet[this.relations.length];
        int setCapacity = Math.min(10, this.relations.length);
        int i2 = 0;
        while (i2 < this.relations.length) {
            refsSets[i2] = new TIntHashSet(setCapacity);
            ++i2;
        }
        DatalogRule[] datalogRuleArray = this.rules;
        int n = this.rules.length;
        int n2 = 0;
        while (n2 < n) {
            DatalogRule rule = datalogRuleArray[n2];
            int headRelationId = relationsToIds.get((Object)rule.headRelation);
            TIntHashSet refsSet = refsSets[headRelationId];
            rule.body.collectRelationRefs((TObjectIntHashMap<SCLRelation>)relationsToIds, refsSet);
            Expression[] expressionArray = rule.headParameters;
            int n3 = rule.headParameters.length;
            int n4 = 0;
            while (n4 < n3) {
                Expression parameter = expressionArray[n4];
                parameter.collectRelationRefs((TObjectIntHashMap<SCLRelation>)relationsToIds, refsSet);
                ++n4;
            }
            ++n2;
        }
        final int[][] refs = new int[this.relations.length][];
        int i3 = 0;
        while (i3 < this.relations.length) {
            refs[i3] = refsSets[i3].toArray();
            ++i3;
        }
        final ArrayList components = new ArrayList();
        new StronglyConnectedComponents(this.relations.length){

            @Override
            protected void reportComponent(int[] component) {
                components.add(component);
            }

            @Override
            protected int[] findDependencies(int u) {
                return refs[u];
            }
        }.findComponents();
        if (components.size() == 1) {
            return this.compileStratified(context);
        }
        int[] strataPerRelation = new int[this.relations.length];
        int i4 = 0;
        while (i4 < components.size()) {
            int[] nArray = (int[])components.get(i4);
            int parameter = nArray.length;
            int refsSet = 0;
            while (refsSet < parameter) {
                int k = nArray[refsSet];
                strataPerRelation[k] = i4;
                ++refsSet;
            }
            ++i4;
        }
        ArrayList[] rulesPerStrata = new ArrayList[components.size()];
        int i5 = 0;
        while (i5 < components.size()) {
            rulesPerStrata[i5] = new ArrayList();
            ++i5;
        }
        DatalogRule[] datalogRuleArray2 = this.rules;
        int parameter = this.rules.length;
        int refsSet = 0;
        while (refsSet < parameter) {
            DatalogRule rule = datalogRuleArray2[refsSet];
            int stratum = strataPerRelation[relationsToIds.get((Object)rule.headRelation)];
            rulesPerStrata[stratum].add(rule);
            ++refsSet;
        }
        Expression cur = this.in;
        int stratum = components.size() - 1;
        while (stratum >= 0) {
            int[] cs = (int[])components.get(stratum);
            LocalRelation[] curRelations = new LocalRelation[cs.length];
            int i6 = 0;
            while (i6 < cs.length) {
                curRelations[i6] = this.relations[cs[i6]];
                ++i6;
            }
            ArrayList curRules = rulesPerStrata[stratum];
            cur = new ERuleset(curRelations, curRules.toArray(new DatalogRule[curRules.size()]), cur).compileStratified(context);
            --stratum;
        }
        return cur;
    }

    private Expression compileStratified(TypingContext context) {
        int j;
        Expression continuation = Expressions.tuple();
        Variable[] stacks = new Variable[this.relations.length];
        int i = 0;
        while (i < this.relations.length) {
            LocalRelation relation = this.relations[i];
            Type[] parameterTypes = relation.getParameterTypes();
            stacks[i] = Expressions.newVar("stack" + relation.getName(), Types.apply((Type)Names.MList_T, Types.tuple(parameterTypes)));
            ++i;
        }
        THashMap diffables = new THashMap(this.relations.length);
        int i2 = 0;
        while (i2 < this.relations.length) {
            LocalRelation relation = this.relations[i2];
            Type[] parameterTypes = relation.getParameterTypes();
            Variable[] parameters = new Variable[parameterTypes.length];
            j = 0;
            while (j < parameterTypes.length) {
                parameters[j] = new Variable("p" + j, parameterTypes[j]);
                ++j;
            }
            diffables.put((Object)this.relations[i2], (Object)new Query.Diffable(i2, relation, parameters));
            ++i2;
        }
        ArrayList[] updateExpressions = new ArrayList[this.relations.length];
        int i3 = 0;
        while (i3 < this.relations.length) {
            updateExpressions[i3] = new ArrayList(2);
            ++i3;
        }
        ArrayList<Expression> seedExpressions = new ArrayList<Expression>();
        DatalogRule[] datalogRuleArray = this.rules;
        j = this.rules.length;
        int parameters = 0;
        while (parameters < j) {
            Query.Diff[] diffs;
            DatalogRule rule = datalogRuleArray[parameters];
            int id = ((Query.Diffable)diffables.get((Object)rule.headRelation)).id;
            Expression appendExp = Expressions.apply((EnvironmentalContext)context.getCompilationContext(), (Type)Types.PROC, Names.MList_add, Types.tuple(rule.headRelation.getParameterTypes()), Expressions.var(stacks[id]), Expressions.tuple(rule.headParameters));
            try {
                diffs = rule.body.derivate((THashMap<LocalRelation, Query.Diffable>)diffables);
            }
            catch (DerivateException e) {
                context.getErrorLog().log(e.location, "Recursion must not contain negations or aggragates.");
                return new EError();
            }
            Query.Diff[] diffArray = diffs;
            int n = diffs.length;
            int n2 = 0;
            while (n2 < n) {
                Query.Diff diff = diffArray[n2];
                updateExpressions[diff.id].add(((EWhen)new EWhen(rule.location, diff.query, appendExp, rule.variables).copy(context)).compile(context));
                ++n2;
            }
            if (diffs.length == 0) {
                seedExpressions.add(((EWhen)new EWhen(rule.location, rule.body, appendExp, rule.variables).copy(context)).compile(context));
            } else {
                Query query = rule.body.removeRelations(diffables.keySet());
                if (query != Query.EMPTY_QUERY) {
                    seedExpressions.add(((EWhen)new EWhen(this.location, query, appendExp, rule.variables).copy(context)).compile(context));
                }
            }
            ++parameters;
        }
        Variable[] loops = new Variable[this.relations.length];
        int i4 = 0;
        while (i4 < loops.length) {
            loops[i4] = Expressions.newVar("loop" + this.relations[i4].getName(), Types.functionE(Types.INTEGER, (Type)Types.PROC, (Type)Types.UNIT));
            ++i4;
        }
        continuation = Expressions.seq(Expressions.apply(Types.PROC, Expressions.var(loops[0]), Expressions.integer(this.relations.length - 1)), continuation);
        Expression[] loopDefs = new Expression[this.relations.length];
        int i5 = 0;
        while (i5 < this.relations.length) {
            LocalRelation relation = this.relations[i5];
            Type[] parameterTypes = relation.getParameterTypes();
            Variable[] parameters2 = ((Query.Diffable)diffables.get((Object)relation)).parameters;
            Variable counter = Expressions.newVar("counter", Types.INTEGER);
            Type rowType = Types.tuple(parameterTypes);
            Variable row = Expressions.newVar("row", rowType);
            Expression handleRow = Expressions.tuple();
            for (Expression updateExpression : updateExpressions[i5]) {
                handleRow = Expressions.seq(updateExpression, handleRow);
            }
            handleRow = Expressions.if_(Expressions.apply((EnvironmentalContext)context.getCompilationContext(), (Type)Types.PROC, Names.MSet_add, rowType, Expressions.var(relation.table), Expressions.var(row)), handleRow, Expressions.tuple());
            handleRow = Expressions.seq(handleRow, Expressions.apply(Types.PROC, Expressions.var(loops[i5]), Expressions.integer(this.relations.length - 1)));
            Expression failure = Expressions.if_(Expressions.isZeroInteger(Expressions.var(counter)), Expressions.tuple(), Expressions.apply(Types.PROC, Expressions.var(loops[(i5 + 1) % this.relations.length]), Expressions.addInteger(Expressions.var(counter), Expressions.integer(-1))));
            Expression body = Expressions.matchWithDefault(Expressions.apply((EnvironmentalContext)context.getCompilationContext(), (Type)Types.PROC, Names.MList_removeLast, rowType, Expressions.var(stacks[i5])), Expressions.Just(Expressions.as(row, Expressions.tuple(Expressions.vars(parameters2)))), handleRow, failure);
            loopDefs[i5] = Expressions.lambda((Type)Types.PROC, counter, body);
            ++i5;
        }
        continuation = Expressions.letRec(loops, loopDefs, continuation);
        for (Expression seedExpression : seedExpressions) {
            continuation = Expressions.seq(seedExpression, continuation);
        }
        i = 0;
        while (i < stacks.length) {
            continuation = Expressions.let(stacks[i], Expressions.apply((EnvironmentalContext)context.getCompilationContext(), (Type)Types.PROC, Names.MList_create, Types.tuple(this.relations[i].getParameterTypes()), Expressions.tuple()), continuation);
            ++i;
        }
        continuation = ForcedClosure.forceClosure(continuation, true);
        LocalRelation[] localRelationArray = this.relations;
        int n = this.relations.length;
        int n3 = 0;
        while (n3 < n) {
            LocalRelation relation = localRelationArray[n3];
            continuation = Expressions.let(relation.table, Expressions.apply((EnvironmentalContext)context.getCompilationContext(), (Type)Types.PROC, Names.MSet_create, Types.tuple(relation.getParameterTypes()), Expressions.tuple()), continuation);
            ++n3;
        }
        return Expressions.seq(continuation, this.in);
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(this.in.getType());
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            DatalogRule[] datalogRuleArray = this.rules;
            int n = this.rules.length;
            int n2 = 0;
            while (n2 < n) {
                DatalogRule rule = datalogRuleArray[n2];
                rule.setLocationDeep(loc);
                ++n2;
            }
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public DatalogRule[] getRules() {
        return this.rules;
    }

    public Expression getIn() {
        return this.in;
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }

    public static class DatalogRule {
        public long location;
        public LocalRelation headRelation;
        public Expression[] headParameters;
        public Query body;
        public Variable[] variables;

        public DatalogRule(LocalRelation headRelation, Expression[] headParameters, Query body) {
            this.headRelation = headRelation;
            this.headParameters = headParameters;
            this.body = body;
        }

        public DatalogRule(long location, LocalRelation headRelation, Expression[] headParameters, Query body, Variable[] variables) {
            this.location = location;
            this.headRelation = headRelation;
            this.headParameters = headParameters;
            this.body = body;
            this.variables = variables;
        }

        public void setLocationDeep(long loc) {
            this.location = loc;
            Expression[] expressionArray = this.headParameters;
            int n = this.headParameters.length;
            int n2 = 0;
            while (n2 < n) {
                Expression parameter = expressionArray[n2];
                parameter.setLocationDeep(loc);
                ++n2;
            }
            this.body.setLocationDeep(loc);
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            ExpressionToStringVisitor visitor = new ExpressionToStringVisitor(b);
            visitor.visit(this);
            return b.toString();
        }
    }

    static class LocalRelationAux {
        Variable handleFunc;

        LocalRelationAux() {
        }
    }
}

