/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.common.names.Names;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Case;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.ELambda;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.SimplifiableExpression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.block.BlockType;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.types.TApply;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;
import org.simantics.scl.compiler.types.exceptions.UnificationException;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class EBind
extends SimplifiableExpression {
    BlockType blockType;
    public Expression pattern;
    public Expression value;
    public Expression in;
    public EVariable monadEvidence;
    Type monadType;
    Type effect;
    Type valueContentType;
    Type inContentType;

    public EBind(long loc, BlockType blockType, Expression pattern, Expression value, Expression in) {
        super(loc);
        this.blockType = blockType;
        this.pattern = pattern;
        this.value = value;
        this.in = in;
    }

    public EBind(long loc, BlockType blockType, Expression pattern, Expression value, Expression in, SCLValue bindFunction) {
        super(loc);
        this.blockType = blockType;
        this.pattern = pattern;
        this.value = value;
        this.in = in;
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(this.in.getType());
    }

    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        this.monadType = Types.metaVar(Kinds.STAR_TO_STAR);
        this.inContentType = Types.metaVar(Kinds.STAR);
        TApply monadContent = Types.apply(this.monadType, this.inContentType);
        try {
            Types.unify(requiredType, (Type)monadContent);
        }
        catch (UnificationException unificationException) {
            context.typeError(this.location, requiredType, monadContent);
            return this;
        }
        Variable variable = new Variable("monadEvidence");
        variable.setType(Types.pred(this.blockType == BlockType.MonadE ? Types.MONAD_E : Types.MONAD, this.monadType));
        this.monadEvidence = new EVariable(this.getLocation(), variable);
        this.monadEvidence.setType(variable.getType());
        context.addConstraintDemand(this.monadEvidence);
        this.pattern = this.pattern.checkTypeAsPattern(context, Types.metaVar(Kinds.STAR));
        this.valueContentType = this.pattern.getType();
        this.value = this.value.checkType(context, Types.apply(this.monadType, this.valueContentType));
        context.pushEffectUpperBound(this.location, this.blockType == BlockType.Monad ? Types.NO_EFFECTS : Types.metaVar(Kinds.EFFECT));
        this.in = this.in.checkType(context, requiredType);
        this.effect = context.popEffectUpperBound();
        Type inType = this.in.getType();
        this.setType(inType);
        return this;
    }

    @Override
    public IVal toVal(CompilationContext context, CodeWriter w) {
        throw new InternalCompilerError("EBind should be eliminated.");
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        Type[] typeArray;
        this.value = this.value.simplify(context);
        this.in = this.in.simplify(context);
        this.pattern = this.pattern.simplify(context);
        long loc = this.getLocation();
        this.monadType = Types.canonical(this.monadType);
        this.valueContentType = Types.canonical(this.valueContentType);
        this.effect = Types.canonical(this.effect);
        this.inContentType = Types.canonical(this.inContentType);
        if (this.blockType == BlockType.MonadE) {
            Type[] typeArray2 = new Type[4];
            typeArray2[0] = this.monadType;
            typeArray2[1] = this.valueContentType;
            typeArray2[2] = this.effect;
            typeArray = typeArray2;
            typeArray2[3] = this.inContentType;
        } else {
            Type[] typeArray3 = new Type[3];
            typeArray3[0] = this.monadType;
            typeArray3[1] = this.valueContentType;
            typeArray = typeArray3;
            typeArray3[2] = this.inContentType;
        }
        Type[] types = typeArray;
        EApply simplified = new EApply(loc, (Expression)new EConstant(loc, context.getValue(this.blockType == BlockType.MonadE ? Names.Prelude_bindE : Names.Prelude_bind), types), this.monadEvidence, this.value, new ELambda(loc, new Case(new Expression[]{this.pattern}, this.in)));
        simplified.setType(this.getType());
        return ((Expression)simplified).simplify(context);
    }

    @Override
    public Expression resolve(TranslationContext context) {
        this.value = this.value.resolve(context);
        context.pushFrame();
        this.pattern = this.pattern.resolveAsPattern(context);
        this.in = this.in.resolve(context);
        context.popFrame();
        return this;
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.pattern.setLocationDeep(loc);
            this.value.setLocationDeep(loc);
            this.in.setLocationDeep(loc);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }
}

