/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.chr.plan;

import java.util.ArrayList;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.constants.JavaComparisonOperation;
import org.simantics.scl.compiler.constants.singletons.NullCheck;
import org.simantics.scl.compiler.elaboration.chr.plan.PartnerFact;
import org.simantics.scl.compiler.elaboration.chr.plan.PlanContext;
import org.simantics.scl.compiler.elaboration.chr.plan.PlanOp;
import org.simantics.scl.compiler.elaboration.chr.relations.CHRConstraint;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.internal.codegen.continuations.ICont;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;

public class IterateConstraintOp
extends PlanOp {
    public CHRConstraint constraint;
    public Variable[] variables;
    public Expression[] expressions;
    public int boundMask;
    public boolean killAfterMatch;
    public boolean passive;

    public IterateConstraintOp(long location, CHRConstraint constraint, Variable[] variables, Expression[] expressions, int boundMask, boolean killAfterMatch, boolean passive) {
        super(location);
        this.constraint = constraint;
        this.variables = variables;
        this.expressions = expressions;
        this.boundMask = boundMask;
        this.killAfterMatch = killAfterMatch;
        this.passive = passive;
    }

    @Override
    public void toString(StringBuilder b) {
        b.append("ITERATE ").append(this.constraint);
        int i = 0;
        while (i < this.expressions.length) {
            if ((this.boundMask & 1 << i) != 0) {
                b.append(" (").append(this.expressions[i]).append(")");
            } else {
                b.append(" ").append(this.variables[i]);
            }
            ++i;
        }
    }

    @Override
    public void generateCode(CompilationContext context, PlanContext planContext, CodeWriter w) {
        CodeWriter body = w.createBlock(this.constraint.factType);
        CodeWriter nextFact = w.createBlock();
        ICont bodyContinuation = body.getContinuation();
        CodeWriter end = w.createBlock();
        IVal fact = body.getParameters()[0];
        ArrayList<IVal> parameters = new ArrayList<IVal>(this.expressions.length + 1);
        parameters.add(planContext.getStoreVar(this.constraint));
        int i = 0;
        while (i < this.expressions.length) {
            if ((this.boundMask >> i & 1) == 1) {
                parameters.add(this.expressions[i].toVal(context, w));
            }
            ++i;
        }
        w.jump(bodyContinuation, w.apply(this.location, this.constraint.fetchFromIndex(context, this.boundMask), parameters.toArray(new IVal[parameters.size()])));
        body.branchAwayIf(body.apply(this.location, NullCheck.INSTANCE.createSpecialization(this.constraint.factType), fact), end.getContinuation());
        IVal id = body.apply(this.location, this.constraint.accessId, fact);
        for (PartnerFact partnerFact : planContext.partnerFacts) {
            if (partnerFact.active && !this.passive) {
                body.branchAwayUnless(body.apply(this.location, JavaComparisonOperation.ILESS, id, partnerFact.id), nextFact.getContinuation());
                continue;
            }
            if (partnerFact.constraint != this.constraint) continue;
            body.branchAwayIf(body.apply(this.location, JavaComparisonOperation.IEQUAL, id, partnerFact.id), nextFact.getContinuation());
        }
        int i2 = 0;
        while (i2 < this.variables.length) {
            if ((this.boundMask >> i2 & 1) == 0) {
                this.variables[i2].setVal(this.constraint.accessComponent(this.location, body, fact, i2));
            }
            ++i2;
        }
        Constant nextElement = this.constraint.nextElement(context, this.boundMask);
        planContext.partnerFacts.add(new PartnerFact(false, id, this.constraint, fact, this.constraint.mayBeRemoved(), this.killAfterMatch, nextElement, bodyContinuation, end.getContinuation()));
        planContext.nextOp(body);
        if (body.isUnfinished()) {
            body.jump(nextFact.getContinuation(), new IVal[0]);
        }
        nextFact.jump(bodyContinuation, nextFact.apply(this.location, nextElement, fact));
        w.continueAs(end);
    }
}

