/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.constants;

import org.cojen.classfile.TypeDesc;
import org.objectweb.asm.Label;
import org.simantics.scl.compiler.constants.FunctionValue;
import org.simantics.scl.compiler.internal.codegen.continuations.Cont;
import org.simantics.scl.compiler.internal.codegen.references.BoundVar;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.internal.codegen.utils.ClassBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.CodeBuilderUtils;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class SCLConstructor
extends FunctionValue {
    private static int MAX_FIELD_COUNT = 32;
    public static String[][] DEFAULT_FIELD_NAMES = new String[MAX_FIELD_COUNT + 1][];
    String name;
    String className;
    String[] fieldNames;
    boolean onlyConstructor;
    int constructorTag;
    public final String[] recordFieldNames;

    static {
        int i = 0;
        while (i <= MAX_FIELD_COUNT) {
            String[] fieldNames = new String[i];
            int j = 0;
            while (j < i) {
                fieldNames[j] = "c" + j;
                ++j;
            }
            SCLConstructor.DEFAULT_FIELD_NAMES[i] = fieldNames;
            ++i;
        }
    }

    public SCLConstructor(String name, String className, TVar[] typeParameters, int constructorTag, Type returnType, String[] fieldNames, String[] recordFieldNames, Type ... parameterTypes) {
        super(typeParameters, Types.NO_EFFECTS, returnType, parameterTypes);
        ClassBuilder.checkClassName(className);
        this.name = name;
        this.className = className;
        this.fieldNames = fieldNames;
        this.constructorTag = constructorTag;
        this.recordFieldNames = recordFieldNames;
    }

    public SCLConstructor(String name, String className, TVar[] typeParameters, int constructorTag, Type returnType, Type ... parameterTypes) {
        this(name, className, typeParameters, constructorTag, returnType, DEFAULT_FIELD_NAMES[parameterTypes.length], null, parameterTypes);
    }

    public void setOnlyConstructor(boolean onlyConstructor) {
        this.onlyConstructor = onlyConstructor;
    }

    @Override
    public Type applyExact(MethodBuilder mb, Val[] parameters) {
        if (this.className == null) {
            mb.push(parameters[0], this.parameterTypes[0]);
            return this.getReturnType();
        }
        TypeDesc typeDesc = TypeDesc.forClass(this.className);
        CodeBuilderUtils.constructRecord(typeDesc, mb, this.parameterTypes, parameters);
        return this.getReturnType();
    }

    @Override
    public void deconstruct(MethodBuilder mb, IVal parameter, Cont success, Label failure) {
        JavaTypeTranslator javaTypeTranslator = mb.getJavaTypeTranslator();
        if (this.onlyConstructor) {
            if (this.className == null) {
                Type expectedType;
                TypeDesc expectedDesc;
                TypeDesc parameterDesc = javaTypeTranslator.getTypeDesc(parameter);
                if (parameterDesc.equals(expectedDesc = javaTypeTranslator.toTypeDesc(expectedType = success.getParameterType(0)))) {
                    mb.jump(success, parameter);
                } else {
                    parameter.push(mb);
                    mb.unbox(expectedType);
                    BoundVar boundVar = new BoundVar(expectedType);
                    mb.store(boundVar);
                    mb.jump(success, boundVar);
                }
                return;
            }
            failure = null;
        }
        Label failureLabel = mb.createLabel();
        TypeDesc constructorType = TypeDesc.forClass(this.className);
        mb.push(parameter, this.returnType);
        if (failure != null) {
            mb.dup();
            mb.instanceOf(constructorType);
            mb.ifZeroComparisonBranch(failureLabel, "==");
        }
        if (!this.onlyConstructor) {
            mb.checkCast(constructorType);
        }
        IVal[] parameters = new Val[this.parameterTypes.length];
        int i = 0;
        while (i < this.parameterTypes.length) {
            TypeDesc typeDesc = javaTypeTranslator.toTypeDesc(this.parameterTypes[i]);
            Type contType = success.getParameterType(i);
            if (!typeDesc.equals(TypeDesc.VOID)) {
                mb.dup();
                mb.loadField(MethodBuilder.getClassName(constructorType), this.fieldNames[i], typeDesc);
                if (typeDesc == TypeDesc.OBJECT) {
                    mb.unbox(contType);
                }
            }
            BoundVar boundVar = new BoundVar(contType);
            mb.store(boundVar);
            parameters[i] = boundVar;
            ++i;
        }
        mb.pop();
        mb.jump(success, parameters);
        if (failure != null) {
            mb.setLocation(failureLabel);
            mb.pop();
            mb.branch(failure);
        }
    }

    @Override
    public int constructorTag() {
        return this.constructorTag;
    }

    public String toString() {
        return this.name;
    }
}

