/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.compilation;

import gnu.trove.map.hash.THashMap;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.elaboration.contexts.EnvironmentalContext;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EError;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.errors.ErrorLog;
import org.simantics.scl.compiler.internal.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.internal.codegen.utils.JavaNamingPolicy;
import org.simantics.scl.compiler.internal.header.ModuleHeader;
import org.simantics.scl.compiler.module.ConcreteModule;
import org.simantics.scl.compiler.types.Type;

public class CompilationContext
implements EnvironmentalContext {
    public final ErrorLog errorLog = new ErrorLog();
    public Environment environment;
    public JavaTypeTranslator javaTypeTranslator;
    public JavaNamingPolicy namingPolicy;
    public ConcreteModule module;
    public ModuleHeader header;
    private THashMap<Name, SCLValue> valueCache = new THashMap();

    @Override
    public SCLValue getValue(Name name) {
        if (this.valueCache.containsKey((Object)name)) {
            return (SCLValue)this.valueCache.get((Object)name);
        }
        SCLValue value = this.environment.getValue(name);
        if (value == null) {
            this.errorLog.log(9223372034707292160L, "Couldn't find " + name + ".");
        }
        this.valueCache.put((Object)name, (Object)value);
        return value;
    }

    public Expression getConstant(Name name, Type ... typeParameters) {
        SCLValue value = this.getValue(name);
        if (value == null) {
            return new EError(9223372034707292160L);
        }
        return new EConstant(value, typeParameters);
    }
}

