/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.componentTypeEditor;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.ui.componentTypeEditor.SCLModuleEditor;
import org.simantics.modeling.ui.componentTypeEditor.SCLModuleEditorDocumentProvider;
import org.simantics.scl.compiler.errors.CompilationError;
import org.simantics.scl.ui.editor.SCLSourceViewerConfigurationNew;
import org.simantics.scl.ui.editor.TextAndErrors;
import org.simantics.ui.workbench.ResourceEditorInput;
import org.simantics.utils.logging.TimeLogger;
import org.simantics.utils.ui.SWTUtils;

public class SymbolCodeDocumentProvider2
extends SCLModuleEditorDocumentProvider {
    Display display;
    SCLModuleEditor editor;

    public SymbolCodeDocumentProvider2(SCLSourceViewerConfigurationNew sourceViewer, Display display, SCLModuleEditor editor) {
        super(sourceViewer);
        this.display = display;
        this.editor = editor;
    }

    @Override
    protected IDocument createDocument(Object element) throws CoreException {
        ResourceEditorInput input = (ResourceEditorInput)element;
        this.resource = input.getResource();
        try {
            return (IDocument)Simantics.getSession().syncRequest((Read)new UniqueRead<Document>(){

                public Document perform(ReadGraph graph) throws DatabaseException {
                    return new Document(SymbolCodeDocumentProvider2.this.getText(graph));
                }
            });
        }
        catch (DatabaseException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            return new Document(sw.toString());
        }
    }

    private String getText(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Iterator iterator = graph.getAssertedObjects(this.resource, DIA.symbolCode).iterator();
        if (iterator.hasNext()) {
            Resource text = (Resource)iterator.next();
            this.errorHappened = false;
            return (String)graph.getRelatedValue(text, L0.SCLValue_expression, (Binding)Bindings.STRING);
        }
        return "";
    }

    @Override
    protected void updateAnnotations() {
        Simantics.getSession().asyncRequest((Read)new ResourceRead<TextAndErrors>(this.resource){

            public TextAndErrors perform(ReadGraph graph) throws DatabaseException {
                return new TextAndErrors(SymbolCodeDocumentProvider2.this.getText(graph), CompilationError.EMPTY_ARRAY);
            }
        }, (Listener)new Listener<TextAndErrors>(){

            public void execute(final TextAndErrors textAndErrors) {
                if (SymbolCodeDocumentProvider2.this.editor.isDisposed()) {
                    return;
                }
                SWTUtils.asyncExec((Display)SymbolCodeDocumentProvider2.this.display, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if ((this).SymbolCodeDocumentProvider2.this.editor.isDisposed()) {
                            return;
                        }
                        if (textAndErrors.errors.length > 0) {
                            SymbolCodeDocumentProvider2.this.setAnnotations(Arrays.asList(textAndErrors.errors));
                        } else {
                            SymbolCodeDocumentProvider2.this.setAnnotations(Collections.emptyList());
                        }
                    }
                });
            }

            public void exception(Throwable t) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.modeling.ui", "Internal error in procedural user component code compilation.", t));
            }

            public boolean isDisposed() {
                return SymbolCodeDocumentProvider2.this.editor.isDisposed();
            }
        });
    }

    @Override
    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        TimeLogger.resetTimeAndLog(((Object)((Object)this)).getClass(), (String)"doSaveDocument");
        this.currentText = document.get();
        Simantics.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                graph.markUndoPoint();
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                Collection ass = graph.getAssertedObjects(SymbolCodeDocumentProvider2.this.resource, DIA.symbolCode);
                if (ass.size() == 0) {
                    ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                    Resource newValue = graph.newResource();
                    graph.claim(newValue, L0.InstanceOf, MOD.SCLValue);
                    graph.claimLiteral(newValue, L0.HasValueType, (Object)"[String]", (Binding)Bindings.STRING);
                    graph.claimLiteral(newValue, L0.SCLValue_expression, (Object)SymbolCodeDocumentProvider2.this.currentText, (Binding)Bindings.STRING);
                    Layer0Utils.assert_((WriteGraph)graph, (Resource)SymbolCodeDocumentProvider2.this.resource, (Resource)DIA.symbolCode, (Resource)newValue);
                    return;
                }
                Iterator iterator = ass.iterator();
                if (iterator.hasNext()) {
                    Resource text = (Resource)iterator.next();
                    graph.claimLiteral(text, L0.SCLValue_expression, (Object)SymbolCodeDocumentProvider2.this.currentText, (Binding)Bindings.STRING);
                    return;
                }
            }
        });
    }
}

