/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.scl;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectProcedure;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.scl.GraphEntityType;
import org.simantics.modeling.scl.GraphPropertyRelation;
import org.simantics.modeling.scl.GraphRelation;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.elaboration.expressions.EExternalConstant;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.relations.SCLEntityType;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.environment.filter.NamespaceFilter;
import org.simantics.scl.compiler.module.ImportDeclaration;
import org.simantics.scl.compiler.module.LazyModule;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.SCLTypeParseException;
import org.simantics.scl.runtime.SCLContext;

public class OntologyModule
extends LazyModule {
    private static final String DB_MODULE = "Simantics/DB";
    private static final Collection<ImportDeclaration> DEPENDENCIES = Arrays.asList(new ImportDeclaration("Simantics/DB", null));
    private static final TCon RESOURCE = Types.con((String)"Simantics/DB", (String)"Resource");
    Resource ontology;
    String defaultLocalName;
    THashMap<Resource, Map<String, Resource>> childMaps = new THashMap();

    public OntologyModule(ReadGraph graph, String moduleName) throws DatabaseException {
        super(moduleName);
        this.ontology = graph.getResource(moduleName);
        this.readDefaultLocalName(graph);
        this.childMaps.put((Object)this.ontology, OntologyModule.createLocalMap(graph, this.ontology));
    }

    private void readDefaultLocalName(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        this.defaultLocalName = (String)graph.getPossibleRelatedValue(this.ontology, L0.Ontology_defaultLocalName);
        if (this.defaultLocalName == null) {
            this.defaultLocalName = "";
        }
    }

    public String getDefaultLocalName() {
        return this.defaultLocalName;
    }

    public List<ImportDeclaration> getDependencies() {
        return Collections.emptyList();
    }

    private Resource getResource(String name) {
        int p;
        Map<String, Resource> localMap = (Map<String, Resource>)this.childMaps.get((Object)this.ontology);
        if (localMap == null) {
            return null;
        }
        while ((p = name.indexOf(46)) >= 0) {
            String localName = name.substring(0, p);
            Resource newParent = (Resource)localMap.get(localName);
            if (newParent == null) {
                return null;
            }
            name = name.substring(p + 1);
            localMap = this.getLocalMap(newParent);
            if (localMap != null) continue;
            return null;
        }
        return (Resource)localMap.get(name);
    }

    private Map<String, Resource> getLocalMap(Resource parent) {
        Map<String, Resource> localMap = (Map<String, Resource>)this.childMaps.get((Object)parent);
        if (localMap == null) {
            if (this.childMaps.contains((Object)parent)) {
                return null;
            }
            localMap = OntologyModule.createLocalMap(parent);
            this.childMaps.put((Object)parent, localMap);
        }
        return localMap;
    }

    private static Map<String, Resource> createLocalMap(final Resource parent) {
        ReadGraph graph = (ReadGraph)SCLContext.getCurrent().get((Object)"graph");
        if (graph != null) {
            return OntologyModule.createLocalMap(graph, parent);
        }
        try {
            return (Map)Simantics.getSession().syncRequest((Read)new Read<Map<String, Resource>>(){

                public Map<String, Resource> perform(ReadGraph graph) throws DatabaseException {
                    return OntologyModule.createLocalMap(graph, parent);
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Map<String, Resource> createLocalMap(ReadGraph graph, Resource parent) {
        try {
            return (Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(parent));
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected SCLValue createValue(String name) {
        Resource resource = this.getResource(name);
        if (resource == null) {
            return null;
        }
        SCLValue value = new SCLValue(Name.create((String)this.getName(), (String)name));
        value.setType((Type)RESOURCE);
        value.setExpression((Expression)new EExternalConstant((Object)resource, (Type)RESOURCE));
        value.setInlineInSimplification(true);
        return value;
    }

    protected SCLRelation createRelation(String name) {
        final Resource resource = this.getResource(name);
        if (resource == null) {
            return null;
        }
        ReadGraph graph = (ReadGraph)SCLContext.getCurrent().get((Object)"graph");
        if (graph != null) {
            return OntologyModule.createRelation(graph, resource);
        }
        try {
            return (SCLRelation)Simantics.getSession().syncRequest((Read)new Read<SCLRelation>(){

                public SCLRelation perform(ReadGraph graph) throws DatabaseException {
                    return OntologyModule.createRelation(graph, resource);
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SCLRelation createRelation(ReadGraph graph, Resource relation) {
        Type valueType;
        Layer0 L0;
        block4: {
            try {
                L0 = Layer0.getInstance((ReadGraph)graph);
                if (graph.isInstanceOf(relation, L0.Relation)) break block4;
                return null;
            }
            catch (DatabaseException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (graph.isInstanceOf(relation, L0.PropertyRelation) && graph.isInstanceOf(relation, L0.FunctionalRelation) && (valueType = OntologyModule.getValueType(graph, relation)) != null) {
            return new GraphPropertyRelation(relation, valueType);
        }
        Resource inverseRelation = graph.getPossibleInverse(relation);
        return new GraphRelation(relation, OntologyModule.getSelectivity(graph, relation), inverseRelation, OntologyModule.getSelectivity(graph, inverseRelation));
    }

    protected SCLEntityType createEntityType(String name) {
        final Resource resource = this.getResource(name);
        if (resource == null) {
            return null;
        }
        ReadGraph graph = (ReadGraph)SCLContext.getCurrent().get((Object)"graph");
        if (graph != null) {
            return this.createEntityType(graph, resource);
        }
        try {
            return (SCLEntityType)Simantics.getSession().syncRequest((Read)new Read<SCLEntityType>(){

                public SCLEntityType perform(ReadGraph graph) throws DatabaseException {
                    return OntologyModule.this.createEntityType(graph, resource);
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private SCLEntityType createEntityType(ReadGraph graph, Resource type) {
        block3: {
            try {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                if (graph.isInstanceOf(type, L0.Type)) break block3;
                return null;
            }
            catch (DatabaseException e) {
                e.printStackTrace();
                return null;
            }
        }
        return new GraphEntityType(graph, type);
    }

    private static double getSelectivity(ReadGraph graph, Resource relation) throws DatabaseException {
        if (relation == null) {
            return Double.POSITIVE_INFINITY;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(relation, L0.FunctionalRelation)) {
            return 1.0;
        }
        return 10.0;
    }

    private static Type getValueType(ReadGraph graph, Resource relation) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Type valueType = OntologyModule.parseValueType((String)graph.getPossibleRelatedValue(relation, L0.RequiresValueType, (Binding)Bindings.STRING));
        if (valueType != null) {
            return valueType;
        }
        Resource range = graph.getPossibleObject(relation, L0.HasRange);
        if (range != null) {
            for (Resource valueTypeLiteral : graph.getAssertedObjects(range, L0.HasValueType)) {
                valueType = OntologyModule.parseValueType((String)graph.getValue(valueTypeLiteral, (Binding)Bindings.STRING));
                if (valueType == null) continue;
                return valueType;
            }
        }
        return null;
    }

    private static Type parseValueType(String valueTypeString) {
        if (valueTypeString == null) {
            return null;
        }
        try {
            return Types.parseType((String)valueTypeString);
        }
        catch (SCLTypeParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void findValuesForPrefix(String prefix, NamespaceFilter filter, TObjectProcedure<SCLValue> proc) {
        int p;
        Map<String, Resource> localMap = (Map<String, Resource>)this.childMaps.get((Object)this.ontology);
        if (localMap == null) {
            return;
        }
        String namePrefix = "";
        while ((p = prefix.indexOf(46)) >= 0) {
            String localName = prefix.substring(0, p);
            Resource newParent = (Resource)localMap.get(localName);
            if (newParent == null) {
                return;
            }
            prefix = prefix.substring(p + 1);
            namePrefix = String.valueOf(namePrefix) + localName + ".";
            localMap = this.getLocalMap(newParent);
            if (localMap != null) continue;
            return;
        }
        for (String name : localMap.keySet()) {
            if (!name.startsWith(prefix) || !filter.isValueIncluded(name)) continue;
            proc.execute((Object)this.getValue(String.valueOf(namePrefix) + name));
        }
    }

    public void findValuesForPrefix(String prefix, NamespaceFilter filter, Consumer<SCLValue> consumer) {
        int p;
        Map<String, Resource> localMap = (Map<String, Resource>)this.childMaps.get((Object)this.ontology);
        if (localMap == null) {
            return;
        }
        String namePrefix = "";
        while ((p = prefix.indexOf(46)) >= 0) {
            String localName = prefix.substring(0, p);
            Resource newParent = (Resource)localMap.get(localName);
            if (newParent == null) {
                return;
            }
            prefix = prefix.substring(p + 1);
            namePrefix = String.valueOf(namePrefix) + localName + ".";
            localMap = this.getLocalMap(newParent);
            if (localMap != null) continue;
            return;
        }
        for (String name : localMap.keySet()) {
            if (!name.startsWith(prefix) || !filter.isValueIncluded(name)) continue;
            consumer.accept(this.getValue(String.valueOf(namePrefix) + name));
        }
    }

    public void findTypesForPrefix(String prefix, NamespaceFilter instance, Consumer<TCon> consumer) {
    }

    public void dispose() {
        this.childMaps.clear();
        this.childMaps = null;
        this.ontology = null;
    }

    public String toString() {
        return "OntologyModule " + this.getName();
    }

    public ClassLoader getParentClassLoader() {
        return ((Object)((Object)this)).getClass().getClassLoader();
    }
}

