/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling;

import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.common.utils.VersionMap;
import org.simantics.db.common.utils.Versions;
import org.simantics.db.exception.CancelTransactionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.request.ActiveModels;
import org.simantics.db.layer0.request.ListIndexRoots;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.MigrateModel;
import org.simantics.modeling.ModelingUtils;
import org.simantics.modeling.migration.UserComponentPostMigrationAction;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.datastructures.MapList;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.datastructures.Triple;
import org.simantics.utils.strings.AlphanumComparator;

public class UserComponentMigration {
    private static final Comparator<NamedResource> NAMED_RESOURCE_COMPARATOR = new Comparator<NamedResource>(){

        @Override
        public int compare(NamedResource o1, NamedResource o2) {
            return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)o1.getName(), (Object)o2.getName());
        }
    };

    public static void migrateUserComponents(WriteGraph graph, Resource source, Resource target, Collection<Resource> components) throws DatabaseException {
        MigrateModel model = UserComponentMigration.getComponentTypeModel((ReadGraph)graph, source, target, null);
        if (model.instances.isEmpty()) {
            return;
        }
        Triple<String, NamedResource, Collection<MigrateModel.MigrationOperation>> instances = model.instances.get(0);
        ArrayList<MigrateModel.MigrationOperation> result = new ArrayList<MigrateModel.MigrationOperation>();
        for (MigrateModel.MigrationOperation instance : (Collection)instances.third) {
            if (!components.contains(instance.instanceToMigrate.getResource())) continue;
            result.add(instance);
        }
        if (!result.isEmpty()) {
            UserComponentMigration.doMigration((IProgressMonitor)new NullProgressMonitor(), graph, result);
        }
    }

    public static String doMigration(IProgressMonitor monitor, WriteGraph graph, ArrayList<MigrateModel.MigrationOperation> operations) throws DatabaseException {
        graph.markUndoPoint();
        StringBuilder b = new StringBuilder();
        int success = 0;
        int problem = 0;
        int no = 1;
        int count = operations.size();
        monitor.setTaskName("Migrating " + count + " User Components");
        for (MigrateModel.MigrationOperation op : operations) {
            if (monitor.isCanceled()) {
                throw new CancelTransactionException();
            }
            monitor.subTask("(" + no++ + "/" + count + ") " + op.toString());
            String problems = op.perform(graph);
            if (problems != null) {
                b.insert(0, problems);
                b.insert(0, String.valueOf(op.getDescription((ReadGraph)graph)) + "\n");
                ++problem;
                continue;
            }
            b.append(String.valueOf(op.getDescription((ReadGraph)graph)) + "\n");
            b.append(" success\n");
            ++success;
        }
        int total = success + problem;
        b.insert(0, "---------------------\n");
        b.insert(0, "Details:\n");
        b.insert(0, "\n");
        b.insert(0, "  OK: " + success + "\n");
        b.insert(0, "  Failure: " + problem + "\n");
        b.insert(0, "---------------------\n");
        b.insert(0, "Performed migration for " + total + " instances:\n");
        Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Migrated " + total + " instances"));
        return b.toString();
    }

    public static void doPostMigration(IProgressMonitor monitor, WriteGraph graph, ArrayList<MigrateModel.MigrationOperation> result) throws DatabaseException {
        THashSet roots = new THashSet();
        for (MigrateModel.MigrationOperation op : result) {
            Resource root = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(op.instanceToMigrate.getResource()));
            if (root == null) continue;
            roots.add((Object)root);
        }
        if (monitor.isCanceled()) {
            throw new CancelTransactionException();
        }
        for (Resource root : roots) {
            UserComponentPostMigrationAction action = (UserComponentPostMigrationAction)graph.getPossibleAdapter(root, UserComponentPostMigrationAction.class);
            if (action == null) continue;
            action.perform(monitor, graph);
        }
    }

    public static MigrateModel getComponentTypeModel(ReadGraph graph, Resource source, Resource target, Resource symbol) throws DatabaseException {
        MigrateModel model = UserComponentMigration.newMigrateModel(graph);
        MapList list = new MapList();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Instances query = (Instances)graph.adapt(source, Instances.class);
        THashSet instances = new THashSet();
        for (NamedResource nr : UserComponentMigration.getLocations(graph, Simantics.getProjectResource())) {
            Collection found = query.find(graph, nr.getResource());
            instances.addAll(found);
        }
        model.instanceCount = instances.size();
        for (Resource instance : instances) {
            String uri = graph.getPossibleURI(instance);
            Resource element = ModelingUtils.getPossibleElement(graph, instance);
            if (element == null) {
                MigrateModel.MigrationOperation op = new MigrateModel.MigrationOperation(new NamedResource(uri, instance), new NamedResource("", target), null);
                UserComponentMigration.addInstance((MapList<NamedResource, MigrateModel.MigrationOperation>)list, graph, instance, op);
                continue;
            }
            Resource instanceSymbol = graph.getPossibleType(element, DIA.Element);
            if (instanceSymbol == null) continue;
            if (symbol != null) {
                if (symbol.equals(instanceSymbol)) continue;
                MigrateModel.MigrationOperation op = new MigrateModel.MigrationOperation(new NamedResource(uri, instance), new NamedResource("", target), new NamedResource("", symbol));
                UserComponentMigration.addInstance((MapList<NamedResource, MigrateModel.MigrationOperation>)list, graph, instance, op);
                continue;
            }
            String instanceSymbolName = (String)graph.getRelatedValue(instanceSymbol, L0.HasName, (Binding)Bindings.STRING);
            Resource targetSymbol = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)target, (Resource)DIA.ElementClass, (String)instanceSymbolName);
            if (targetSymbol == null || targetSymbol.equals(instanceSymbol)) continue;
            MigrateModel.MigrationOperation op = new MigrateModel.MigrationOperation(new NamedResource(uri, instance), new NamedResource("", target), new NamedResource("", targetSymbol));
            UserComponentMigration.addInstance((MapList<NamedResource, MigrateModel.MigrationOperation>)list, graph, instance, op);
        }
        UserComponentMigration.sortInstances(model, (MapList<NamedResource, MigrateModel.MigrationOperation>)list);
        return model;
    }

    public static MigrateModel getSharedOntologyModel(ReadGraph graph, Resource sourceOntology, Resource targetOntology) throws DatabaseException {
        MigrateModel model = UserComponentMigration.newMigrateModel(graph);
        MapList list = new MapList();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        Instances query = (Instances)graph.adapt(STR.ComponentType, Instances.class);
        THashSet types = new THashSet();
        for (Resource type : query.find(graph, sourceOntology)) {
            Resource root;
            if (graph.isInheritedFrom(type, DIA.Element) || !sourceOntology.equals(root = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(type)))) continue;
            types.add(type);
        }
        THashSet instances = new THashSet();
        Collection<NamedResource> locations = UserComponentMigration.getLocations(graph, Simantics.getProjectResource());
        for (Resource type : types) {
            Instances query2 = (Instances)graph.adapt(type, Instances.class);
            for (NamedResource nr : locations) {
                Collection found = query2.find(graph, nr.getResource());
                instances.addAll(found);
            }
        }
        model.instanceCount = instances.size();
        for (Resource instance : instances) {
            Resource type = graph.getPossibleType(instance, STR.Component);
            String uri = graph.getPossibleURI(instance);
            if (type == null || uri == null) {
                System.err.println("CANNOT MIGRATE INSTANCE DUE TO TYPING PROBLEM: " + NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)instance));
                continue;
            }
            NamedResource best = UserComponentMigration.matchBest(graph, type, targetOntology);
            if (best == null) continue;
            Resource element = ModelingUtils.getPossibleElement(graph, instance);
            if (element == null) {
                MigrateModel.MigrationOperation op = new MigrateModel.MigrationOperation(new NamedResource(uri, instance), best, null);
                UserComponentMigration.addInstance((MapList<NamedResource, MigrateModel.MigrationOperation>)list, graph, instance, op);
                continue;
            }
            Resource instanceSymbol = graph.getPossibleType(element, DIA.Element);
            if (instanceSymbol == null) continue;
            String instanceSymbolName = (String)graph.getRelatedValue(instanceSymbol, L0.HasName, (Binding)Bindings.STRING);
            Resource targetSymbol = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)best.getResource(), (Resource)DIA.ElementClass, (String)instanceSymbolName);
            if (targetSymbol == null || targetSymbol.equals(instanceSymbol)) continue;
            MigrateModel.MigrationOperation op = new MigrateModel.MigrationOperation(new NamedResource(uri, instance), best, new NamedResource("", targetSymbol));
            UserComponentMigration.addInstance((MapList<NamedResource, MigrateModel.MigrationOperation>)list, graph, instance, op);
        }
        UserComponentMigration.sortInstances(model, (MapList<NamedResource, MigrateModel.MigrationOperation>)list);
        return model;
    }

    private static Collection<NamedResource> getLocations(ReadGraph graph, Resource project) throws DatabaseException {
        ArrayList<NamedResource> libraries = new ArrayList<NamedResource>();
        for (Resource r : (Collection)graph.syncRequest((Read)new ListIndexRoots())) {
            String name = Versions.getStandardNameString((ReadGraph)graph, (Resource)r);
            libraries.add(new NamedResource(name, r));
        }
        return libraries;
    }

    private static void sortInstances(MigrateModel model, MapList<NamedResource, MigrateModel.MigrationOperation> list) {
        ArrayList keys = new ArrayList(list.getKeys());
        Collections.sort(keys, NAMED_RESOURCE_COMPARATOR);
        for (NamedResource key : keys) {
            List ops = list.getValuesSnapshot((Object)key);
            String[] parts = key.getName().split("#");
            model.instances.add((Triple<String, NamedResource, Collection<MigrateModel.MigrationOperation>>)Triple.make((Object)parts[0], (Object)new NamedResource(URIStringUtils.unescape((String)parts[1]), key.getResource()), (Object)ops));
        }
    }

    private static Pair<String, Integer> addInstance(MapList<NamedResource, MigrateModel.MigrationOperation> list, ReadGraph graph, Resource instance, MigrateModel.MigrationOperation op) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(instance, L0.IndexRoot)) {
            return Pair.make((Object)"", (Object)0);
        }
        if ((instance = graph.getPossibleObject(instance, L0.PartOf)) == null) {
            return Pair.make((Object)"", (Object)0);
        }
        String name = Versions.getStandardNameString((ReadGraph)graph, (Resource)instance);
        String escapedName = URIStringUtils.escape((String)name);
        Pair<String, Integer> parent = UserComponentMigration.addInstance(list, graph, instance, op);
        StringBuilder code = new StringBuilder((String)parent.first).append('/').append(escapedName).append('#');
        int i = 0;
        while (i < (Integer)parent.second) {
            code.append(' ');
            ++i;
        }
        code.append(escapedName);
        list.add((Object)new NamedResource(code.toString(), instance), (Object)op);
        return Pair.make((Object)(String.valueOf((String)parent.first) + "/" + escapedName), (Object)((Integer)parent.second + 4));
    }

    private static NamedResource matchBest(ReadGraph graph, Resource type, Resource newOntology) throws DatabaseException {
        VersionMap versions = Versions.match((ReadGraph)graph, (Resource)type, (Resource)newOntology);
        return versions.getNewest(graph, Versions.getBaseName((ReadGraph)graph, (Resource)type));
    }

    private static MigrateModel newMigrateModel(ReadGraph graph) throws DatabaseException {
        MigrateModel model = new MigrateModel();
        model.activeModels.addAll((Collection)graph.syncRequest((Read)new ActiveModels(Simantics.getProjectResource())));
        return model;
    }
}

