/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.element.handler.impl;

import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.Pick;
import org.simantics.g2d.utils.PathUtils;

public class ShapePick
implements Pick {
    public static final ShapePick INSTANCE = new ShapePick();
    private static final long serialVersionUID = 1L;

    @Override
    public boolean pickTest(IElement e, Shape s, PickRequest.PickPolicy policy) {
        Rectangle2D pickRect = null;
        pickRect = s instanceof Rectangle2D ? (Rectangle2D)s : s.getBounds2D();
        Shape es = ElementUtils.getElementShapeOrBounds(e);
        PathIterator iter = es.getPathIterator(null);
        ArrayList<double[]> segments = new ArrayList<double[]>();
        PathUtils.toLineSegments(iter, segments);
        switch (policy) {
            case PICK_CONTAINED_OBJECTS: {
                for (double[] seg : segments) {
                    if (pickRect.contains(seg[0], seg[1]) && pickRect.contains(seg[2], seg[3])) continue;
                    return false;
                }
                return true;
            }
            case PICK_INTERSECTING_OBJECTS: {
                for (double[] seg : segments) {
                    if (!pickRect.intersectsLine(seg[0], seg[1], seg[2], seg[3])) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }
}

