/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.element;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.simantics.g2d.diagram.impl.AbstractHandlerClass;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.Transform;

public final class ElementClass
extends AbstractHandlerClass<ElementHandler> {
    private static final long serialVersionUID = -446421782709451743L;
    private static final Class<?>[] REQUIRED_HANDLERS = new Class[]{Transform.class, InternalSize.class};
    private String id = "";

    public static ElementClass compile(Collection<ElementHandler> contributions) {
        ElementClass.assertClassValid(contributions);
        return new ElementClass(contributions);
    }

    public static ElementClass compile(Collection<ElementHandler> contributions, boolean check) {
        if (check) {
            ElementClass.assertClassValid(contributions);
        }
        return new ElementClass(contributions, check);
    }

    public static ElementClass compile(ElementHandler ... contributions) {
        if (contributions.length == 0) {
            return new ElementClass((Collection<ElementHandler>)Arrays.asList(contributions));
        }
        ArrayList<ElementHandler> al = new ArrayList<ElementHandler>(contributions.length);
        ElementHandler[] elementHandlerArray = contributions;
        int n = contributions.length;
        int n2 = 0;
        while (n2 < n) {
            ElementHandler eh = elementHandlerArray[n2];
            al.add(eh);
            ++n2;
        }
        return new ElementClass((Collection<ElementHandler>)al);
    }

    ElementClass(Collection<ElementHandler> contributions) {
        super(contributions);
        ElementClass.assertClassValid(contributions);
    }

    ElementClass(Collection<ElementHandler> contributions, boolean check) {
        super(contributions);
        if (check) {
            ElementClass.assertClassValid(contributions);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void assertClassValid(Collection<ElementHandler> contributions) {
        void var2_6;
        Class<?>[] classArray = REQUIRED_HANDLERS;
        int n = REQUIRED_HANDLERS.length;
        boolean n2 = false;
        while (var2_6 < n) {
            block6: {
                Class<?> requiredClass = classArray[var2_6];
                for (ElementHandler eh : contributions) {
                    if (!requiredClass.isInstance(eh)) {
                        continue;
                    }
                    break block6;
                }
                throw new Error("Element class does not implement " + requiredClass.getName());
            }
            ++var2_6;
        }
        HashSet<Class<ElementHandler>> implementedHandlerInterfaces = new HashSet<Class<ElementHandler>>();
        for (ElementHandler elementHandler : contributions) {
            ElementClass._traverseElementHandlerInterfaces(elementHandler.getClass(), implementedHandlerInterfaces);
        }
        for (Class clazz : implementedHandlerInterfaces) {
            if (!ElementClass._isSingletonHandler(clazz)) continue;
            int implementationCount = 0;
            for (ElementHandler eh : contributions) {
                if (!clazz.isInstance(eh)) continue;
                ++implementationCount;
            }
            if (implementationCount <= true) continue;
            throw new Error("Element class has " + implementationCount + " implementations to a _singleton_ element handler \"" + clazz.getName() + "\": " + contributions);
        }
    }

    private static boolean _isSingletonHandler(Class<ElementHandler> elementHandlerClass) {
        Single s = elementHandlerClass.getAnnotation(Single.class);
        return s != null;
    }

    private static void _traverseElementHandlerInterfaces(Class<?> clazz, Collection<Class<ElementHandler>> result) {
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> inf = classArray[n2];
            if (ElementHandler.class.isAssignableFrom(inf)) {
                result.add(inf);
            }
            ++n2;
        }
        Class<?> superType = clazz.getSuperclass();
        if (superType != null) {
            ElementClass._traverseElementHandlerInterfaces(superType, result);
        }
    }

    public String toString() {
        if (!this.id.isEmpty()) {
            return this.id;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int i = 0;
        for (ElementHandler eh : super.getAll()) {
            if (i++ > 0) {
                sb.append(", ");
            }
            sb.append(eh.getClass().getSimpleName());
        }
        sb.append("]");
        return sb.toString();
    }

    public ElementClass newClassWith(ElementHandler ... addedHandlers) {
        if (addedHandlers.length == 0) {
            return this;
        }
        ArrayList<ElementHandler> newHandlers = new ArrayList<ElementHandler>(this.getAll());
        ElementHandler[] elementHandlerArray = addedHandlers;
        int n = addedHandlers.length;
        int n2 = 0;
        while (n2 < n) {
            ElementHandler h = elementHandlerArray[n2];
            newHandlers.add(h);
            ++n2;
        }
        return ElementClass.compile(newHandlers).setId(this.id);
    }

    public ElementClass newClassWith(boolean check, ElementHandler ... addedHandlers) {
        if (addedHandlers.length == 0) {
            return this;
        }
        ArrayList<ElementHandler> newHandlers = new ArrayList<ElementHandler>(this.getAll());
        ElementHandler[] elementHandlerArray = addedHandlers;
        int n = addedHandlers.length;
        int n2 = 0;
        while (n2 < n) {
            ElementHandler h = elementHandlerArray[n2];
            newHandlers.add(h);
            ++n2;
        }
        return ElementClass.compile(newHandlers, check).setId(this.id);
    }

    public ElementClass newClassWith(Collection<ElementHandler> addedHandlers) {
        if (addedHandlers.isEmpty()) {
            return this;
        }
        ArrayList<ElementHandler> newHandlers = new ArrayList<ElementHandler>(this.getAll());
        newHandlers.addAll(addedHandlers);
        return ElementClass.compile(newHandlers).setId(this.id);
    }

    public ElementClass setId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Required {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Single {
    }
}

