/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.chassis;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.image.VolatileImage;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.IContentContext;
import org.simantics.g2d.canvas.IMouseCursorContext;
import org.simantics.g2d.canvas.IMouseCursorListener;
import org.simantics.g2d.chassis.AWTTooltipProvider;
import org.simantics.g2d.chassis.Holder;
import org.simantics.g2d.chassis.ICanvasChassis;
import org.simantics.g2d.chassis.IChassisListener;
import org.simantics.g2d.dnd.DragInteractor;
import org.simantics.g2d.dnd.DropInteractor;
import org.simantics.g2d.internal.DebugPolicy;
import org.simantics.scenegraph.g2d.G2DRenderingHints;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.IEventQueue;
import org.simantics.scenegraph.g2d.events.adapter.AWTFocusAdapter;
import org.simantics.scenegraph.g2d.events.adapter.AWTKeyEventAdapter;
import org.simantics.scenegraph.g2d.events.adapter.AWTMouseEventAdapter;
import org.simantics.utils.datastructures.hints.HintContext;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.Executable;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.SyncListenerList;
import org.simantics.utils.threads.ThreadUtils;

public class AWTChassis
extends JComponent
implements ICanvasChassis {
    private static final long serialVersionUID = 1L;
    protected IHintContext hintCtx = new HintContext();
    protected SyncListenerList<IChassisListener> listeners = new SyncListenerList(IChassisListener.class);
    protected DropInteractor drop;
    protected DragInteractor drag;
    AWTMouseEventAdapter mouseAdapter;
    AWTKeyEventAdapter keyAdapter;
    AWTFocusAdapter focusAdapter;
    Container holder = null;
    IMouseCursorListener cursorListener = new IMouseCursorListener(){

        @Override
        public void onCursorSet(IMouseCursorContext sender, int mouseId, Cursor cursor) {
            if (mouseId == 0) {
                AWTChassis.this.setCursor(cursor);
            }
        }
    };
    private transient boolean dirty = false;
    private transient boolean closed = false;
    protected ICanvasContext canvasContext;
    private boolean useVolatileImage = true;
    protected IContentContext.IContentListener contentListener = new IContentContext.IContentListener(){

        @Override
        public void onDirty(IContentContext sender) {
            AWTChassis.this.dirty = true;
            ICanvasContext ctx = AWTChassis.this.canvasContext;
            if (ctx == null) {
                return;
            }
            if (ctx.getEventQueue().isEmpty()) {
                RepaintManager rm = RepaintManager.currentManager(AWTChassis.this);
                rm.markCompletelyDirty(AWTChassis.this);
            }
        }
    };
    protected IEventQueue.IEventQueueListener queueListener = new IEventQueue.IEventQueueListener(){

        public void onEventAdded(IEventQueue queue, Event e, int index) {
        }

        public void onQueueEmpty(IEventQueue queue) {
            if (AWTChassis.this.dirty) {
                RepaintManager rm = RepaintManager.currentManager(AWTChassis.this);
                rm.markCompletelyDirty(AWTChassis.this);
            }
        }
    };
    protected boolean hookKeyEvents;
    private VolatileImage buffer = null;
    private static final Method CLOSED_METHOD = SyncListenerList.getMethod(IChassisListener.class, (String)"chassisClosed");

    public AWTChassis() {
        this(true);
    }

    public AWTChassis(boolean hookKeyEvents) {
        this.setFocusable(true);
        this.hookKeyEvents = hookKeyEvents;
        this.setDoubleBuffered(false);
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
    }

    @Override
    public void setCanvasContext(final ICanvasContext canvasContext) {
        if (this.canvasContext == canvasContext) {
            return;
        }
        if (this.canvasContext != null) {
            this.canvasContext.getHintStack().removeHintContext(this.hintCtx);
            this.canvasContext.getContentContext().removePaintableContextListener(this.contentListener);
            this.canvasContext.getEventQueue().removeQueueListener(this.queueListener);
            this.canvasContext.getMouseCursorContext().removeCursorListener(this.cursorListener);
            this.canvasContext.remove(this.drop);
            this.canvasContext.remove(this.drag);
            this.removeMouseListener((MouseListener)this.mouseAdapter);
            this.removeMouseMotionListener((MouseMotionListener)this.mouseAdapter);
            this.removeMouseWheelListener((MouseWheelListener)this.mouseAdapter);
            if (this.hookKeyEvents) {
                this.removeKeyListener((KeyListener)this.keyAdapter);
            }
            this.removeFocusListener((FocusListener)this.focusAdapter);
            this.removeMouseListener((MouseListener)this.canvasContext.getSceneGraph().getEventDelegator());
            this.removeMouseMotionListener((MouseMotionListener)this.canvasContext.getSceneGraph().getEventDelegator());
            this.removeMouseWheelListener((MouseWheelListener)this.canvasContext.getSceneGraph().getEventDelegator());
            this.removeKeyListener((KeyListener)this.canvasContext.getSceneGraph().getEventDelegator());
            this.removeFocusListener((FocusListener)this.canvasContext.getSceneGraph().getEventDelegator());
            this.canvasContext.setTooltipProvider(null);
            this.canvasContext = null;
            this.focusAdapter = null;
            this.mouseAdapter = null;
            this.keyAdapter = null;
            this.drop = null;
            this.drag = null;
            this.holder = null;
            this.removeAll();
        }
        this.canvasContext = canvasContext;
        if (canvasContext != null) {
            this.addMouseListener((MouseListener)canvasContext.getSceneGraph().getEventDelegator());
            this.addMouseMotionListener((MouseMotionListener)canvasContext.getSceneGraph().getEventDelegator());
            this.addMouseWheelListener((MouseWheelListener)canvasContext.getSceneGraph().getEventDelegator());
            this.addKeyListener((KeyListener)canvasContext.getSceneGraph().getEventDelegator());
            this.addFocusListener((FocusListener)canvasContext.getSceneGraph().getEventDelegator());
            canvasContext.setTooltipProvider(new AWTTooltipProvider());
            canvasContext.getHintStack().addHintContext(this.hintCtx, 0);
            canvasContext.getContentContext().addPaintableContextListener(this.contentListener);
            canvasContext.getEventQueue().addQueueListener(this.queueListener);
            canvasContext.getMouseCursorContext().addCursorListener(this.cursorListener);
            this.mouseAdapter = new AWTMouseEventAdapter((Object)canvasContext, canvasContext.getEventQueue());
            if (this.hookKeyEvents) {
                this.keyAdapter = new AWTKeyEventAdapter((Object)canvasContext, canvasContext.getEventQueue());
                this.addKeyListener((KeyListener)this.keyAdapter);
            }
            this.focusAdapter = new AWTFocusAdapter((Object)canvasContext, canvasContext.getEventQueue());
            this.addMouseListener((MouseListener)this.mouseAdapter);
            this.addMouseMotionListener((MouseMotionListener)this.mouseAdapter);
            this.addMouseWheelListener((MouseWheelListener)this.mouseAdapter);
            this.addFocusListener((FocusListener)this.focusAdapter);
            this.drag = new DragInteractor(this);
            canvasContext.add(this.drag);
            this.drop = new DropInteractor(this);
            canvasContext.add(this.drop);
            Runnable initializeHolder = new Runnable(){

                @Override
                public void run() {
                    if (canvasContext.isDisposed()) {
                        return;
                    }
                    if (AWTChassis.this.holder == null) {
                        AWTChassis.this.holder = new Holder();
                        AWTChassis.this.holder.setSize(1, 1);
                        AWTChassis.this.holder.setLocation(0, 0);
                        AWTChassis.this.holder.setFocusable(false);
                        AWTChassis.this.holder.setEnabled(true);
                        AWTChassis.this.holder.setVisible(true);
                        AWTChassis.this.holder.addMouseListener((MouseListener)canvasContext.getSceneGraph().getEventDelegator());
                        AWTChassis.this.holder.addMouseMotionListener((MouseMotionListener)canvasContext.getSceneGraph().getEventDelegator());
                        AWTChassis.this.holder.addMouseWheelListener((MouseWheelListener)canvasContext.getSceneGraph().getEventDelegator());
                        AWTChassis.this.holder.addKeyListener((KeyListener)canvasContext.getSceneGraph().getEventDelegator());
                        AWTChassis.this.holder.addFocusListener((FocusListener)canvasContext.getSceneGraph().getEventDelegator());
                        AWTChassis.this.add(AWTChassis.this.holder);
                    }
                    canvasContext.getSceneGraph().setRootPane(AWTChassis.this.holder, (Component)AWTChassis.this);
                    AWTChassis.this.holder.addMouseListener((MouseListener)AWTChassis.this.mouseAdapter);
                    AWTChassis.this.holder.addMouseMotionListener((MouseMotionListener)AWTChassis.this.mouseAdapter);
                    AWTChassis.this.holder.addMouseWheelListener((MouseWheelListener)AWTChassis.this.mouseAdapter);
                    AWTChassis.this.holder.addFocusListener((FocusListener)AWTChassis.this.focusAdapter);
                }
            };
            if (AWTThread.getThreadAccess().currentThreadAccess()) {
                initializeHolder.run();
            } else {
                AWTThread.getThreadAccess().asyncExec(initializeHolder);
            }
        }
        this.buffer = null;
        this.repaint();
    }

    @Override
    public ICanvasContext getCanvasContext() {
        return this.canvasContext;
    }

    @Override
    public void addChassisListener(IThreadWorkQueue thread, IChassisListener listener) {
        this.listeners.add(thread, (Object)listener);
    }

    @Override
    public void removeChassisListener(IThreadWorkQueue thread, IChassisListener listener) {
        this.listeners.remove(thread, (Object)listener);
    }

    @Override
    public void addChassisListener(IChassisListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeChassisListener(IChassisListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public IHintContext getHintContext() {
        return this.hintCtx;
    }

    public void setUseVolatileImage(boolean useVolatileImage) {
        this.useVolatileImage = useVolatileImage;
    }

    public boolean isUseVolatileImage() {
        return this.useVolatileImage;
    }

    private void paintScenegraph(Graphics2D g2d, Rectangle controlBounds) {
        Color bg = this.getBackground();
        if (bg == null) {
            bg = Color.WHITE;
        }
        g2d.setBackground(bg);
        g2d.clearRect(controlBounds.x, controlBounds.y, controlBounds.width, controlBounds.height);
        g2d.setClip(controlBounds.x, controlBounds.y, controlBounds.width, controlBounds.height);
        g2d.setRenderingHint((RenderingHints.Key)G2DRenderingHints.KEY_CONTROL_BOUNDS, controlBounds);
        if (!this.canvasContext.isLocked()) {
            this.canvasContext.getSceneGraph().render(g2d);
        }
    }

    private VolatileImage paintToVolatileImage(Graphics2D g2d, Rectangle b) {
        int attempts = 0;
        do {
            if (this.closed || attempts >= 10) {
                return null;
            }
            if (this.buffer == null || b.width != this.buffer.getWidth() || b.height != this.buffer.getHeight() || this.buffer.validate(g2d.getDeviceConfiguration()) == 2) {
                this.buffer = this.createVolatileImage(b.width, b.height);
            }
            if (this.buffer == null) {
                return null;
            }
            Graphics2D bg = this.buffer.createGraphics();
            this.paintScenegraph(bg, b);
            bg.dispose();
            ++attempts;
        } while (this.buffer.contentsLost());
        return this.buffer;
    }

    @Override
    public void paintComponent(Graphics g) {
        this.dirty = false;
        if (this.canvasContext == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        Rectangle b = this.getBounds();
        long startmem = 0L;
        long start = 0L;
        if (DebugPolicy.PERF_CHASSIS_RENDER_FRAME) {
            startmem = Runtime.getRuntime().freeMemory();
            start = System.nanoTime();
        }
        VolatileImage buffer = null;
        if (this.useVolatileImage) {
            buffer = this.paintToVolatileImage(g2d, b);
        }
        if (this.closed) {
            return;
        }
        if (DebugPolicy.PERF_CHASSIS_RENDER_FRAME) {
            long end = System.nanoTime();
            long endmem = Runtime.getRuntime().freeMemory();
            System.out.println("frame render: " + (double)(end - start) * 1.0E-6 + " ms, " + (double)(startmem - endmem) / 1048576.0 + " MB");
        }
        if (buffer != null) {
            g2d.drawImage(buffer, 0, 0, null);
        } else {
            this.paintScenegraph(g2d, b);
        }
    }

    protected void fireChassisClosed() {
        this.closed = true;
        Executable[] e = this.listeners.getExecutables(CLOSED_METHOD, new Object[]{this});
        ThreadUtils.multiSyncExec((Executable[])e);
    }

    @Override
    public boolean contains(int x, int y) {
        return super.contains(x, y);
    }
}

