/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.mapping.constraint.instructions;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.mapping.IContextualModification;
import org.simantics.mapping.constraint.instructions.IInstruction;
import org.simantics.utils.threads.logger.ITask;
import org.simantics.utils.threads.logger.ThreadLogger;

public class ProfileInstruction
implements IInstruction {
    String name;
    IInstruction instruction;

    public ProfileInstruction(String name, IInstruction instruction) {
        this.name = name;
        this.instruction = instruction;
    }

    @Override
    public IContextualModification claim(ReadGraph g, Object[] bindings) throws DatabaseException {
        ITask task = ThreadLogger.getInstance().begin(String.valueOf(this.name) + ".claim");
        final IContextualModification modi = this.instruction.claim(g, bindings);
        task.finish();
        if (modi == null) {
            return null;
        }
        return new IContextualModification(){

            @Override
            public void perform(WriteGraph g, Object[] bindings) throws DatabaseException {
                ITask task = ThreadLogger.getInstance().begin(String.valueOf(ProfileInstruction.this.name) + ".claim.perform");
                modi.perform(g, bindings);
                task.finish();
            }
        };
    }

    @Override
    public void collectVariables(TIntHashSet reads, TIntHashSet writes) {
        this.instruction.collectVariables(reads, writes);
    }

    @Override
    public IContextualModification deny(ReadGraph g, Object[] bindings) throws DatabaseException {
        ITask task = ThreadLogger.getInstance().begin(String.valueOf(this.name) + ".deny");
        final IContextualModification modi = this.instruction.deny(g, bindings);
        task.finish();
        if (modi == null) {
            return null;
        }
        return new IContextualModification(){

            @Override
            public void perform(WriteGraph g, Object[] bindings) throws DatabaseException {
                ITask task = ThreadLogger.getInstance().begin(String.valueOf(ProfileInstruction.this.name) + ".deny.perform");
                modi.perform(g, bindings);
                task.finish();
            }
        };
    }

    @Override
    public void doClaim(WriteGraph g, Object[] bindings) throws DatabaseException {
        ITask task = ThreadLogger.getInstance().begin(String.valueOf(this.name) + ".doClaim");
        this.instruction.doClaim(g, bindings);
        task.finish();
    }

    @Override
    public void doDeny(WriteGraph g, Object[] bindings) throws DatabaseException {
        ITask task = ThreadLogger.getInstance().begin(String.valueOf(this.name) + ".doDeny");
        this.instruction.doDeny(g, bindings);
        task.finish();
    }

    @Override
    public void mapVariables(TIntIntHashMap map) {
        this.instruction.mapVariables(map);
    }

    @Override
    public Object next(ReadGraph g, Object[] bindings, Object continuation) throws DatabaseException {
        return this.instruction.next(g, bindings, continuation);
    }

    @Override
    public Object query(ReadGraph g, Object[] bindings) throws DatabaseException {
        ITask task = ThreadLogger.getInstance().begin(String.valueOf(this.name) + ".query");
        Object ret = this.instruction.query(g, bindings);
        task.finish();
        return ret;
    }

    @Override
    public void toString(StringBuilder b, int indent) {
        this.instruction.toString(b, indent);
    }
}

