/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.layer0.utils.predicates;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.utils.predicates.IUnaryPredicate;
import org.simantics.layer0.utils.predicates.UnaryPredicate;

public class Disjunction
extends UnaryPredicate {
    Collection<IUnaryPredicate> predicates;

    public Disjunction(Collection<IUnaryPredicate> predicates) {
        this.predicates = predicates;
    }

    public Disjunction(IUnaryPredicate ... predicates) {
        this(Arrays.asList(predicates));
    }

    @Override
    public Collection<Resource> getResources(ReadGraph g) throws DatabaseException {
        Iterator<IUnaryPredicate> it = this.predicates.iterator();
        while (it.hasNext()) {
            Collection<Resource> result = it.next().getResources(g);
            if (result.isEmpty()) continue;
            while (it.hasNext()) {
                Collection<Resource> temp = it.next().getResources(g);
                if (temp.isEmpty()) continue;
                HashSet<Resource> merged = new HashSet<Resource>(result.size() + temp.size());
                merged.addAll(result);
                merged.addAll(temp);
                while (it.hasNext()) {
                    merged.addAll(it.next().getResources(g));
                }
                return merged;
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean has(ReadGraph g, Resource resource) throws DatabaseException {
        for (IUnaryPredicate pred : this.predicates) {
            if (!pred.has(g, resource)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsUnboundedQuery() {
        for (IUnaryPredicate pred : this.predicates) {
            if (pred.supportsUnboundedQuery()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void add(WriteGraph g, Resource r) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(WriteGraph g, Resource r) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsAddition() {
        return false;
    }

    @Override
    public boolean supportsRemoval() {
        return false;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.predicates == null ? 0 : this.predicates.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Disjunction other = (Disjunction)obj;
        return !(this.predicates == null ? other.predicates != null : !this.predicates.equals(other.predicates));
    }
}

