/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.parsing.declarations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.simantics.scl.compiler.internal.parsing.declarations.DAnnotationAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DeclarationAst;
import org.simantics.scl.compiler.internal.parsing.declarations.FundepAst;
import org.simantics.scl.compiler.internal.parsing.types.TypeAst;

public class DClassAst
extends DeclarationAst {
    public final TypeAst[] context;
    public final String name;
    public final String[] parameters;
    public final FundepAst[] fundeps;
    public final DeclarationAst[] declarations;
    private List<DAnnotationAst> annotations = Collections.emptyList();

    public DClassAst(ArrayList<TypeAst> context, String name, String[] parameters, FundepAst[] fundeps, ArrayList<DeclarationAst> declarations) {
        this.context = context.toArray(new TypeAst[context.size()]);
        this.name = name;
        this.parameters = parameters;
        this.fundeps = fundeps;
        this.declarations = declarations == null ? EMPTY_ARRAY : declarations.toArray(new DeclarationAst[declarations.size()]);
    }

    @Override
    public void toString(int indentation, StringBuilder b) {
        int i = 0;
        while (i < indentation) {
            b.append("    ");
            ++i;
        }
        b.append("class ");
        if (this.context.length > 0) {
            b.append("(");
            i = 0;
            while (i < this.context.length) {
                if (i > 0) {
                    b.append(", ");
                }
                this.context[i].toString(b);
                ++i;
            }
            b.append(") => ");
        }
        b.append(this.name);
        Object[] objectArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            String parameter = objectArray[n2];
            b.append(' ');
            b.append(parameter);
            ++n2;
        }
        if (this.declarations.length > 0) {
            b.append(" where");
            objectArray = this.declarations;
            n = this.declarations.length;
            n2 = 0;
            while (n2 < n) {
                Object declaration = objectArray[n2];
                b.append('\n');
                ((DeclarationAst)declaration).toString(indentation + 1, b);
                ++n2;
            }
        }
    }

    public void setAnnotations(List<DAnnotationAst> annotations) {
        this.annotations = annotations;
    }

    public List<DAnnotationAst> getAnnotations() {
        return this.annotations;
    }
}

