/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.compilation;

import gnu.trove.procedure.TObjectObjectProcedure;
import gnu.trove.procedure.TObjectProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.common.datatypes.Constructor;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.constants.LocalFieldConstant;
import org.simantics.scl.compiler.constants.LocalVariableConstant;
import org.simantics.scl.compiler.constants.NoRepConstant;
import org.simantics.scl.compiler.constants.SCLConstant;
import org.simantics.scl.compiler.constants.ThisConstant;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.macros.StandardMacroRule;
import org.simantics.scl.compiler.elaboration.modules.DerivedProperty;
import org.simantics.scl.compiler.elaboration.modules.InlineProperty;
import org.simantics.scl.compiler.elaboration.modules.MethodImplementation;
import org.simantics.scl.compiler.elaboration.modules.PrivateProperty;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.modules.SCLValueProperty;
import org.simantics.scl.compiler.elaboration.modules.TypeClass;
import org.simantics.scl.compiler.elaboration.modules.TypeClassInstance;
import org.simantics.scl.compiler.elaboration.modules.TypeClassMethod;
import org.simantics.scl.compiler.errors.ErrorLog;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAModule;
import org.simantics.scl.compiler.internal.codegen.types.JavaReferenceValidator;
import org.simantics.scl.compiler.internal.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.internal.codegen.types.StandardTypeConstructor;
import org.simantics.scl.compiler.internal.codegen.utils.ClassBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.CodeBuilderUtils;
import org.simantics.scl.compiler.internal.codegen.utils.CodeBuildingException;
import org.simantics.scl.compiler.internal.codegen.utils.Constants;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilderBase;
import org.simantics.scl.compiler.internal.codegen.utils.ModuleBuilder;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.internal.codegen.writer.ExternalConstant;
import org.simantics.scl.compiler.internal.codegen.writer.ModuleWriter;
import org.simantics.scl.compiler.internal.elaboration.decomposed.DecomposedExpression;
import org.simantics.scl.compiler.module.ConcreteModule;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;
import org.simantics.scl.compiler.types.util.MultiFunction;

public class CodeGeneration {
    public static final int OPTIMIZATION_PHASES = 2;
    CompilationContext compilationContext;
    ErrorLog errorLog;
    JavaReferenceValidator<Object, Object, Object, Object> validator;
    ConcreteModule module;
    ModuleBuilder moduleBuilder;
    SSAModule ssaModule;
    ExternalConstant[] externalConstants;
    Map<String, byte[]> classes;

    public CodeGeneration(CompilationContext compilationContext, JavaReferenceValidator<?, ?, ?, ?> javaReferenceValidator, ConcreteModule module) {
        this.compilationContext = compilationContext;
        this.errorLog = compilationContext.errorLog;
        this.module = module;
        this.validator = javaReferenceValidator;
        this.moduleBuilder = new ModuleBuilder(compilationContext.namingPolicy, compilationContext.javaTypeTranslator);
    }

    public void simplifyValues() {
        SCLValue value;
        SCLValue[] valueArray;
        Collection<SCLValue> values = this.module.getValues();
        SimplificationContext simplificationContext = new SimplificationContext(this.compilationContext, this.validator);
        SCLValue[] sCLValueArray = valueArray = values.toArray(new SCLValue[values.size()]);
        int n = valueArray.length;
        int n2 = 0;
        while (n2 < n) {
            value = sCLValueArray[n2];
            if (value.getMacroRule() instanceof StandardMacroRule) {
                StandardMacroRule rule = (StandardMacroRule)value.getMacroRule();
                rule.setBaseExpression(value.getExpression().copy());
            }
            ++n2;
        }
        sCLValueArray = valueArray;
        n = valueArray.length;
        n2 = 0;
        while (n2 < n) {
            value = sCLValueArray[n2];
            value.getSimplifiedExpression(simplificationContext);
            ++n2;
        }
    }

    public void convertToSSA() {
        Expression expression;
        ModuleWriter mw = new ModuleWriter(this.compilationContext.namingPolicy.getModuleClassName());
        for (SCLValue value : this.module.getValues()) {
            expression = value.getExpression();
            if (expression == null) continue;
            Name name = value.getName();
            SCLConstant constant = new SCLConstant(name, value.getType());
            value.setValue(constant);
            boolean isDerived = false;
            for (SCLValueProperty prop : value.getProperties()) {
                if (prop instanceof InlineProperty) {
                    InlineProperty inlineProperty = (InlineProperty)prop;
                    constant.setInlineArity(inlineProperty.arity, inlineProperty.phaseMask);
                    continue;
                }
                if (prop == PrivateProperty.INSTANCE) {
                    constant.setPrivate(!isDerived);
                    continue;
                }
                if (prop != DerivedProperty.INSTANCE) continue;
                constant.setPrivate(false);
                isDerived = true;
            }
        }
        for (SCLValue value : this.module.getValues()) {
            try {
                expression = value.getExpression();
                if (expression == null) continue;
                DecomposedExpression decomposed = DecomposedExpression.decompose(this.errorLog, expression);
                CodeWriter w = mw.createFunction((SCLConstant)value.getValue(), decomposed.typeParameters, decomposed.effect, decomposed.returnType, decomposed.parameterTypes);
                if (value.getValue() instanceof SCLConstant) {
                    ((SCLConstant)value.getValue()).setDefinition(w.getFunction());
                }
                IVal[] parameterVals = w.getParameters();
                int i = 0;
                while (i < decomposed.parameters.length) {
                    decomposed.parameters[i].setVal(parameterVals[i]);
                    ++i;
                }
                w.return_(decomposed.body.toVal(this.compilationContext, w));
            }
            catch (RuntimeException e) {
                long location = value.getExpression().location;
                if (location == 9223372034707292160L) {
                    location = value.definitionLocation;
                }
                this.errorLog.setExceptionPosition(location);
                throw e;
            }
        }
        this.ssaModule = mw.getModule();
        this.externalConstants = mw.getExternalConstants();
    }

    public void optimizeSSA() {
        int optCount = 0;
        int phase = 0;
        while (phase < 2) {
            while (optCount++ < 100 && this.ssaModule.simplify(this.compilationContext.environment, phase)) {
            }
            if (phase == 0) {
                this.ssaModule.saveInlinableDefinitions();
            }
            ++phase;
        }
        this.ssaModule.lambdaLift(this.errorLog);
        this.ssaModule.markGenerateOnFly();
    }

    public void generateCode() {
        try {
            this.ssaModule.generateCode(this.moduleBuilder);
        }
        catch (CodeBuildingException e) {
            this.errorLog.log(e.getMessage());
        }
        this.classes = this.moduleBuilder.getClasses();
    }

    public void generateDataTypes(ArrayList<StandardTypeConstructor> dataTypes) {
        for (StandardTypeConstructor dataType : dataTypes) {
            if (dataType.external) continue;
            if (dataType.constructors.length == 1) {
                Constructor constructor = dataType.constructors[0];
                if (constructor.parameterTypes.length == 1) continue;
                String javaName = MethodBuilderBase.getClassName(dataType.getTypeDesc());
                ClassBuilder cf = new ClassBuilder(this.moduleBuilder, 1, javaName, "java/lang/Object", new String[0]);
                cf.setSourceFile("_SCL_DataType");
                CodeBuilderUtils.makeRecord(cf, constructor.name.name, 17, "c", this.compilationContext.javaTypeTranslator.toTypeDescs(constructor.parameterTypes), true);
                this.moduleBuilder.addClass(cf);
                continue;
            }
            String javaName = MethodBuilderBase.getClassName(dataType.getTypeDesc());
            ClassBuilder cf = new ClassBuilder(this.moduleBuilder, 1025, javaName, "java/lang/Object", new String[0]);
            cf.setSourceFile("_SCL_DataType");
            cf.addDefaultConstructor();
            this.moduleBuilder.addClass(cf);
            Constructor[] constructorArray = dataType.constructors;
            int n = dataType.constructors.length;
            int n2 = 0;
            while (n2 < n) {
                Constructor constructor = constructorArray[n2];
                ClassBuilder cf2 = new ClassBuilder(this.moduleBuilder, 1, constructor.javaName, javaName, new String[0]);
                cf2.setSourceFile("_SCL_DataType");
                CodeBuilderUtils.makeRecord(cf2, constructor.name.name, 17, "c", this.compilationContext.javaTypeTranslator.toTypeDescs(constructor.parameterTypes), true);
                this.moduleBuilder.addClass(cf2);
                ++n2;
            }
        }
    }

    public void generateTypeClasses() {
        for (TypeClass typeClass : this.module.getTypeClasses()) {
            final JavaTypeTranslator javaTypeTranslator = this.moduleBuilder.getJavaTypeTranslator();
            final ClassBuilder cf = new ClassBuilder(this.moduleBuilder, 513, typeClass.javaName, "java/lang/Object", new String[0]);
            int i = 0;
            while (i < typeClass.context.length) {
                TPred sup = typeClass.context[i];
                cf.addAbstractMethod(1025, "super" + i, javaTypeTranslator.toTypeDesc(sup), Constants.EMPTY_TYPEDESC_ARRAY);
                ++i;
            }
            typeClass.methods.forEachValue((TObjectProcedure)new TObjectProcedure<TypeClassMethod>(){

                public boolean execute(TypeClassMethod method) {
                    MultiFunction mfun;
                    try {
                        mfun = Types.matchFunction(method.getBaseType(), method.getArity());
                    }
                    catch (MatchException matchException) {
                        throw new InternalCompilerError("Method " + method.getName() + " has too high arity.");
                    }
                    cf.addAbstractMethod(1025, method.getJavaName(), javaTypeTranslator.toTypeDesc(mfun.returnType), JavaTypeTranslator.filterVoid(javaTypeTranslator.toTypeDescs(mfun.parameterTypes)));
                    return true;
                }
            });
            this.moduleBuilder.addClass(cf);
        }
    }

    public void generateTypeClassInstances() {
        this.module.getTypeInstances().forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<TCon, ArrayList<TypeClassInstance>>(){

            public boolean execute(TCon typeClass, ArrayList<TypeClassInstance> instances) {
                for (TypeClassInstance instance : instances) {
                    CodeGeneration.this.generateTypeClassInstance(instance);
                }
                return true;
            }
        });
    }

    private void generateTypeClassInstance(final TypeClassInstance instance) {
        final JavaTypeTranslator javaTypeTranslator = this.moduleBuilder.getJavaTypeTranslator();
        final ClassBuilder cb = new ClassBuilder(this.moduleBuilder, 1, instance.javaName, "java/lang/Object", instance.typeClass.javaName);
        cb.setSourceFile("_SCL_TypeClassInstance");
        CodeBuilderUtils.makeRecord(cb, instance.javaName, 2, "cx", javaTypeTranslator.toTypeDescs(instance.context), false);
        int i = 0;
        while (i < instance.superExpressions.length) {
            TypeDesc returnTypeDesc = javaTypeTranslator.toTypeDesc(instance.typeClass.context[i]);
            MethodBuilder mb = cb.addMethod(1, "super" + i, returnTypeDesc, Constants.EMPTY_TYPEDESC_ARRAY);
            Val[] parameters = new Val[instance.context.length];
            int j = 0;
            while (j < instance.context.length) {
                parameters[j] = new LocalFieldConstant(instance.context[j], "cx" + j);
                ++j;
            }
            instance.superExpressions[i].getValue().apply(mb, Type.EMPTY_ARRAY, parameters);
            mb.returnValue(returnTypeDesc);
            mb.finish();
            ++i;
        }
        instance.typeClass.methods.forEachValue((TObjectProcedure)new TObjectProcedure<TypeClassMethod>(){

            public boolean execute(TypeClassMethod method) {
                MultiFunction mfun;
                Type baseType = method.getBaseType();
                try {
                    mfun = Types.matchFunction(baseType, method.getArity());
                }
                catch (MatchException matchException) {
                    throw new InternalCompilerError("Method " + method.getName() + " has too high arity.");
                }
                TypeDesc[] parameterTypeDescs = javaTypeTranslator.toTypeDescs(mfun.parameterTypes);
                TypeDesc returnTypeDesc = javaTypeTranslator.toTypeDesc(mfun.returnType);
                MethodBuilder mb = cb.addMethod(1, method.getJavaName(), returnTypeDesc, JavaTypeTranslator.filterVoid(parameterTypeDescs));
                MethodImplementation implementation = (MethodImplementation)instance.methodImplementations.get((Object)method.getName());
                if (implementation.isDefault) {
                    MultiFunction mfun2;
                    IVal function = CodeGeneration.this.compilationContext.environment.getValue(implementation.name).getValue();
                    Val[] parameters = new Val[method.getArity() + 1];
                    try {
                        mfun2 = Types.matchFunction(Types.removeForAll(function.getType()), parameters.length);
                    }
                    catch (MatchException e) {
                        throw new InternalCompilerError(e);
                    }
                    parameters[0] = new ThisConstant(instance.instance);
                    int i = 0;
                    int j = 0;
                    while (i < method.getArity()) {
                        parameters[1 + i] = javaTypeTranslator.toTypeDesc(mfun2.parameterTypes[1 + i]).equals(TypeDesc.VOID) ? new NoRepConstant(mfun2.parameterTypes[1 + i]) : new LocalVariableConstant(mfun2.parameterTypes[1 + i], mb.getParameter(j++));
                        ++i;
                    }
                    Type returnType = function.apply(mb, Type.EMPTY_ARRAY, parameters);
                    if (returnTypeDesc == TypeDesc.OBJECT) {
                        mb.box(returnType);
                    }
                    mb.returnValue(returnTypeDesc);
                } else {
                    MultiFunction mfun2;
                    IVal function = CodeGeneration.this.module.getValue(implementation.name.name).getValue();
                    Val[] parameters = new Val[method.getArity() + instance.context.length];
                    try {
                        mfun2 = Types.matchFunction(Types.removeForAll(function.getType()), parameters.length);
                    }
                    catch (MatchException e) {
                        throw new InternalCompilerError(e);
                    }
                    int i = 0;
                    while (i < instance.context.length) {
                        parameters[i] = new LocalFieldConstant(instance.context[i], "cx" + i);
                        ++i;
                    }
                    i = 0;
                    int j = 0;
                    while (i < method.getArity()) {
                        parameters[instance.context.length + i] = javaTypeTranslator.toTypeDesc(mfun2.parameterTypes[instance.context.length + i]).equals(TypeDesc.VOID) ? new NoRepConstant(mfun2.parameterTypes[instance.context.length + i]) : new LocalVariableConstant(mfun2.parameterTypes[instance.context.length + i], mb.getParameter(j++));
                        ++i;
                    }
                    Type returnType = function.apply(mb, Type.EMPTY_ARRAY, parameters);
                    if (returnTypeDesc == TypeDesc.OBJECT) {
                        mb.box(returnType);
                    }
                    mb.returnValue(returnTypeDesc);
                }
                mb.finish();
                return true;
            }
        });
        this.moduleBuilder.addClass(cb);
    }
}

