/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.types;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Map;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.internal.types.HashCodeUtils;
import org.simantics.scl.compiler.internal.types.TypeHashCodeContext;
import org.simantics.scl.compiler.internal.types.ast.TypeAst;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TMetaVar;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.KindUnificationException;
import org.simantics.scl.compiler.types.kinds.KMetaVar;
import org.simantics.scl.compiler.types.kinds.Kind;
import org.simantics.scl.compiler.types.kinds.Kinds;
import org.simantics.scl.compiler.types.util.Polarity;
import org.simantics.scl.compiler.types.util.TypeUnparsingContext;

public abstract class Type {
    public static final boolean NULL_CHECKS = true;
    public static final Type[] EMPTY_ARRAY = new Type[0];
    public static final int FUN_ID = 0;
    public static final int APPLY_ID = 1;
    public static final int CON_ID = 2;
    public static final int FORALL_ID = 3;
    public static final int PRED_ID = 4;
    public static final int METAVAR_ID = 5;
    public static final int VAR_ID = 6;
    public static final int UNION_ID = 7;
    protected static final int APPLY_HASH = HashCodeUtils.preprocessValue(0);
    protected static final int FORALL_HASH = HashCodeUtils.preprocessValue(1);
    protected static final int FUN_HASH = HashCodeUtils.preprocessValue(2);
    protected static final int PRED_HASH = HashCodeUtils.preprocessValue(3);
    protected static final int UNION_HASH = HashCodeUtils.preprocessValue(4);
    protected static final int BOUND_VAR_HASH = HashCodeUtils.preprocessValue(5);

    Type() {
    }

    public abstract Type replace(TVar var1, Type var2);

    public Type replace(TVar[] var, Type[] replacement) {
        Type cur = this;
        int i = 0;
        while (i < var.length) {
            cur = cur.replace(var[i], replacement[i]);
            ++i;
        }
        return cur;
    }

    public <T extends Type> Type replace(THashMap<TVar, T> substitution) {
        Type cur = this;
        for (Map.Entry entry : substitution.entrySet()) {
            cur = cur.replace((TVar)entry.getKey(), (Type)entry.getValue());
        }
        return cur;
    }

    abstract TypeAst toTypeAst(TypeUnparsingContext var1);

    public String toString() {
        return this.toString(new TypeUnparsingContext());
    }

    public String toString(TypeUnparsingContext context) {
        return this.toTypeAst(context).toString();
    }

    public void toString(TypeUnparsingContext context, StringBuilder b) {
        this.toTypeAst(context).toString(b);
    }

    public void toString(TypeUnparsingContext context, StringBuilder b, int precedence) {
        this.toTypeAst(context).toString(b, precedence);
    }

    public String toName() {
        TypeUnparsingContext context = new TypeUnparsingContext();
        StringBuilder b = new StringBuilder();
        this.toName(context, b);
        return b.toString();
    }

    public abstract void toName(TypeUnparsingContext var1, StringBuilder var2);

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Type)) {
            return false;
        }
        return Types.equals(this, (Type)obj);
    }

    public int hashCode() {
        return this.hashCode(0);
    }

    public abstract void updateHashCode(TypeHashCodeContext var1);

    public abstract int hashCode(int var1);

    public abstract int hashCode(int var1, TVar[] var2);

    public int skeletonHashCode() {
        return this.skeletonHashCode(0);
    }

    public abstract int skeletonHashCode(int var1);

    public abstract int skeletonHashCode(int var1, TVar[] var2);

    public abstract void collectFreeVars(ArrayList<TVar> var1);

    public abstract void collectMetaVars(ArrayList<TMetaVar> var1);

    public abstract void collectMetaVars(THashSet<TMetaVar> var1);

    public abstract void collectEffectMetaVars(ArrayList<TMetaVar> var1);

    public abstract boolean contains(TMetaVar var1);

    public abstract Type convertMetaVarsToVars();

    public abstract boolean isGround();

    public Kind inferKind(Environment context) throws KindUnificationException {
        KMetaVar var = Kinds.metaVar();
        this.checkKind(context, var);
        return Kinds.canonical(var);
    }

    public void checkKind(Environment context, Kind requiredKind) throws KindUnificationException {
        Kind kind = this.inferKind(context);
        Kinds.unify(kind, requiredKind);
    }

    public abstract boolean containsMetaVars();

    public abstract int getClassId();

    public boolean isMinimal() {
        return true;
    }

    public boolean isMaximal() {
        return true;
    }

    public abstract void addPolarity(Polarity var1);

    public void collectConcreteEffects(ArrayList<TCon> concreteEffects) {
    }

    public abstract Type head();

    public abstract Type copySkeleton(THashMap<TMetaVar, TMetaVar> var1);

    public abstract boolean equalsCanonical(Type var1);

    public Type canonical() {
        return this;
    }

    public abstract Kind getKind(Environment var1);

    public abstract Type[] skeletonCanonicalChildren();
}

