/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.parser.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.simantics.scl.compiler.parser.generator.compression.CompressedParseTable;
import org.simantics.scl.compiler.parser.generator.grammar.AnaGrammar;
import org.simantics.scl.compiler.parser.generator.java.GenerateEnum;
import org.simantics.scl.compiler.parser.generator.java.GenerateParser;
import org.simantics.scl.compiler.parser.generator.table.ParseTable;
import org.simantics.scl.compiler.parser.generator.table.ParseTableBuilder;
import org.simantics.scl.compiler.parser.grammar.Grammar;
import org.simantics.scl.compiler.parser.grammar.input.GrammarParserImpl;

public class ParserGenerator {
    public static void createParser(String packageName, String exceptionName, File grammarFile) throws IOException {
        FileInputStream inputStream = new FileInputStream(grammarFile);
        Grammar grammar = GrammarParserImpl.read(inputStream);
        inputStream.close();
        grammar.check();
        AnaGrammar anaGrammar = new AnaGrammar(grammar);
        ParseTable table = ParseTableBuilder.build(anaGrammar);
        File directory = grammarFile.getParentFile();
        String name = grammarFile.getName();
        int p = name.lastIndexOf(46);
        if (p > 0) {
            name = name.substring(0, p);
        }
        CompressedParseTable compressedTable = table.compress();
        compressedTable.writeTo(new File(directory, String.valueOf(name) + "Parser.dat"));
        String className = String.valueOf(name) + "Terminals";
        GenerateEnum.generate(new File(directory, String.valueOf(className) + ".java"), packageName, className, anaGrammar.terminalNames);
        className = String.valueOf(name) + "Parser";
        new GenerateParser(packageName, className, anaGrammar, exceptionName, compressedTable).generate(new File(directory, String.valueOf(className) + ".java"));
    }
}

