/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.parsing.parser;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.TIntHashSet;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.internal.parsing.Token;
import org.simantics.scl.compiler.internal.parsing.exceptions.SCLSyntaxErrorException;
import org.simantics.scl.compiler.internal.parsing.parser.SCLLexer;
import org.simantics.scl.compiler.internal.parsing.parser.SCLParserOptions;

public class SCLPostLexer {
    private static final int PATCH_SIZE = 16;
    private static final int INITIAL_QUEUE_SIZE = 32;
    public static TIntHashSet INDENTABLE = new TIntHashSet();
    public static TIntHashSet NO_SEMICOLON_BEFORE = new TIntHashSet();
    public static TIntHashSet NO_SEMICOLON_AFTER = new TIntHashSet();
    SCLLexer lexer;
    Token[] queue = new Token[32];
    int queuePos = 0;
    int queueSize = 0;
    TIntArrayList indentations = new TIntArrayList();
    TIntArrayList indentationTokens = new TIntArrayList();
    Token curToken = null;
    int lineStart = 0;
    boolean firstTokenOfLine = true;
    private SCLParserOptions options;
    private boolean isFirstToken = true;
    private CompilationContext context;
    private boolean isInsideModule = false;

    static {
        INDENTABLE.add(12);
        INDENTABLE.add(80);
        INDENTABLE.add(69);
        INDENTABLE.add(49);
        INDENTABLE.add(50);
        INDENTABLE.add(46);
        INDENTABLE.add(51);
        INDENTABLE.add(57);
        INDENTABLE.add(28);
        INDENTABLE.add(63);
        INDENTABLE.add(45);
        INDENTABLE.add(77);
        NO_SEMICOLON_BEFORE.add(84);
        NO_SEMICOLON_BEFORE.add(39);
        NO_SEMICOLON_BEFORE.add(67);
        NO_SEMICOLON_BEFORE.add(68);
        NO_SEMICOLON_BEFORE.add(66);
        NO_SEMICOLON_BEFORE.add(2);
        NO_SEMICOLON_BEFORE.add(70);
        NO_SEMICOLON_BEFORE.add(34);
        NO_SEMICOLON_BEFORE.add(0);
        NO_SEMICOLON_AFTER.add(84);
        NO_SEMICOLON_AFTER.add(39);
    }

    public SCLPostLexer(SCLLexer lexer) {
        this.indentations.add(0);
        this.indentationTokens.add(84);
        this.lexer = lexer;
    }

    public SCLPostLexer(Reader in) {
        this(new SCLLexer(in));
    }

    public void setCompilationContext(CompilationContext context) {
        this.lexer.setCompilationContext(context);
        this.context = context;
    }

    public Token nextToken() throws Exception {
        while (this.queuePos == this.queueSize) {
            this.fillQueue();
        }
        return this.queue[this.queuePos++];
    }

    public Token peekToken() throws Exception {
        while (this.queuePos == this.queueSize) {
            this.fillQueue();
        }
        return this.queue[this.queuePos];
    }

    private void push(Token symbol) {
        if (this.queueSize == this.queue.length) {
            this.queue = Arrays.copyOf(this.queue, this.queueSize * 2);
        }
        this.queue[this.queueSize++] = symbol;
    }

    private void fillQueue() throws Exception {
        this.queuePos = 0;
        this.queueSize = 0;
        int i = 0;
        while (i < 16) {
            this.handleToken(this.lexer.nextToken());
            if (this.isInsideModule) {
                if (this.context.header == null) break;
                this.isInsideModule = false;
            }
            ++i;
        }
    }

    private SCLSyntaxErrorException error(int start, int end, String description) {
        return new SCLSyntaxErrorException(Locations.location(start, end), description);
    }

    private void handleToken(Token symbol) throws IOException {
        int symbolId = symbol.id;
        if (symbolId == 83) {
            this.lineStart = Locations.endOf(symbol.location);
            this.firstTokenOfLine = true;
            return;
        }
        if (symbolId == 82) {
            this.firstTokenOfLine = false;
            return;
        }
        Token prevToken = this.curToken;
        int prevTokenId = prevToken == null ? 84 : prevToken.id;
        this.curToken = symbol;
        int symbolStart = Locations.beginOf(symbol.location);
        int symbolEnd = Locations.endOf(symbol.location);
        if (INDENTABLE.contains(prevTokenId) && symbolId != 1) {
            this.push(new Token(1, symbolStart, symbolStart, "implicit {"));
            int symbolIndentation = symbolStart - this.lineStart;
            this.indentations.add(symbolIndentation);
            this.indentationTokens.add(prevTokenId);
            this.firstTokenOfLine = false;
        } else if (this.firstTokenOfLine) {
            if (!NO_SEMICOLON_AFTER.contains(prevTokenId) && !NO_SEMICOLON_BEFORE.contains(symbolId)) {
                int level = symbolStart - this.lineStart;
                if (this.indentations.get(this.indentations.size() - 1) >= level) {
                    while (this.indentations.get(this.indentations.size() - 1) > level) {
                        this.indentationTokens.removeAt(this.indentations.size() - 1);
                        this.indentations.removeAt(this.indentations.size() - 1);
                        int loc = Locations.endOf(prevToken.location);
                        this.push(new Token(2, loc, loc, "implicit }"));
                    }
                    if (this.indentations.get(this.indentations.size() - 1) == level) {
                        this.push(new Token(0, symbolStart, symbolStart, "implicit ;"));
                    }
                }
            }
            this.firstTokenOfLine = false;
            if (this.isFirstToken) {
                this.isFirstToken = false;
                if (symbol.id == 7 && symbol.text.equals("module") && this.options != null && this.options.isModule) {
                    this.push(new Token(3, symbol.location, symbol.text));
                    this.isInsideModule = true;
                    return;
                }
            }
        }
        switch (symbolId) {
            case 1: 
            case 33: 
            case 46: 
            case 47: 
            case 54: 
            case 57: {
                this.indentations.add(-1);
                this.indentationTokens.add(symbolId);
                this.push(symbol);
                return;
            }
            case 67: {
                if (prevTokenId == 4) {
                    this.push(symbol);
                    break;
                }
            }
            case 2: 
            case 34: 
            case 66: 
            case 68: 
            case 70: {
                int removedToken = 84;
                while (!this.indentations.isEmpty()) {
                    removedToken = this.indentationTokens.removeAt(this.indentations.size() - 1);
                    if (this.indentations.removeAt(this.indentations.size() - 1) < 0) break;
                    long loc = prevToken != null ? Locations.location(Locations.endOf(prevToken.location), Locations.endOf(prevToken.location)) : symbol.location;
                    this.push(new Token(2, loc, "implicit }"));
                }
                if (this.indentations.isEmpty()) {
                    throw this.error(symbolStart, symbolEnd, "No corresponding opening parenthesis for '" + symbol.text + "'.");
                }
                if (symbolId == 67) {
                    if (removedToken == 57) {
                        this.curToken = symbol = new Token(77, symbol.location, symbol.text);
                    } else {
                        this.indentations.add(-1);
                        this.indentationTokens.add(67);
                    }
                }
                this.push(symbol);
                return;
            }
            case 84: {
                while (this.indentations.size() > 1 && this.indentations.get(this.indentations.size() - 1) >= 0) {
                    long loc = prevToken != null ? Locations.location(Locations.endOf(prevToken.location), Locations.endOf(prevToken.location)) : symbol.location;
                    this.push(new Token(2, loc, "implicit }"));
                    this.indentationTokens.removeAt(this.indentations.size() - 1);
                    this.indentations.removeAt(this.indentations.size() - 1);
                }
                if (this.indentations.size() > 1) {
                    throw this.error(symbolStart, symbolEnd, "Unclosed parentheses.");
                }
                this.push(symbol);
                return;
            }
            default: {
                this.push(symbol);
                return;
            }
        }
    }

    public void setParserOptions(SCLParserOptions options) {
        this.options = options;
        this.lexer.options = options;
    }
}

