/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.elaboration.constraints;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import java.util.ArrayList;
import org.simantics.scl.compiler.types.TApply;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.util.MultiApply;

public class InstanceTree<T> {
    Node<T> root;

    private static boolean isIndexable(Type type) {
        type = Types.canonical(type);
        while (true) {
            if (type instanceof TCon) {
                return true;
            }
            if (!(type instanceof TApply)) break;
            type = Types.canonical(((TApply)type).function);
        }
        return false;
    }

    private static <T> int choosePId(ArrayList<Entry<T>> entries) {
        int i;
        int arity = entries.get((int)0).types.length;
        if (arity == 1) {
            return 0;
        }
        int[] indexableCount = new int[arity];
        for (Entry<T> entry : entries) {
            i = 0;
            while (i < arity) {
                if (InstanceTree.isIndexable(entry.types[i])) {
                    int n = i;
                    indexableCount[n] = indexableCount[n] + 1;
                }
                ++i;
            }
        }
        int bestIndexableCount = indexableCount[0];
        int bestPId = 0;
        i = 1;
        while (i < arity) {
            if (indexableCount[i] > bestIndexableCount) {
                bestIndexableCount = indexableCount[i];
                bestPId = i;
            }
            ++i;
        }
        return bestPId;
    }

    private static <T> Node<T> create(ArrayList<Entry<T>> entries) {
        int pId = InstanceTree.choosePId(entries);
        THashMap map1 = new THashMap();
        ArrayList<Entry<T>> otherEntries = new ArrayList<Entry<T>>();
        for (Entry<T> entry : entries) {
            Type[] types = entry.types;
            Type type = types[pId];
            MultiApply apply = Types.matchApply(type);
            if (apply.constructor instanceof TCon) {
                ArrayList<Entry<T>> l = (ArrayList<Entry<T>>)map1.get((Object)((TCon)apply.constructor));
                if (l == null) {
                    l = new ArrayList<Entry<T>>();
                    map1.put((Object)((TCon)apply.constructor), l);
                }
                Type[] newTypes = new Type[types.length - 1 + apply.parameters.length];
                int j = 0;
                int i = 0;
                while (i < pId) {
                    newTypes[j++] = types[i];
                    ++i;
                }
                i = 0;
                while (i < apply.parameters.length) {
                    newTypes[j++] = apply.parameters[i];
                    ++i;
                }
                i = pId + 1;
                while (i < types.length) {
                    newTypes[j++] = types[i];
                    ++i;
                }
                entry.types = newTypes;
                l.add(entry);
                continue;
            }
            otherEntries.add(entry);
        }
        final THashMap map = new THashMap();
        map1.forEachEntry(new TObjectObjectProcedure<TCon, ArrayList<Entry<T>>>(){

            public boolean execute(TCon a, ArrayList<Entry<T>> b) {
                map.put((Object)a, (Object)InstanceTree.create(b));
                return true;
            }
        });
        return new SplitNode<T>(pId, map, InstanceTree.create(otherEntries));
    }

    public T get(ArrayList<Type> types) {
        return this.root.get(types);
    }

    private static class Entry<T> {
        Type[] types;
        T value;

        private Entry() {
        }
    }

    private static interface Node<T> {
        public T get(ArrayList<Type> var1);
    }

    private static class SplitNode<T>
    implements Node<T> {
        int pId;
        THashMap<TCon, Node<T>> map;
        Node<T> alternative;

        public SplitNode(int pId, THashMap<TCon, Node<T>> map, Node<T> alternative) {
            this.pId = pId;
            this.map = map;
            this.alternative = alternative;
        }

        @Override
        public T get(ArrayList<Type> types) {
            MultiApply apply = Types.matchApply(types.get(this.pId));
            Node node = (Node)this.map.get((Object)apply.constructor);
            if (node == null) {
                return null;
            }
            Type[] typeArray = apply.parameters;
            int n = apply.parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Type parameter = typeArray[n2];
                types.add(parameter);
                ++n2;
            }
            return node.get(types);
        }
    }
}

