/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions.visitors;

import gnu.trove.set.hash.THashSet;
import org.simantics.scl.compiler.elaboration.chr.CHRLiteral;
import org.simantics.scl.compiler.elaboration.chr.CHRRule;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.ECHRSelect;
import org.simantics.scl.compiler.elaboration.expressions.EFieldAccess;
import org.simantics.scl.compiler.elaboration.expressions.ELambda;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLambda;
import org.simantics.scl.compiler.elaboration.expressions.ETransformation;
import org.simantics.scl.compiler.elaboration.expressions.visitors.StandardExpressionVisitor;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class CollectEffectsVisitor
extends StandardExpressionVisitor {
    public final THashSet<Type> effects = new THashSet();

    @Override
    public void visit(EApply expression) {
        this.effects.add((Object)expression.effect);
        super.visit(expression);
    }

    @Override
    public void visit(CHRRule rule) {
        CHRLiteral literal;
        CHRLiteral[] cHRLiteralArray = rule.head.literals;
        int n = rule.head.literals.length;
        int n2 = 0;
        while (n2 < n) {
            literal = cHRLiteralArray[n2];
            super.visit(literal);
            literal.relation.collectQueryEffects(this.effects);
            ++n2;
        }
        cHRLiteralArray = rule.body.literals;
        n = rule.body.literals.length;
        n2 = 0;
        while (n2 < n) {
            literal = cHRLiteralArray[n2];
            super.visit(literal);
            literal.relation.collectEnforceEffects(this.effects);
            ++n2;
        }
    }

    @Override
    public void visit(ECHRSelect expression) {
        CHRLiteral[] cHRLiteralArray = expression.query.literals;
        int n = expression.query.literals.length;
        int n2 = 0;
        while (n2 < n) {
            CHRLiteral literal = cHRLiteralArray[n2];
            super.visit(literal);
            literal.relation.collectQueryEffects(this.effects);
            ++n2;
        }
        expression.expression.accept(this);
    }

    @Override
    public void visit(EFieldAccess expression) {
        this.effects.add((Object)Types.READ_GRAPH);
        super.visit(expression);
    }

    @Override
    public void visit(ETransformation expression) {
        this.effects.add((Object)Types.PROC);
        super.visit(expression);
    }

    @Override
    public void visit(ELambda expression) {
    }

    @Override
    public void visit(ESimpleLambda expression) {
    }

    public Type getCombinedEffect() {
        return Types.union((Type[])this.effects.toArray((Object[])new Type[this.effects.size()]));
    }
}

