/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions.printing;

import java.util.Map;
import org.simantics.scl.compiler.elaboration.chr.CHRLiteral;
import org.simantics.scl.compiler.elaboration.chr.CHRQuery;
import org.simantics.scl.compiler.elaboration.chr.CHRRule;
import org.simantics.scl.compiler.elaboration.chr.relations.CHRConstraint;
import org.simantics.scl.compiler.elaboration.expressions.Assignment;
import org.simantics.scl.compiler.elaboration.expressions.Case;
import org.simantics.scl.compiler.elaboration.expressions.EAmbiguous;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EApplyType;
import org.simantics.scl.compiler.elaboration.expressions.EAsPattern;
import org.simantics.scl.compiler.elaboration.expressions.EBinary;
import org.simantics.scl.compiler.elaboration.expressions.EBind;
import org.simantics.scl.compiler.elaboration.expressions.EBlock;
import org.simantics.scl.compiler.elaboration.expressions.ECHRRuleset;
import org.simantics.scl.compiler.elaboration.expressions.ECHRRulesetConstructor;
import org.simantics.scl.compiler.elaboration.expressions.ECHRSelect;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.ECoveringBranchPoint;
import org.simantics.scl.compiler.elaboration.expressions.EEnforce;
import org.simantics.scl.compiler.elaboration.expressions.EEquations;
import org.simantics.scl.compiler.elaboration.expressions.EError;
import org.simantics.scl.compiler.elaboration.expressions.EExternalConstant;
import org.simantics.scl.compiler.elaboration.expressions.EFieldAccess;
import org.simantics.scl.compiler.elaboration.expressions.EGetConstraint;
import org.simantics.scl.compiler.elaboration.expressions.EIf;
import org.simantics.scl.compiler.elaboration.expressions.EIntegerLiteral;
import org.simantics.scl.compiler.elaboration.expressions.ELambda;
import org.simantics.scl.compiler.elaboration.expressions.ELambdaType;
import org.simantics.scl.compiler.elaboration.expressions.ELet;
import org.simantics.scl.compiler.elaboration.expressions.EListComprehension;
import org.simantics.scl.compiler.elaboration.expressions.EListLiteral;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.EMatch;
import org.simantics.scl.compiler.elaboration.expressions.EPlaceholder;
import org.simantics.scl.compiler.elaboration.expressions.EPreLet;
import org.simantics.scl.compiler.elaboration.expressions.ERange;
import org.simantics.scl.compiler.elaboration.expressions.ERealLiteral;
import org.simantics.scl.compiler.elaboration.expressions.ERecord;
import org.simantics.scl.compiler.elaboration.expressions.ERuleset;
import org.simantics.scl.compiler.elaboration.expressions.ESelect;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLambda;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLet;
import org.simantics.scl.compiler.elaboration.expressions.EStringLiteral;
import org.simantics.scl.compiler.elaboration.expressions.ETransformation;
import org.simantics.scl.compiler.elaboration.expressions.ETypeAnnotation;
import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.EViewPattern;
import org.simantics.scl.compiler.elaboration.expressions.EWhen;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.GuardedExpression;
import org.simantics.scl.compiler.elaboration.expressions.GuardedExpressionGroup;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.java.EqRelation;
import org.simantics.scl.compiler.elaboration.java.MemberRelation;
import org.simantics.scl.compiler.elaboration.query.QAlternative;
import org.simantics.scl.compiler.elaboration.query.QAtom;
import org.simantics.scl.compiler.elaboration.query.QConjunction;
import org.simantics.scl.compiler.elaboration.query.QDisjunction;
import org.simantics.scl.compiler.elaboration.query.QExists;
import org.simantics.scl.compiler.elaboration.query.QIf;
import org.simantics.scl.compiler.elaboration.query.QMapping;
import org.simantics.scl.compiler.elaboration.query.QNegation;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.elaboration.query.QueryVisitor;
import org.simantics.scl.compiler.elaboration.rules.SectionName;
import org.simantics.scl.compiler.elaboration.rules.TransformationRule;
import org.simantics.scl.compiler.internal.parsing.Symbol;

public class ExpressionToStringVisitor
implements ExpressionVisitor,
QueryVisitor {
    StringBuilder b = new StringBuilder();
    int indentation;

    public ExpressionToStringVisitor(StringBuilder b) {
        this.b = b;
    }

    public void show(Variable variable) {
        if (variable == null) {
            this.b.append("NULL_VARIABLE");
        } else {
            this.b.append(variable.getName());
        }
    }

    private void newLine() {
        this.b.append('\n');
        int i = 0;
        while (i < this.indentation) {
            this.b.append("  ");
            ++i;
        }
    }

    public void showPar(Expression expression) {
        boolean needsPar = false;
        while (true) {
            if (expression instanceof EPlaceholder) {
                expression = ((EPlaceholder)expression).expression;
                continue;
            }
            if (expression instanceof ETypeAnnotation) {
                expression = ((ETypeAnnotation)expression).getValue();
                continue;
            }
            if (expression instanceof EApplyType) {
                expression = ((EApplyType)expression).getExpression();
                continue;
            }
            if (expression instanceof ELambdaType) {
                expression = ((ELambdaType)expression).value;
                continue;
            }
            if (!(expression instanceof ECoveringBranchPoint)) break;
            expression = ((ECoveringBranchPoint)expression).expression;
        }
        if (expression instanceof EApply || expression instanceof EIf || expression instanceof ESimpleLambda || expression instanceof ESimpleLet) {
            needsPar = true;
        }
        if (needsPar) {
            this.b.append('(');
        }
        expression.accept(this);
        if (needsPar) {
            this.b.append(')');
        }
    }

    @Override
    public void visit(EApply expression) {
        this.showPar(expression.getFunction());
        Expression[] expressionArray = expression.getParameters();
        int n = expressionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Expression parameter = expressionArray[n2];
            this.b.append(' ');
            this.showPar(parameter);
            ++n2;
        }
    }

    @Override
    public void visit(EApplyType expression) {
        expression.getExpression().accept(this);
    }

    @Override
    public void visit(EAsPattern expression) {
        this.show(expression.getVariable());
        this.b.append('@');
        this.showPar(expression.getPattern());
    }

    @Override
    public void visit(EBind expression) {
        this.b.append("EBind");
    }

    @Override
    public void visit(EConstant expression) {
        String name = expression.getValue().getName().name;
        if (Character.isJavaIdentifierStart(name.charAt(0))) {
            this.b.append(name);
        } else {
            this.b.append('(').append(name).append(')');
        }
    }

    @Override
    public void visit(EEnforce expression) {
        this.b.append("enforce ");
        expression.getQuery().accept(this);
    }

    @Override
    public void visit(EError expression) {
        this.b.append("EError");
    }

    @Override
    public void visit(EExternalConstant expression) {
        this.b.append(expression.getValue());
    }

    @Override
    public void visit(EFieldAccess expression) {
        this.b.append("EFieldAccess");
    }

    @Override
    public void visit(EGetConstraint expression) {
        this.b.append("EGetConstraint");
    }

    @Override
    public void visit(EIf expression) {
        this.b.append("if ");
        expression.condition.accept(this);
        ++this.indentation;
        this.newLine();
        this.b.append("then ");
        expression.then_.accept(this);
        if (expression.else_ != null) {
            this.newLine();
            this.b.append("else ");
            expression.else_.accept(this);
        }
        --this.indentation;
    }

    @Override
    public void visit(QIf query) {
        this.b.append("if ");
        query.condition.accept(this);
        ++this.indentation;
        this.newLine();
        this.b.append("then ");
        query.thenQuery.accept(this);
        this.newLine();
        this.b.append("else ");
        query.elseQuery.accept(this);
        --this.indentation;
    }

    @Override
    public void visit(EIntegerLiteral expression) {
        this.b.append(expression.getValue());
    }

    @Override
    public void visit(ELambda expression) {
        this.b.append('\\');
        ++this.indentation;
        Case[] caseArray = expression.getCases();
        int n = caseArray.length;
        int n2 = 0;
        while (n2 < n) {
            Case case_ = caseArray[n2];
            this.newLine();
            Expression[] expressionArray = case_.patterns;
            int n3 = case_.patterns.length;
            int n4 = 0;
            while (n4 < n3) {
                Expression pat = expressionArray[n4];
                this.showPar(pat);
                this.b.append(' ');
                ++n4;
            }
            this.b.append("-> ");
            ++this.indentation;
            case_.value.accept(this);
            --this.indentation;
            ++n2;
        }
        --this.indentation;
    }

    @Override
    public void visit(EViewPattern expression) {
        this.b.append('(');
        expression.expression.accept(this);
        this.b.append(" -> ");
        expression.pattern.accept(this);
        this.b.append(')');
    }

    @Override
    public void visit(ELambdaType expression) {
        expression.value.accept(this);
    }

    @Override
    public void visit(ELet expression) {
        this.b.append("do");
        ++this.indentation;
        this.printAsDo(expression);
        --this.indentation;
    }

    @Override
    public void visit(EListComprehension expression) {
        this.b.append("EListComprehension");
    }

    @Override
    public void visit(EListLiteral expression) {
        this.b.append('[');
        boolean first = true;
        Expression[] expressionArray = expression.getComponents();
        int n = expressionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Expression component = expressionArray[n2];
            if (first) {
                first = false;
            } else {
                this.b.append(',');
            }
            component.accept(this);
            ++n2;
        }
        this.b.append(']');
    }

    @Override
    public void visit(ELiteral expression) {
        this.b.append(expression.getValue().toString());
    }

    @Override
    public void visit(EMatch expression) {
        this.b.append("match");
        Symbol[] symbolArray = expression.getScrutinee();
        int n = symbolArray.length;
        int n2 = 0;
        while (n2 < n) {
            Expression s = symbolArray[n2];
            this.b.append(' ');
            this.showPar(s);
            ++n2;
        }
        this.b.append(" with");
        ++this.indentation;
        symbolArray = expression.getCases();
        n = symbolArray.length;
        n2 = 0;
        while (n2 < n) {
            Symbol case_ = symbolArray[n2];
            this.newLine();
            Expression[] expressionArray = ((Case)case_).patterns;
            int n3 = ((Case)case_).patterns.length;
            int n4 = 0;
            while (n4 < n3) {
                Expression pat = expressionArray[n4];
                this.showPar(pat);
                this.b.append(' ');
                ++n4;
            }
            this.b.append("-> ");
            ++this.indentation;
            ((Case)case_).value.accept(this);
            --this.indentation;
            ++n2;
        }
        --this.indentation;
    }

    @Override
    public void visit(EPlaceholder expression) {
        expression.expression.accept(this);
    }

    @Override
    public void visit(ERealLiteral expression) {
        this.b.append(expression.getValue());
    }

    @Override
    public void visit(ERuleset expression) {
        this.b.append("let\n");
        ++this.indentation;
        ERuleset.DatalogRule[] datalogRuleArray = expression.getRules();
        int n = datalogRuleArray.length;
        int n2 = 0;
        while (n2 < n) {
            ERuleset.DatalogRule rule = datalogRuleArray[n2];
            this.newLine();
            this.visit(rule);
            ++n2;
        }
        --this.indentation;
        this.b.append("\nin ");
        expression.getIn().accept(this);
    }

    @Override
    public void visit(ESelect expression) {
        this.b.append("ESelect");
    }

    @Override
    public void visit(ECHRSelect expression) {
        this.b.append("ECHRSelect");
    }

    @Override
    public void visit(ESimpleLambda expression) {
        this.b.append('\\');
        this.show(expression.getParameter());
        while (expression.getValue() instanceof ESimpleLambda) {
            expression = (ESimpleLambda)expression.getValue();
            this.b.append(' ');
            this.show(expression.getParameter());
        }
        this.b.append(" -> ");
        expression.getValue().accept(this);
    }

    @Override
    public void visit(ESimpleLet expression) {
        this.b.append("do");
        ++this.indentation;
        this.printAsDo(expression);
        --this.indentation;
    }

    private void printAsDo(Expression expression) {
        if (expression instanceof ESimpleLet) {
            ESimpleLet let = (ESimpleLet)expression;
            Variable variable = let.getVariable();
            Expression value = let.getValue();
            if (variable == null || "_".equals(variable.getName())) {
                this.printAsDo(value);
            } else {
                this.newLine();
                this.show(variable);
                this.b.append(" = ");
                value.accept(this);
            }
            this.printAsDo(let.getIn());
        } else if (expression instanceof ELet) {
            ELet let = (ELet)expression;
            Assignment[] assignmentArray = let.assignments;
            int n = let.assignments.length;
            int n2 = 0;
            while (n2 < n) {
                Assignment assignment = assignmentArray[n2];
                this.newLine();
                assignment.pattern.accept(this);
                this.b.append(" = ");
                assignment.value.accept(this);
                ++n2;
            }
            this.printAsDo(let.in);
        } else {
            this.newLine();
            expression.accept(this);
        }
    }

    @Override
    public void visit(ETransformation expression) {
        this.b.append("<transformation>");
    }

    @Override
    public void visit(ETypeAnnotation expression) {
        expression.getValue().accept(this);
    }

    @Override
    public void visit(EVar expression) {
        this.b.append(expression.name);
    }

    @Override
    public void visit(EVariable expression) {
        this.show(expression.getVariable());
    }

    @Override
    public void visit(EWhen expression) {
        this.b.append("when ");
        expression.getQuery().accept(this);
        this.b.append("\n");
        expression.getAction().accept(this);
    }

    @Override
    public void visit(GuardedExpressionGroup expression) {
        boolean first = true;
        GuardedExpression[] guardedExpressionArray = expression.expressions;
        int n = expression.expressions.length;
        int n2 = 0;
        while (n2 < n) {
            GuardedExpression gexp = guardedExpressionArray[n2];
            if (first) {
                first = false;
            } else {
                this.newLine();
            }
            this.b.append("| ");
            int i = 0;
            while (i < gexp.guards.length) {
                if (i > 0) {
                    this.b.append(", ");
                }
                gexp.guards[i].accept(this);
                ++i;
            }
            this.b.append(" = ");
            gexp.value.accept(this);
            ++n2;
        }
    }

    @Override
    public void visit(QAlternative query) {
        this.b.append("QAlternative");
    }

    @Override
    public void visit(QAtom query) {
        if (query.relation == EqRelation.INSTANCE) {
            query.parameters[0].accept(this);
            this.b.append(" = ");
            query.parameters[1].accept(this);
        } else if (query.relation == MemberRelation.INSTANCE) {
            query.parameters[0].accept(this);
            this.b.append(" <- ");
            query.parameters[1].accept(this);
        } else {
            this.b.append(query.relation);
            Expression[] expressionArray = query.parameters;
            int n = query.parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Expression parameter = expressionArray[n2];
                this.b.append(' ');
                this.showPar(parameter);
                ++n2;
            }
        }
    }

    @Override
    public void visit(QConjunction query) {
        boolean first = true;
        Query[] queryArray = query.queries;
        int n = query.queries.length;
        int n2 = 0;
        while (n2 < n) {
            Query q = queryArray[n2];
            if (first) {
                first = false;
            } else {
                this.newLine();
            }
            q.accept(this);
            ++n2;
        }
    }

    @Override
    public void visit(QDisjunction query) {
        this.b.append("QDisjunction");
    }

    @Override
    public void visit(QExists query) {
        this.b.append("QExists");
    }

    @Override
    public void visit(QNegation query) {
        this.b.append("QNegation");
    }

    @Override
    public void visit(QMapping query) {
        this.b.append(query.mappingRelation.name.name);
        Expression[] expressionArray = query.parameters;
        int n = query.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Expression parameter = expressionArray[n2];
            this.b.append(' ');
            parameter.accept(this);
            ++n2;
        }
    }

    public void visit(ERuleset.DatalogRule rule) {
        this.b.append(rule.headRelation.getName());
        Expression[] expressionArray = rule.headParameters;
        int n = rule.headParameters.length;
        int n2 = 0;
        while (n2 < n) {
            Expression parameter = expressionArray[n2];
            this.b.append(' ');
            this.showPar(parameter);
            ++n2;
        }
        this.b.append(" :-\n");
        ++this.indentation;
        rule.body.accept(this);
        --this.indentation;
    }

    public void visit(TransformationRule rule) {
        this.b.append("rule ").append(rule.name.name).append(" where");
        for (Map.Entry section : rule.sections.entrySet()) {
            this.b.append("\n@").append(((SectionName)((Object)section.getKey())).name());
            Query[] queryArray = (Query[])section.getValue();
            int n = queryArray.length;
            int n2 = 0;
            while (n2 < n) {
                Query query = queryArray[n2];
                this.b.append('\n');
                query.accept(this);
                ++n2;
            }
        }
    }

    @Override
    public void visit(ECoveringBranchPoint expression) {
        expression.expression.accept(this);
    }

    @Override
    public void visit(EEquations expression) {
        this.b.append("eq");
    }

    @Override
    public void visit(ECHRRuleset expression) {
        this.b.append("ECHRRuleset");
    }

    @Override
    public void visit(ECHRRulesetConstructor expression) {
        this.b.append("ECHRRulesetConstructor");
    }

    public void visit(CHRRule rule) {
        this.visit(rule.head);
        this.b.append(" => ");
        this.visit(rule.body);
    }

    public void visit(CHRQuery query) {
        boolean first = true;
        CHRLiteral[] cHRLiteralArray = query.literals;
        int n = query.literals.length;
        int n2 = 0;
        while (n2 < n) {
            CHRLiteral literal = cHRLiteralArray[n2];
            if (first) {
                first = false;
            } else {
                this.b.append(", ");
            }
            this.visit(literal);
            ++n2;
        }
    }

    public void visit(CHRLiteral literal) {
        if (literal.passive && literal.relation instanceof CHRConstraint) {
            this.b.append("@passive ");
        }
        if (literal.killAfterMatch) {
            this.b.append('-');
        }
        this.b.append(literal.relation);
        Expression[] expressionArray = literal.parameters;
        int n = literal.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Expression parameter = expressionArray[n2];
            this.b.append(' ');
            this.showPar(parameter);
            ++n2;
        }
    }

    @Override
    public void visit(EBinary expression) {
        this.b.append("<EBinary>");
    }

    @Override
    public void visit(EBlock expression) {
        this.b.append("<EBlock>");
    }

    @Override
    public void visit(EPreLet expression) {
        this.b.append("<EPreLet>");
    }

    @Override
    public void visit(ERange expression) {
        this.b.append('[');
        expression.from.accept(this);
        this.b.append("..");
        expression.to.accept(this);
        this.b.append(']');
    }

    @Override
    public void visit(ERecord expression) {
        this.b.append("<ERecord>");
    }

    @Override
    public void visit(EStringLiteral expression) {
        this.b.append('\"');
        int i = 0;
        while (i < expression.strings.length) {
            this.b.append(expression.strings[i]);
            if (i < expression.expressions.length) {
                this.b.append("\\(");
                expression.expressions[i].accept(this);
                this.b.append(')');
            }
            ++i;
        }
        this.b.append('\"');
    }

    @Override
    public void visit(EAmbiguous eAmbiguous) {
        this.b.append("EAmbigious");
    }
}

