/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Case;
import org.simantics.scl.compiler.elaboration.expressions.EMatch;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLambda;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.GuardedExpressionGroup;
import org.simantics.scl.compiler.elaboration.expressions.SimplifiableExpression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.types.TMetaVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;
import org.simantics.scl.compiler.types.exceptions.UnificationException;
import org.simantics.scl.compiler.types.kinds.Kinds;
import org.simantics.scl.compiler.types.util.MultiFunction;

public class ELambda
extends SimplifiableExpression {
    public Case[] cases;
    Type effect = Types.NO_EFFECTS;

    public ELambda(Case[] cases) {
        this.cases = cases;
    }

    public ELambda(Case case_) {
        this(new Case[]{case_});
    }

    public ELambda(long loc, Case ... cases) {
        super(loc);
        this.cases = cases;
    }

    public ELambda(long loc, Expression pat, Expression exp) {
        this(loc, new Case(new Expression[]{pat}, exp));
    }

    @Override
    public Expression decomposeMatching() {
        Expression[] patterns = this.cases[0].patterns;
        int arity = patterns.length;
        if (this.cases.length == 1 && !(this.cases[0].value instanceof GuardedExpressionGroup)) {
            boolean noMatchingNeeded = true;
            int i = 0;
            while (i < arity) {
                if (!(patterns[i] instanceof EVariable)) {
                    noMatchingNeeded = false;
                    break;
                }
                ++i;
            }
            if (noMatchingNeeded) {
                Expression decomposed = this.cases[0].value.decomposeMatching();
                Type effect = this.effect;
                int i2 = arity - 1;
                while (i2 >= 0) {
                    Variable var = ((EVariable)patterns[i2]).getVariable();
                    decomposed = new ESimpleLambda(this.getLocation(), var, effect, decomposed);
                    effect = Types.NO_EFFECTS;
                    --i2;
                }
                return decomposed;
            }
        }
        Variable[] vars = new Variable[arity];
        Expression[] scrutinee = new Expression[arity];
        int i = 0;
        while (i < arity) {
            vars[i] = new Variable("temp" + i);
            Type type = patterns[i].getType();
            vars[i].setType(type);
            scrutinee[i] = new EVariable(this.getLocation(), vars[i]);
            scrutinee[i].setType(type);
            ++i;
        }
        Expression decomposed = new EMatch(this.getLocation(), scrutinee, this.cases);
        Type curEffect = this.effect;
        int i3 = arity - 1;
        while (i3 >= 0) {
            decomposed = new ESimpleLambda(this.getLocation(), vars[i3], curEffect, decomposed);
            curEffect = Types.NO_EFFECTS;
            --i3;
        }
        return decomposed;
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(Types.functionE(Types.getTypes(this.cases[0].patterns), this.effect, this.cases[0].value.getType()));
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        return this.decomposeMatching().simplify(context);
    }

    @Override
    public Expression resolve(TranslationContext context) {
        Case[] caseArray = this.cases;
        int n = this.cases.length;
        int n2 = 0;
        while (n2 < n) {
            Case case_ = caseArray[n2];
            case_.resolve(context);
            ++n2;
        }
        return this;
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            Case[] caseArray = this.cases;
            int n = this.cases.length;
            int n2 = 0;
            while (n2 < n) {
                Case case_ = caseArray[n2];
                case_.setLocationDeep(loc);
                ++n2;
            }
        }
    }

    @Override
    public Expression replace(ReplaceContext context) {
        Case[] newCases = new Case[this.cases.length];
        int i = 0;
        while (i < this.cases.length) {
            newCases[i] = this.cases[i].replace(context);
            ++i;
        }
        return new ELambda(newCases);
    }

    public Case[] getCases() {
        return this.cases;
    }

    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        MultiFunction mfun;
        int arity = this.cases[0].patterns.length;
        try {
            mfun = Types.unifyFunction(requiredType, arity);
        }
        catch (UnificationException unificationException) {
            int requiredArity = Types.getArity(requiredType);
            context.getErrorLog().log(this.cases[0].getLhs(), "Arity is " + requiredArity + " but " + arity + " patterns have been given.");
            this.setType(Types.metaVar(Kinds.STAR));
            return this;
        }
        this.effect = mfun.effect;
        context.pushEffectUpperBound(this.location, mfun.effect);
        Case[] caseArray = this.cases;
        int n = this.cases.length;
        int n2 = 0;
        while (n2 < n) {
            Case case_ = caseArray[n2];
            case_.checkType(context, mfun.parameterTypes, mfun.returnType);
            ++n2;
        }
        context.popEffectUpperBound();
        return this;
    }

    @Override
    public Expression inferType(TypingContext context) {
        int arity = this.cases[0].patterns.length;
        this.effect = Types.metaVar(Kinds.EFFECT);
        context.pushEffectUpperBound(this.location, this.effect);
        Type[] parameterTypes = new Type[arity];
        int i = 0;
        while (i < parameterTypes.length) {
            parameterTypes[i] = Types.metaVar(Kinds.STAR);
            ++i;
        }
        TMetaVar requiredType = Types.metaVar(Kinds.STAR);
        Case[] caseArray = this.cases;
        int n = this.cases.length;
        int n2 = 0;
        while (n2 < n) {
            Case case_ = caseArray[n2];
            case_.checkType(context, parameterTypes, requiredType);
            ++n2;
        }
        context.popEffectUpperBound();
        return this;
    }

    @Override
    public boolean isEffectful() {
        return false;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }

    @Override
    public int getSyntacticFunctionArity() {
        int result = 0;
        Case[] caseArray = this.cases;
        int n = this.cases.length;
        int n2 = 0;
        while (n2 < n) {
            Case case_ = caseArray[n2];
            result = Math.max(result, case_.patterns.length + case_.value.getSyntacticFunctionArity());
            ++n2;
        }
        return result;
    }
}

